/*
 * Decompiled with CFR 0.152.
 */
package skin.support.content.res;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.AnyRes;
import android.support.v7.app.AppCompatDelegate;
import android.support.v7.content.res.AppCompatResources;
import android.text.TextUtils;
import android.util.TypedValue;
import skin.support.SkinCompatManager;
import skin.support.content.res.SkinCompatDrawableManager;
import skin.support.content.res.SkinCompatUserThemeManager;

public class SkinCompatResources {
    private static volatile SkinCompatResources sInstance;
    private Resources mResources;
    private String mSkinPkgName = "";
    private String mSkinName = "";
    private SkinCompatManager.SkinLoaderStrategy mStrategy;
    private boolean isDefaultSkin = true;

    private SkinCompatResources() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SkinCompatResources getInstance() {
        if (sInstance != null) return sInstance;
        Class<SkinCompatResources> clazz = SkinCompatResources.class;
        synchronized (SkinCompatResources.class) {
            if (sInstance != null) return sInstance;
            sInstance = new SkinCompatResources();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public void reset() {
        this.reset((SkinCompatManager.SkinLoaderStrategy)SkinCompatManager.getInstance().getStrategies().get(-1));
    }

    public void reset(SkinCompatManager.SkinLoaderStrategy strategy) {
        this.mResources = SkinCompatManager.getInstance().getContext().getResources();
        this.mSkinPkgName = "";
        this.mSkinName = "";
        this.mStrategy = strategy;
        this.isDefaultSkin = true;
        SkinCompatUserThemeManager.get().clearCaches();
        SkinCompatDrawableManager.get().clearCaches();
    }

    public void setupSkin(Resources resources, String pkgName, String skinName, SkinCompatManager.SkinLoaderStrategy strategy) {
        if (resources == null || TextUtils.isEmpty((CharSequence)pkgName) || TextUtils.isEmpty((CharSequence)skinName)) {
            this.reset(strategy);
            return;
        }
        this.mResources = resources;
        this.mSkinPkgName = pkgName;
        this.mSkinName = skinName;
        this.mStrategy = strategy;
        this.isDefaultSkin = false;
        SkinCompatUserThemeManager.get().clearCaches();
        SkinCompatDrawableManager.get().clearCaches();
    }

    public Resources getSkinResources() {
        return this.mResources;
    }

    public String getSkinPkgName() {
        return this.mSkinPkgName;
    }

    public boolean isDefaultSkin() {
        return this.isDefaultSkin;
    }

    @Deprecated
    public int getColor(int resId) {
        return SkinCompatResources.getColor(SkinCompatManager.getInstance().getContext(), resId);
    }

    @Deprecated
    public Drawable getDrawable(int resId) {
        return SkinCompatResources.getDrawable(SkinCompatManager.getInstance().getContext(), resId);
    }

    @Deprecated
    public ColorStateList getColorStateList(int resId) {
        return SkinCompatResources.getColorStateList(SkinCompatManager.getInstance().getContext(), resId);
    }

    private int getTargetResId(Context context, int resId) {
        try {
            String resName = null;
            if (this.mStrategy != null) {
                resName = this.mStrategy.getTargetResourceEntryName(context, this.mSkinName, resId);
            }
            if (TextUtils.isEmpty(resName)) {
                resName = context.getResources().getResourceEntryName(resId);
            }
            String type = context.getResources().getResourceTypeName(resId);
            return this.mResources.getIdentifier(resName, type, this.mSkinPkgName);
        }
        catch (Exception e) {
            return 0;
        }
    }

    private int getSkinColor(Context context, int resId) {
        int targetResId;
        ColorStateList colorStateList;
        if (!SkinCompatUserThemeManager.get().isColorEmpty() && (colorStateList = SkinCompatUserThemeManager.get().getColorStateList(resId)) != null) {
            return colorStateList.getDefaultColor();
        }
        if (this.mStrategy != null && (colorStateList = this.mStrategy.getColor(context, this.mSkinName, resId)) != null) {
            return colorStateList.getDefaultColor();
        }
        if (!this.isDefaultSkin && (targetResId = this.getTargetResId(context, resId)) != 0) {
            return this.mResources.getColor(targetResId);
        }
        return context.getResources().getColor(resId);
    }

    private ColorStateList getSkinColorStateList(Context context, int resId) {
        int targetResId;
        ColorStateList colorStateList;
        if (!SkinCompatUserThemeManager.get().isColorEmpty() && (colorStateList = SkinCompatUserThemeManager.get().getColorStateList(resId)) != null) {
            return colorStateList;
        }
        if (this.mStrategy != null && (colorStateList = this.mStrategy.getColorStateList(context, this.mSkinName, resId)) != null) {
            return colorStateList;
        }
        if (!this.isDefaultSkin && (targetResId = this.getTargetResId(context, resId)) != 0) {
            return this.mResources.getColorStateList(targetResId);
        }
        return context.getResources().getColorStateList(resId);
    }

    private Drawable getSkinDrawable(Context context, int resId) {
        int targetResId;
        Drawable drawable2;
        ColorStateList colorStateList;
        if (!SkinCompatUserThemeManager.get().isColorEmpty() && (colorStateList = SkinCompatUserThemeManager.get().getColorStateList(resId)) != null) {
            return new ColorDrawable(colorStateList.getDefaultColor());
        }
        if (!SkinCompatUserThemeManager.get().isDrawableEmpty() && (drawable2 = SkinCompatUserThemeManager.get().getDrawable(resId)) != null) {
            return drawable2;
        }
        if (this.mStrategy != null && (drawable2 = this.mStrategy.getDrawable(context, this.mSkinName, resId)) != null) {
            return drawable2;
        }
        if (!this.isDefaultSkin && (targetResId = this.getTargetResId(context, resId)) != 0) {
            return this.mResources.getDrawable(targetResId);
        }
        return context.getResources().getDrawable(resId);
    }

    private Drawable getSkinDrawableCompat(Context context, int resId) {
        if (AppCompatDelegate.isCompatVectorFromResourcesEnabled()) {
            Drawable drawable2;
            ColorStateList colorStateList;
            if (!this.isDefaultSkin) {
                try {
                    return SkinCompatDrawableManager.get().getDrawable(context, resId);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!SkinCompatUserThemeManager.get().isColorEmpty() && (colorStateList = SkinCompatUserThemeManager.get().getColorStateList(resId)) != null) {
                return new ColorDrawable(colorStateList.getDefaultColor());
            }
            if (!SkinCompatUserThemeManager.get().isDrawableEmpty() && (drawable2 = SkinCompatUserThemeManager.get().getDrawable(resId)) != null) {
                return drawable2;
            }
            if (this.mStrategy != null && (drawable2 = this.mStrategy.getDrawable(context, this.mSkinName, resId)) != null) {
                return drawable2;
            }
            return AppCompatResources.getDrawable((Context)context, (int)resId);
        }
        return this.getSkinDrawable(context, resId);
    }

    private XmlResourceParser getSkinXml(Context context, int resId) {
        int targetResId;
        if (!this.isDefaultSkin && (targetResId = this.getTargetResId(context, resId)) != 0) {
            return this.mResources.getXml(targetResId);
        }
        return context.getResources().getXml(resId);
    }

    private void getSkinValue(Context context, @AnyRes int resId, TypedValue outValue, boolean resolveRefs) {
        int targetResId;
        if (!this.isDefaultSkin && (targetResId = this.getTargetResId(context, resId)) != 0) {
            this.mResources.getValue(targetResId, outValue, resolveRefs);
            return;
        }
        context.getResources().getValue(resId, outValue, resolveRefs);
    }

    public static int getColor(Context context, int resId) {
        return SkinCompatResources.getInstance().getSkinColor(context, resId);
    }

    public static ColorStateList getColorStateList(Context context, int resId) {
        return SkinCompatResources.getInstance().getSkinColorStateList(context, resId);
    }

    public static Drawable getDrawable(Context context, int resId) {
        return SkinCompatResources.getInstance().getSkinDrawable(context, resId);
    }

    public static Drawable getDrawableCompat(Context context, int resId) {
        return SkinCompatResources.getInstance().getSkinDrawableCompat(context, resId);
    }

    public static XmlResourceParser getXml(Context context, int resId) {
        return SkinCompatResources.getInstance().getSkinXml(context, resId);
    }

    public static void getValue(Context context, @AnyRes int resId, TypedValue outValue, boolean resolveRefs) {
        SkinCompatResources.getInstance().getSkinValue(context, resId, outValue, resolveRefs);
    }
}

