/*
 * Decompiled with CFR 0.152.
 */
package skin.support.content.res;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.text.TextUtils;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.WeakHashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import skin.support.SkinCompatManager;
import skin.support.content.res.ColorState;
import skin.support.utils.ImageUtils;
import skin.support.utils.SkinPreference;
import skin.support.utils.Slog;

public class SkinCompatUserThemeManager {
    private static final String TAG = "SkinCompatUserThemeManager";
    private static final String KEY_TYPE = "type";
    private static final String KEY_TYPE_COLOR = "color";
    private static final String KEY_TYPE_DRAWABLE = "drawable";
    private static final String KEY_DRAWABLE_NAME = "drawableName";
    private static final String KEY_DRAWABLE_PATH_AND_ANGLE = "drawablePathAndAngle";
    private static SkinCompatUserThemeManager INSTANCE = new SkinCompatUserThemeManager();
    private final HashMap<String, ColorState> mColorNameStateMap;
    private final Object mColorCacheLock;
    private final WeakHashMap<Integer, WeakReference<ColorStateList>> mColorCaches;
    private boolean mColorEmpty;
    private final HashMap<String, String> mDrawablePathAndAngleMap;
    private final Object mDrawableCacheLock;
    private final WeakHashMap<Integer, WeakReference<Drawable>> mDrawableCaches;
    private boolean mDrawableEmpty;

    private SkinCompatUserThemeManager() {
        block2: {
            this.mColorNameStateMap = new HashMap();
            this.mColorCacheLock = new Object();
            this.mColorCaches = new WeakHashMap();
            this.mDrawablePathAndAngleMap = new HashMap();
            this.mDrawableCacheLock = new Object();
            this.mDrawableCaches = new WeakHashMap();
            try {
                this.startLoadFromSharedPreferences();
            }
            catch (JSONException e) {
                this.mColorNameStateMap.clear();
                this.mDrawablePathAndAngleMap.clear();
                if (!Slog.DEBUG) break block2;
                Slog.i(TAG, "startLoadFromSharedPreferences error: " + (Object)((Object)e));
            }
        }
    }

    private void startLoadFromSharedPreferences() throws JSONException {
        String colors = SkinPreference.getInstance().getUserTheme();
        if (!TextUtils.isEmpty((CharSequence)colors)) {
            JSONArray jsonArray = new JSONArray(colors);
            if (Slog.DEBUG) {
                Slog.i(TAG, "startLoadFromSharedPreferences: " + jsonArray.toString());
            }
            int count = jsonArray.length();
            for (int i = 0; i < count; ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                if (!jsonObject.has(KEY_TYPE)) continue;
                String type = jsonObject.getString(KEY_TYPE);
                if (KEY_TYPE_COLOR.equals(type)) {
                    ColorState state = ColorState.fromJSONObject(jsonObject);
                    if (state == null) continue;
                    this.mColorNameStateMap.put(state.colorName, state);
                    continue;
                }
                if (!KEY_TYPE_DRAWABLE.equals(type)) continue;
                String drawableName = jsonObject.getString(KEY_DRAWABLE_NAME);
                String drawablePathAndAngle = jsonObject.getString(KEY_DRAWABLE_PATH_AND_ANGLE);
                if (TextUtils.isEmpty((CharSequence)drawableName) || TextUtils.isEmpty((CharSequence)drawablePathAndAngle)) continue;
                this.mDrawablePathAndAngleMap.put(drawableName, drawablePathAndAngle);
            }
            this.mColorEmpty = this.mColorNameStateMap.isEmpty();
            this.mDrawableEmpty = this.mDrawablePathAndAngleMap.isEmpty();
        }
    }

    public void apply() {
        JSONArray jsonArray = new JSONArray();
        for (String colorName : this.mColorNameStateMap.keySet()) {
            ColorState state = this.mColorNameStateMap.get(colorName);
            if (state == null) continue;
            try {
                jsonArray.put((Object)ColorState.toJSONObject(state).putOpt(KEY_TYPE, (Object)KEY_TYPE_COLOR));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        for (String drawableName : this.mDrawablePathAndAngleMap.keySet()) {
            JSONObject object = new JSONObject();
            try {
                jsonArray.put((Object)object.putOpt(KEY_TYPE, (Object)KEY_TYPE_DRAWABLE).putOpt(KEY_DRAWABLE_NAME, (Object)drawableName).putOpt(KEY_DRAWABLE_PATH_AND_ANGLE, (Object)this.mDrawablePathAndAngleMap.get(drawableName)));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        if (Slog.DEBUG) {
            Slog.i(TAG, "Apply user theme: " + jsonArray.toString());
        }
        SkinPreference.getInstance().setUserTheme(jsonArray.toString()).commitEditor();
        SkinCompatManager.getInstance().notifyUpdateSkin();
    }

    public static SkinCompatUserThemeManager get() {
        return INSTANCE;
    }

    public void addColorState(@ColorRes int colorRes, ColorState state) {
        String entry = this.getEntryName(colorRes, KEY_TYPE_COLOR);
        if (!TextUtils.isEmpty((CharSequence)entry) && state != null) {
            state.colorName = entry;
            this.mColorNameStateMap.put(entry, state);
            this.removeColorInCache(colorRes);
            this.mColorEmpty = false;
        }
    }

    public void addColorState(@ColorRes int colorRes, String colorDefault) {
        if (!ColorState.checkColorValid("colorDefault", colorDefault)) {
            return;
        }
        String entry = this.getEntryName(colorRes, KEY_TYPE_COLOR);
        if (!TextUtils.isEmpty((CharSequence)entry)) {
            this.mColorNameStateMap.put(entry, new ColorState(entry, colorDefault));
            this.removeColorInCache(colorRes);
            this.mColorEmpty = false;
        }
    }

    public void removeColorState(@ColorRes int colorRes) {
        String entry = this.getEntryName(colorRes, KEY_TYPE_COLOR);
        if (!TextUtils.isEmpty((CharSequence)entry)) {
            this.mColorNameStateMap.remove(entry);
            this.removeColorInCache(colorRes);
            this.mColorEmpty = this.mColorNameStateMap.isEmpty();
        }
    }

    void removeColorState(String colorName) {
        if (!TextUtils.isEmpty((CharSequence)colorName)) {
            this.mColorNameStateMap.remove(colorName);
            this.mColorEmpty = this.mColorNameStateMap.isEmpty();
        }
    }

    public ColorState getColorState(String colorName) {
        return this.mColorNameStateMap.get(colorName);
    }

    public ColorState getColorState(@ColorRes int colorRes) {
        String entry = this.getEntryName(colorRes, KEY_TYPE_COLOR);
        if (!TextUtils.isEmpty((CharSequence)entry)) {
            return this.mColorNameStateMap.get(entry);
        }
        return null;
    }

    public ColorStateList getColorStateList(@ColorRes int colorRes) {
        ColorState state;
        String entry;
        ColorStateList colorStateList = this.getCachedColor(colorRes);
        if (colorStateList == null && !TextUtils.isEmpty((CharSequence)(entry = this.getEntryName(colorRes, KEY_TYPE_COLOR))) && (state = this.mColorNameStateMap.get(entry)) != null && (colorStateList = state.parse()) != null) {
            this.addColorToCache(colorRes, colorStateList);
        }
        return colorStateList;
    }

    public void addDrawablePath(@DrawableRes int drawableRes, String drawablePath) {
        if (!SkinCompatUserThemeManager.checkPathValid(drawablePath)) {
            return;
        }
        String entry = this.getEntryName(drawableRes, KEY_TYPE_DRAWABLE);
        if (!TextUtils.isEmpty((CharSequence)entry)) {
            int angle = ImageUtils.getImageRotateAngle(drawablePath);
            String drawablePathAndAngle = drawablePath + ":" + String.valueOf(angle);
            this.mDrawablePathAndAngleMap.put(entry, drawablePathAndAngle);
            this.removeDrawableInCache(drawableRes);
            this.mDrawableEmpty = false;
        }
    }

    public void addDrawablePath(@DrawableRes int drawableRes, String drawablePath, int angle) {
        if (!SkinCompatUserThemeManager.checkPathValid(drawablePath)) {
            return;
        }
        String entry = this.getEntryName(drawableRes, KEY_TYPE_DRAWABLE);
        if (!TextUtils.isEmpty((CharSequence)entry)) {
            String drawablePathAndAngle = drawablePath + ":" + String.valueOf(angle);
            this.mDrawablePathAndAngleMap.put(entry, drawablePathAndAngle);
            this.removeDrawableInCache(drawableRes);
            this.mDrawableEmpty = false;
        }
    }

    public void removeDrawablePath(@DrawableRes int drawableRes) {
        String entry = this.getEntryName(drawableRes, KEY_TYPE_DRAWABLE);
        if (!TextUtils.isEmpty((CharSequence)entry)) {
            this.mDrawablePathAndAngleMap.remove(entry);
            this.removeDrawableInCache(drawableRes);
            this.mDrawableEmpty = this.mDrawablePathAndAngleMap.isEmpty();
        }
    }

    public String getDrawablePath(String drawableName) {
        String drawablePathAndAngle = this.mDrawablePathAndAngleMap.get(drawableName);
        if (!TextUtils.isEmpty((CharSequence)drawablePathAndAngle)) {
            String[] splits = drawablePathAndAngle.split(":");
            return splits[0];
        }
        return "";
    }

    public int getDrawableAngle(String drawableName) {
        String[] splits;
        String drawablePathAndAngle = this.mDrawablePathAndAngleMap.get(drawableName);
        if (!TextUtils.isEmpty((CharSequence)drawablePathAndAngle) && (splits = drawablePathAndAngle.split(":")).length == 2) {
            return Integer.valueOf(splits[1]);
        }
        return 0;
    }

    public Drawable getDrawable(@DrawableRes int drawableRes) {
        String drawablePathAndAngle;
        String entry;
        Drawable drawable2 = this.getCachedDrawable(drawableRes);
        if (drawable2 == null && !TextUtils.isEmpty((CharSequence)(entry = this.getEntryName(drawableRes, KEY_TYPE_DRAWABLE))) && !TextUtils.isEmpty((CharSequence)(drawablePathAndAngle = this.mDrawablePathAndAngleMap.get(entry)))) {
            String[] splits = drawablePathAndAngle.split(":");
            String path = splits[0];
            int angle = 0;
            if (splits.length == 2) {
                angle = Integer.valueOf(splits[1]);
            }
            if (SkinCompatUserThemeManager.checkPathValid(path)) {
                if (angle == 0) {
                    drawable2 = Drawable.createFromPath((String)path);
                } else {
                    Matrix m = new Matrix();
                    m.postRotate((float)angle);
                    Bitmap bitmap = BitmapFactory.decodeFile((String)path);
                    bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)m, (boolean)true);
                    drawable2 = new BitmapDrawable(null, bitmap);
                }
                if (drawable2 != null) {
                    this.addDrawableToCache(drawableRes, drawable2);
                }
            }
        }
        return drawable2;
    }

    public void clearColors() {
        this.mColorNameStateMap.clear();
        this.clearColorCaches();
        this.mColorEmpty = true;
        this.apply();
    }

    public void clearDrawables() {
        this.mDrawablePathAndAngleMap.clear();
        this.clearDrawableCaches();
        this.mDrawableEmpty = true;
        this.apply();
    }

    boolean isColorEmpty() {
        return this.mColorEmpty;
    }

    boolean isDrawableEmpty() {
        return this.mDrawableEmpty;
    }

    void clearCaches() {
        this.clearColorCaches();
        this.clearDrawableCaches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearColorCaches() {
        Object object = this.mColorCacheLock;
        synchronized (object) {
            this.mColorCaches.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearDrawableCaches() {
        Object object = this.mDrawableCacheLock;
        synchronized (object) {
            this.mDrawableCaches.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ColorStateList getCachedColor(@ColorRes int colorRes) {
        Object object = this.mColorCacheLock;
        synchronized (object) {
            WeakReference<ColorStateList> colorRef = this.mColorCaches.get(colorRes);
            if (colorRef != null) {
                ColorStateList colorStateList = (ColorStateList)colorRef.get();
                if (colorStateList != null) {
                    return colorStateList;
                }
                this.mColorCaches.remove(colorRes);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addColorToCache(@ColorRes int colorRes, ColorStateList colorStateList) {
        if (colorStateList != null) {
            Object object = this.mColorCacheLock;
            synchronized (object) {
                this.mColorCaches.put(colorRes, new WeakReference<ColorStateList>(colorStateList));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeColorInCache(@ColorRes int colorRes) {
        Object object = this.mColorCacheLock;
        synchronized (object) {
            this.mColorCaches.remove(colorRes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Drawable getCachedDrawable(@DrawableRes int drawableRes) {
        Object object = this.mDrawableCacheLock;
        synchronized (object) {
            WeakReference<Drawable> drawableRef = this.mDrawableCaches.get(drawableRes);
            if (drawableRef != null) {
                Drawable drawable2 = (Drawable)drawableRef.get();
                if (drawable2 != null) {
                    return drawable2;
                }
                this.mDrawableCaches.remove(drawableRes);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDrawableToCache(@DrawableRes int drawableRes, Drawable drawable2) {
        if (drawable2 != null) {
            Object object = this.mDrawableCacheLock;
            synchronized (object) {
                this.mDrawableCaches.put(drawableRes, new WeakReference<Drawable>(drawable2));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDrawableInCache(@DrawableRes int drawableRes) {
        Object object = this.mDrawableCacheLock;
        synchronized (object) {
            this.mDrawableCaches.remove(drawableRes);
        }
    }

    private String getEntryName(int resId, String entryType) {
        Context context = SkinCompatManager.getInstance().getContext();
        String type = context.getResources().getResourceTypeName(resId);
        if (entryType.equalsIgnoreCase(type)) {
            return context.getResources().getResourceEntryName(resId);
        }
        return null;
    }

    private static boolean checkPathValid(String path) {
        boolean valid;
        boolean bl = valid = !TextUtils.isEmpty((CharSequence)path) && new File(path).exists();
        if (Slog.DEBUG && !valid) {
            Slog.i(TAG, "Invalid drawable path : " + path);
        }
        return valid;
    }
}

