/*
 * Decompiled with CFR 0.152.
 */
package skin.support.utils;

import android.graphics.drawable.Drawable;
import java.lang.reflect.Method;
import skin.support.utils.Slog;

public final class SkinCompatVersionUtils {
    private static final String TAG = "SkinCompatUtils";
    private static Class<?> sV4DrawableWrapperClass;
    private static Method sV4DrawableWrapperGetM;
    private static Method sV4DrawableWrapperSetM;
    private static Class<?> sV4WrappedDrawableClass;
    private static Method sV4WrappedDrawableGetM;
    private static Method sV4WrappedDrawableSetM;

    public static boolean hasV4WrappedDrawable() {
        return sV4WrappedDrawableClass != null;
    }

    public static boolean isV4WrappedDrawable(Drawable drawable2) {
        return sV4WrappedDrawableClass != null && sV4WrappedDrawableClass.isAssignableFrom(drawable2.getClass());
    }

    public static Drawable getV4WrappedDrawableWrappedDrawable(Drawable drawable2) {
        block8: {
            if (sV4WrappedDrawableClass != null) {
                block7: {
                    if (sV4WrappedDrawableGetM == null) {
                        try {
                            sV4WrappedDrawableGetM = sV4WrappedDrawableClass.getDeclaredMethod("getWrappedDrawable", new Class[0]);
                            sV4WrappedDrawableGetM.setAccessible(true);
                        }
                        catch (Exception e) {
                            if (!Slog.DEBUG) break block7;
                            Slog.i(TAG, "getV4WrappedDrawableWrappedDrawable No Such Method");
                        }
                    }
                }
                if (sV4WrappedDrawableGetM != null) {
                    try {
                        return (Drawable)sV4WrappedDrawableGetM.invoke((Object)drawable2, new Object[0]);
                    }
                    catch (Exception e) {
                        if (!Slog.DEBUG) break block8;
                        Slog.i(TAG, "getV4WrappedDrawableWrappedDrawable invoke error: " + e);
                    }
                }
            }
        }
        return drawable2;
    }

    public static void setV4WrappedDrawableWrappedDrawable(Drawable drawable2, Drawable inner) {
        block8: {
            if (sV4WrappedDrawableClass != null) {
                block7: {
                    if (sV4WrappedDrawableSetM == null) {
                        try {
                            sV4WrappedDrawableSetM = sV4WrappedDrawableClass.getDeclaredMethod("setWrappedDrawable", Drawable.class);
                            sV4WrappedDrawableSetM.setAccessible(true);
                        }
                        catch (Exception e) {
                            if (!Slog.DEBUG) break block7;
                            Slog.i(TAG, "setV4WrappedDrawableWrappedDrawable No Such Method");
                        }
                    }
                }
                if (sV4WrappedDrawableSetM != null) {
                    try {
                        sV4WrappedDrawableSetM.invoke((Object)drawable2, inner);
                    }
                    catch (Exception e) {
                        if (!Slog.DEBUG) break block8;
                        Slog.i(TAG, "setV4WrappedDrawableWrappedDrawable invoke error: " + e);
                    }
                }
            }
        }
    }

    public static boolean hasV4DrawableWrapper() {
        return sV4DrawableWrapperClass != null;
    }

    public static boolean isV4DrawableWrapper(Drawable drawable2) {
        return sV4DrawableWrapperClass != null && sV4DrawableWrapperClass.isAssignableFrom(drawable2.getClass());
    }

    public static Drawable getV4DrawableWrapperWrappedDrawable(Drawable drawable2) {
        block8: {
            if (sV4DrawableWrapperClass != null) {
                block7: {
                    if (sV4DrawableWrapperGetM == null) {
                        try {
                            sV4DrawableWrapperGetM = sV4DrawableWrapperClass.getDeclaredMethod("getWrappedDrawable", new Class[0]);
                            sV4DrawableWrapperGetM.setAccessible(true);
                        }
                        catch (Exception e) {
                            if (!Slog.DEBUG) break block7;
                            Slog.i(TAG, "getV4DrawableWrapperWrappedDrawable No Such Method");
                        }
                    }
                }
                if (sV4DrawableWrapperGetM != null) {
                    try {
                        return (Drawable)sV4DrawableWrapperGetM.invoke((Object)drawable2, new Object[0]);
                    }
                    catch (Exception e) {
                        if (!Slog.DEBUG) break block8;
                        Slog.i(TAG, "getV4DrawableWrapperWrappedDrawable invoke error: " + e);
                    }
                }
            }
        }
        return drawable2;
    }

    public static void setV4DrawableWrapperWrappedDrawable(Drawable drawable2, Drawable inner) {
        block8: {
            if (sV4DrawableWrapperClass != null) {
                block7: {
                    if (sV4DrawableWrapperSetM == null) {
                        try {
                            sV4DrawableWrapperSetM = sV4DrawableWrapperClass.getDeclaredMethod("setWrappedDrawable", Drawable.class);
                            sV4DrawableWrapperSetM.setAccessible(true);
                        }
                        catch (Exception e) {
                            if (!Slog.DEBUG) break block7;
                            Slog.i(TAG, "setV4DrawableWrapperWrappedDrawable No Such Method");
                        }
                    }
                }
                if (sV4DrawableWrapperSetM != null) {
                    try {
                        sV4DrawableWrapperSetM.invoke((Object)drawable2, inner);
                    }
                    catch (Exception e) {
                        if (!Slog.DEBUG) break block8;
                        Slog.i(TAG, "setV4DrawableWrapperWrappedDrawable invoke error: " + e);
                    }
                }
            }
        }
    }

    static {
        block5: {
            block4: {
                try {
                    sV4WrappedDrawableClass = Class.forName("android.support.v4.graphics.drawable.WrappedDrawable");
                }
                catch (ClassNotFoundException e) {
                    if (!Slog.DEBUG) break block4;
                    Slog.i(TAG, "hasWrappedDrawable = false");
                }
            }
            try {
                sV4DrawableWrapperClass = Class.forName("android.support.v4.graphics.drawable.DrawableWrapper");
            }
            catch (ClassNotFoundException e) {
                if (!Slog.DEBUG) break block5;
                Slog.i(TAG, "hasDrawableWrapper = false");
            }
        }
    }
}

