/*
 * Decompiled with CFR 0.152.
 */
package skin.support.widget;

import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.View;
import skin.support.R;
import skin.support.content.res.SkinCompatResources;
import skin.support.widget.SkinCompatHelper;

public class SkinCompatBackgroundHelper
extends SkinCompatHelper {
    private final View mView;
    private int mBackgroundResId = 0;

    public SkinCompatBackgroundHelper(View view) {
        this.mView = view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromAttributes(AttributeSet attrs, int defStyleAttr) {
        TypedArray a = this.mView.getContext().obtainStyledAttributes(attrs, R.styleable.SkinBackgroundHelper, defStyleAttr, 0);
        try {
            if (a.hasValue(R.styleable.SkinBackgroundHelper_android_background)) {
                this.mBackgroundResId = a.getResourceId(R.styleable.SkinBackgroundHelper_android_background, 0);
            }
        }
        finally {
            a.recycle();
        }
        this.applySkin();
    }

    public void onSetBackgroundResource(int resId) {
        this.mBackgroundResId = resId;
        this.applySkin();
    }

    @Override
    public void applySkin() {
        this.mBackgroundResId = SkinCompatBackgroundHelper.checkResourceId(this.mBackgroundResId);
        if (this.mBackgroundResId == 0) {
            return;
        }
        Drawable drawable2 = SkinCompatResources.getDrawableCompat(this.mView.getContext(), this.mBackgroundResId);
        if (drawable2 != null) {
            int paddingLeft = this.mView.getPaddingLeft();
            int paddingTop = this.mView.getPaddingTop();
            int paddingRight = this.mView.getPaddingRight();
            int paddingBottom = this.mView.getPaddingBottom();
            ViewCompat.setBackground((View)this.mView, (Drawable)drawable2);
            this.mView.setPadding(paddingLeft, paddingTop, paddingRight, paddingBottom);
        }
    }
}

