/*
 * Decompiled with CFR 0.152.
 */
package skin.support.widget;

import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.support.v4.widget.CompoundButtonCompat;
import android.util.AttributeSet;
import android.widget.CompoundButton;
import skin.support.R;
import skin.support.content.res.SkinCompatResources;
import skin.support.widget.SkinCompatHelper;

public class SkinCompatCompoundButtonHelper
extends SkinCompatHelper {
    private final CompoundButton mView;
    private int mButtonResourceId = 0;
    private int mButtonTintResId = 0;

    public SkinCompatCompoundButtonHelper(CompoundButton view) {
        this.mView = view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadFromAttributes(AttributeSet attrs, int defStyleAttr) {
        TypedArray a = this.mView.getContext().obtainStyledAttributes(attrs, R.styleable.CompoundButton, defStyleAttr, 0);
        try {
            if (a.hasValue(R.styleable.CompoundButton_android_button)) {
                this.mButtonResourceId = a.getResourceId(R.styleable.CompoundButton_android_button, 0);
            }
            if (a.hasValue(R.styleable.CompoundButton_buttonTint)) {
                this.mButtonTintResId = a.getResourceId(R.styleable.CompoundButton_buttonTint, 0);
            }
        }
        finally {
            a.recycle();
        }
        this.applySkin();
    }

    public void setButtonDrawable(int resId) {
        this.mButtonResourceId = resId;
        this.applySkin();
    }

    @Override
    public void applySkin() {
        this.mButtonResourceId = SkinCompatHelper.checkResourceId(this.mButtonResourceId);
        if (this.mButtonResourceId != 0) {
            this.mView.setButtonDrawable(SkinCompatResources.getDrawableCompat(this.mView.getContext(), this.mButtonResourceId));
        }
        this.mButtonTintResId = SkinCompatHelper.checkResourceId(this.mButtonTintResId);
        if (this.mButtonTintResId != 0) {
            CompoundButtonCompat.setButtonTintList((CompoundButton)this.mView, (ColorStateList)SkinCompatResources.getColorStateList(this.mView.getContext(), this.mButtonTintResId));
        }
    }
}

