/*
 * Decompiled with CFR 0.152.
 */
package skin.support.widget;

import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.widget.ProgressBar;
import android.widget.SeekBar;
import skin.support.R;
import skin.support.content.res.SkinCompatResources;
import skin.support.widget.SkinCompatProgressBarHelper;

public class SkinCompatSeekBarHelper
extends SkinCompatProgressBarHelper {
    private final SeekBar mView;
    private int mThumbResId = 0;

    public SkinCompatSeekBarHelper(SeekBar view) {
        super((ProgressBar)view);
        this.mView = view;
    }

    @Override
    void loadFromAttributes(AttributeSet attrs, int defStyleAttr) {
        super.loadFromAttributes(attrs, defStyleAttr);
        TypedArray a = this.mView.getContext().obtainStyledAttributes(attrs, R.styleable.AppCompatSeekBar, defStyleAttr, 0);
        this.mThumbResId = a.getResourceId(R.styleable.AppCompatSeekBar_android_thumb, 0);
        a.recycle();
        this.applySkin();
    }

    @Override
    public void applySkin() {
        super.applySkin();
        this.mThumbResId = SkinCompatSeekBarHelper.checkResourceId(this.mThumbResId);
        if (this.mThumbResId != 0) {
            this.mView.setThumb(SkinCompatResources.getDrawableCompat(this.mView.getContext(), this.mThumbResId));
        }
    }
}

