/*
 * Decompiled with CFR 0.152.
 */
package skin.support.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.DrawableRes;
import android.util.AttributeSet;
import android.widget.TextView;
import skin.support.R;
import skin.support.content.res.SkinCompatResources;
import skin.support.widget.SkinCompatHelper;
import skin.support.widget.SkinCompatTextHelperV17;

public class SkinCompatTextHelper
extends SkinCompatHelper {
    private static final String TAG = SkinCompatTextHelper.class.getSimpleName();
    final TextView mView;
    private int mTextColorResId = 0;
    private int mTextColorHintResId = 0;
    protected int mDrawableBottomResId = 0;
    protected int mDrawableLeftResId = 0;
    protected int mDrawableRightResId = 0;
    protected int mDrawableTopResId = 0;

    public static SkinCompatTextHelper create(TextView textView) {
        if (Build.VERSION.SDK_INT >= 17) {
            return new SkinCompatTextHelperV17(textView);
        }
        return new SkinCompatTextHelper(textView);
    }

    public SkinCompatTextHelper(TextView view) {
        this.mView = view;
    }

    public void loadFromAttributes(AttributeSet attrs, int defStyleAttr) {
        Context context = this.mView.getContext();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SkinCompatTextHelper, defStyleAttr, 0);
        int ap = a.getResourceId(R.styleable.SkinCompatTextHelper_android_textAppearance, 0);
        if (a.hasValue(R.styleable.SkinCompatTextHelper_android_drawableLeft)) {
            this.mDrawableLeftResId = a.getResourceId(R.styleable.SkinCompatTextHelper_android_drawableLeft, 0);
        }
        if (a.hasValue(R.styleable.SkinCompatTextHelper_android_drawableTop)) {
            this.mDrawableTopResId = a.getResourceId(R.styleable.SkinCompatTextHelper_android_drawableTop, 0);
        }
        if (a.hasValue(R.styleable.SkinCompatTextHelper_android_drawableRight)) {
            this.mDrawableRightResId = a.getResourceId(R.styleable.SkinCompatTextHelper_android_drawableRight, 0);
        }
        if (a.hasValue(R.styleable.SkinCompatTextHelper_android_drawableBottom)) {
            this.mDrawableBottomResId = a.getResourceId(R.styleable.SkinCompatTextHelper_android_drawableBottom, 0);
        }
        a.recycle();
        if (ap != 0) {
            a = context.obtainStyledAttributes(ap, R.styleable.SkinTextAppearance);
            if (a.hasValue(R.styleable.SkinTextAppearance_android_textColor)) {
                this.mTextColorResId = a.getResourceId(R.styleable.SkinTextAppearance_android_textColor, 0);
            }
            if (a.hasValue(R.styleable.SkinTextAppearance_android_textColorHint)) {
                this.mTextColorHintResId = a.getResourceId(R.styleable.SkinTextAppearance_android_textColorHint, 0);
            }
            a.recycle();
        }
        if ((a = context.obtainStyledAttributes(attrs, R.styleable.SkinTextAppearance, defStyleAttr, 0)).hasValue(R.styleable.SkinTextAppearance_android_textColor)) {
            this.mTextColorResId = a.getResourceId(R.styleable.SkinTextAppearance_android_textColor, 0);
        }
        if (a.hasValue(R.styleable.SkinTextAppearance_android_textColorHint)) {
            this.mTextColorHintResId = a.getResourceId(R.styleable.SkinTextAppearance_android_textColorHint, 0);
        }
        a.recycle();
        this.applySkin();
    }

    public void onSetTextAppearance(Context context, int resId) {
        TypedArray a = context.obtainStyledAttributes(resId, R.styleable.SkinTextAppearance);
        if (a.hasValue(R.styleable.SkinTextAppearance_android_textColor)) {
            this.mTextColorResId = a.getResourceId(R.styleable.SkinTextAppearance_android_textColor, 0);
        }
        if (a.hasValue(R.styleable.SkinTextAppearance_android_textColorHint)) {
            this.mTextColorHintResId = a.getResourceId(R.styleable.SkinTextAppearance_android_textColorHint, 0);
        }
        a.recycle();
        this.applyTextColorResource();
        this.applyTextColorHintResource();
    }

    private void applyTextColorHintResource() {
        this.mTextColorHintResId = SkinCompatTextHelper.checkResourceId(this.mTextColorHintResId);
        if (this.mTextColorHintResId == R.color.abc_hint_foreground_material_light) {
            return;
        }
        if (this.mTextColorHintResId != 0) {
            try {
                ColorStateList color2 = SkinCompatResources.getColorStateList(this.mView.getContext(), this.mTextColorHintResId);
                this.mView.setHintTextColor(color2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void applyTextColorResource() {
        this.mTextColorResId = SkinCompatTextHelper.checkResourceId(this.mTextColorResId);
        if (this.mTextColorResId == R.color.abc_primary_text_disable_only_material_light || this.mTextColorResId == R.color.abc_secondary_text_material_light) {
            return;
        }
        if (this.mTextColorResId != 0) {
            try {
                ColorStateList color2 = SkinCompatResources.getColorStateList(this.mView.getContext(), this.mTextColorResId);
                this.mView.setTextColor(color2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void onSetCompoundDrawablesRelativeWithIntrinsicBounds(@DrawableRes int start, @DrawableRes int top, @DrawableRes int end, @DrawableRes int bottom) {
        this.mDrawableLeftResId = start;
        this.mDrawableTopResId = top;
        this.mDrawableRightResId = end;
        this.mDrawableBottomResId = bottom;
        this.applyCompoundDrawablesRelativeResource();
    }

    public void onSetCompoundDrawablesWithIntrinsicBounds(@DrawableRes int left, @DrawableRes int top, @DrawableRes int right, @DrawableRes int bottom) {
        this.mDrawableLeftResId = left;
        this.mDrawableTopResId = top;
        this.mDrawableRightResId = right;
        this.mDrawableBottomResId = bottom;
        this.applyCompoundDrawablesResource();
    }

    protected void applyCompoundDrawablesRelativeResource() {
        this.applyCompoundDrawablesResource();
    }

    protected void applyCompoundDrawablesResource() {
        Drawable drawableLeft = null;
        Drawable drawableTop = null;
        Drawable drawableRight = null;
        Drawable drawableBottom = null;
        this.mDrawableLeftResId = SkinCompatTextHelper.checkResourceId(this.mDrawableLeftResId);
        if (this.mDrawableLeftResId != 0) {
            drawableLeft = SkinCompatResources.getDrawableCompat(this.mView.getContext(), this.mDrawableLeftResId);
        }
        this.mDrawableTopResId = SkinCompatTextHelper.checkResourceId(this.mDrawableTopResId);
        if (this.mDrawableTopResId != 0) {
            drawableTop = SkinCompatResources.getDrawableCompat(this.mView.getContext(), this.mDrawableTopResId);
        }
        this.mDrawableRightResId = SkinCompatTextHelper.checkResourceId(this.mDrawableRightResId);
        if (this.mDrawableRightResId != 0) {
            drawableRight = SkinCompatResources.getDrawableCompat(this.mView.getContext(), this.mDrawableRightResId);
        }
        this.mDrawableBottomResId = SkinCompatTextHelper.checkResourceId(this.mDrawableBottomResId);
        if (this.mDrawableBottomResId != 0) {
            drawableBottom = SkinCompatResources.getDrawableCompat(this.mView.getContext(), this.mDrawableBottomResId);
        }
        if (this.mDrawableLeftResId != 0 || this.mDrawableTopResId != 0 || this.mDrawableRightResId != 0 || this.mDrawableBottomResId != 0) {
            this.mView.setCompoundDrawablesWithIntrinsicBounds(drawableLeft, drawableTop, drawableRight, drawableBottom);
        }
    }

    public int getTextColorResId() {
        return this.mTextColorResId;
    }

    @Override
    public void applySkin() {
        this.applyCompoundDrawablesRelativeResource();
        this.applyTextColorResource();
        this.applyTextColorHintResource();
    }
}

