/*
 * Decompiled with CFR 0.152.
 */
package skin.support.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.RequiresApi;
import android.util.AttributeSet;
import android.widget.TextView;
import skin.support.R;
import skin.support.content.res.SkinCompatResources;
import skin.support.widget.SkinCompatHelper;
import skin.support.widget.SkinCompatTextHelper;

@RequiresApi(value=17)
@TargetApi(value=17)
public class SkinCompatTextHelperV17
extends SkinCompatTextHelper {
    private int mDrawableStartResId = 0;
    private int mDrawableEndResId = 0;

    public SkinCompatTextHelperV17(TextView view) {
        super(view);
    }

    @Override
    public void loadFromAttributes(AttributeSet attrs, int defStyleAttr) {
        Context context = this.mView.getContext();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SkinCompatTextHelper, defStyleAttr, 0);
        if (a.hasValue(R.styleable.SkinCompatTextHelper_android_drawableStart)) {
            this.mDrawableStartResId = a.getResourceId(R.styleable.SkinCompatTextHelper_android_drawableStart, 0);
            this.mDrawableStartResId = SkinCompatHelper.checkResourceId(this.mDrawableStartResId);
        }
        if (a.hasValue(R.styleable.SkinCompatTextHelper_android_drawableEnd)) {
            this.mDrawableEndResId = a.getResourceId(R.styleable.SkinCompatTextHelper_android_drawableEnd, 0);
            this.mDrawableEndResId = SkinCompatHelper.checkResourceId(this.mDrawableEndResId);
        }
        a.recycle();
        super.loadFromAttributes(attrs, defStyleAttr);
    }

    @Override
    public void onSetCompoundDrawablesRelativeWithIntrinsicBounds(@DrawableRes int start, @DrawableRes int top, @DrawableRes int end, @DrawableRes int bottom) {
        this.mDrawableStartResId = start;
        this.mDrawableTopResId = top;
        this.mDrawableEndResId = end;
        this.mDrawableBottomResId = bottom;
        this.applyCompoundDrawablesRelativeResource();
    }

    @Override
    protected void applyCompoundDrawablesRelativeResource() {
        Drawable drawableLeft = null;
        Drawable drawableTop = null;
        Drawable drawableRight = null;
        Drawable drawableBottom = null;
        Drawable drawableStart = null;
        Drawable drawableEnd = null;
        this.mDrawableLeftResId = SkinCompatTextHelperV17.checkResourceId(this.mDrawableLeftResId);
        if (this.mDrawableLeftResId != 0) {
            drawableLeft = SkinCompatResources.getDrawableCompat(this.mView.getContext(), this.mDrawableLeftResId);
        }
        this.mDrawableTopResId = SkinCompatTextHelperV17.checkResourceId(this.mDrawableTopResId);
        if (this.mDrawableTopResId != 0) {
            drawableTop = SkinCompatResources.getDrawableCompat(this.mView.getContext(), this.mDrawableTopResId);
        }
        this.mDrawableRightResId = SkinCompatTextHelperV17.checkResourceId(this.mDrawableRightResId);
        if (this.mDrawableRightResId != 0) {
            drawableRight = SkinCompatResources.getDrawableCompat(this.mView.getContext(), this.mDrawableRightResId);
        }
        this.mDrawableBottomResId = SkinCompatTextHelperV17.checkResourceId(this.mDrawableBottomResId);
        if (this.mDrawableBottomResId != 0) {
            drawableBottom = SkinCompatResources.getDrawableCompat(this.mView.getContext(), this.mDrawableBottomResId);
        }
        if (this.mDrawableStartResId != 0) {
            drawableStart = SkinCompatResources.getDrawableCompat(this.mView.getContext(), this.mDrawableStartResId);
        }
        if (drawableStart == null) {
            drawableStart = drawableLeft;
        }
        if (this.mDrawableEndResId != 0) {
            drawableEnd = SkinCompatResources.getDrawableCompat(this.mView.getContext(), this.mDrawableEndResId);
        }
        if (drawableEnd == null) {
            drawableEnd = drawableRight;
        }
        if (this.mDrawableLeftResId != 0 || this.mDrawableTopResId != 0 || this.mDrawableRightResId != 0 || this.mDrawableBottomResId != 0 || this.mDrawableStartResId != 0 || this.mDrawableEndResId != 0) {
            this.mView.setCompoundDrawablesWithIntrinsicBounds(drawableStart, drawableTop, drawableEnd, drawableBottom);
        }
    }
}

