/*
 * Decompiled with CFR 0.152.
 */
package skin.support.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.DrawableRes;
import android.support.annotation.Nullable;
import android.support.v7.widget.Toolbar;
import android.util.AttributeSet;
import android.view.View;
import skin.support.R;
import skin.support.content.res.SkinCompatResources;
import skin.support.widget.SkinCompatBackgroundHelper;
import skin.support.widget.SkinCompatHelper;
import skin.support.widget.SkinCompatSupportable;

public class SkinCompatToolbar
extends Toolbar
implements SkinCompatSupportable {
    private int mTitleTextColorResId = 0;
    private int mSubtitleTextColorResId = 0;
    private int mNavigationIconResId = 0;
    private SkinCompatBackgroundHelper mBackgroundTintHelper = new SkinCompatBackgroundHelper((View)this);

    public SkinCompatToolbar(Context context) {
        this(context, null);
    }

    public SkinCompatToolbar(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.toolbarStyle);
    }

    public SkinCompatToolbar(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mBackgroundTintHelper.loadFromAttributes(attrs, defStyleAttr);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Toolbar, defStyleAttr, 0);
        this.mNavigationIconResId = a.getResourceId(R.styleable.Toolbar_navigationIcon, 0);
        int titleAp = a.getResourceId(R.styleable.Toolbar_titleTextAppearance, 0);
        int subtitleAp = a.getResourceId(R.styleable.Toolbar_subtitleTextAppearance, 0);
        a.recycle();
        if (titleAp != 0) {
            a = context.obtainStyledAttributes(titleAp, R.styleable.SkinTextAppearance);
            this.mTitleTextColorResId = a.getResourceId(R.styleable.SkinTextAppearance_android_textColor, 0);
            a.recycle();
        }
        if (subtitleAp != 0) {
            a = context.obtainStyledAttributes(subtitleAp, R.styleable.SkinTextAppearance);
            this.mSubtitleTextColorResId = a.getResourceId(R.styleable.SkinTextAppearance_android_textColor, 0);
            a.recycle();
        }
        if ((a = context.obtainStyledAttributes(attrs, R.styleable.Toolbar, defStyleAttr, 0)).hasValue(R.styleable.Toolbar_titleTextColor)) {
            this.mTitleTextColorResId = a.getResourceId(R.styleable.Toolbar_titleTextColor, 0);
        }
        if (a.hasValue(R.styleable.Toolbar_subtitleTextColor)) {
            this.mSubtitleTextColorResId = a.getResourceId(R.styleable.Toolbar_subtitleTextColor, 0);
        }
        a.recycle();
        this.applyTitleTextColor();
        this.applySubtitleTextColor();
        this.applyNavigationIcon();
    }

    private void applyTitleTextColor() {
        this.mTitleTextColorResId = SkinCompatHelper.checkResourceId(this.mTitleTextColorResId);
        if (this.mTitleTextColorResId != 0) {
            this.setTitleTextColor(SkinCompatResources.getColor(this.getContext(), this.mTitleTextColorResId));
        }
    }

    private void applySubtitleTextColor() {
        this.mSubtitleTextColorResId = SkinCompatHelper.checkResourceId(this.mSubtitleTextColorResId);
        if (this.mSubtitleTextColorResId != 0) {
            this.setSubtitleTextColor(SkinCompatResources.getColor(this.getContext(), this.mSubtitleTextColorResId));
        }
    }

    private void applyNavigationIcon() {
        this.mNavigationIconResId = SkinCompatHelper.checkResourceId(this.mNavigationIconResId);
        if (this.mNavigationIconResId != 0) {
            this.setNavigationIcon(SkinCompatResources.getDrawableCompat(this.getContext(), this.mNavigationIconResId));
        }
    }

    public void setBackgroundResource(@DrawableRes int resId) {
        super.setBackgroundResource(resId);
        if (this.mBackgroundTintHelper != null) {
            this.mBackgroundTintHelper.onSetBackgroundResource(resId);
        }
    }

    public void setNavigationIcon(@DrawableRes int resId) {
        super.setNavigationIcon(resId);
        this.mNavigationIconResId = resId;
        this.applyNavigationIcon();
    }

    @Override
    public void applySkin() {
        if (this.mBackgroundTintHelper != null) {
            this.mBackgroundTintHelper.applySkin();
        }
        this.applyTitleTextColor();
        this.applySubtitleTextColor();
        this.applyNavigationIcon();
    }
}

