/*
 * Decompiled with CFR 0.152.
 */
package su.j2e.rvjoiner;

import android.content.Context;
import android.support.annotation.LayoutRes;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import su.j2e.rvjoiner.RvJoiner;

public class JoinableLayout
implements RvJoiner.Joinable {
    private Adapter mAdapter;
    private int mItemType = 0;

    public JoinableLayout(@LayoutRes int layoutResId, int itemType, @Nullable Callback callback, long stableId) {
        this.mItemType = itemType;
        this.mAdapter = new Adapter(layoutResId, itemType, callback, stableId);
    }

    public JoinableLayout(@LayoutRes int layoutResId, int itemType, @Nullable Callback callback) {
        this(layoutResId, itemType, callback, -1L);
    }

    public JoinableLayout(@LayoutRes int layoutResId, @Nullable Callback callback) {
        this(layoutResId, 0, callback, -1L);
    }

    public JoinableLayout(@LayoutRes int layoutResId, int itemType) {
        this(layoutResId, itemType, null, -1L);
    }

    public JoinableLayout(@LayoutRes int layoutResId) {
        this(layoutResId, 0, null, -1L);
    }

    public boolean isVisible() {
        return this.mAdapter.isVisible();
    }

    public void setVisible(boolean visible) {
        this.mAdapter.setVisible(visible);
    }

    @Override
    public RecyclerView.Adapter getAdapter() {
        return this.mAdapter;
    }

    @Override
    public int getTypeCount() {
        return 1;
    }

    @Override
    public int getTypeByIndex(int typeIndex) {
        return this.mItemType;
    }

    private static class Adapter
    extends RecyclerView.Adapter<LayoutVh> {
        private int mLayoutResId;
        private int mItemType;
        private long mStableId;
        private Callback mCallback;
        private boolean mVisible = true;

        private Adapter(int layoutResId, int itemType, Callback callback, long stableId) {
            this.mLayoutResId = layoutResId;
            this.mItemType = itemType;
            this.mCallback = callback;
            this.mStableId = stableId;
            this.setHasStableIds(stableId != -1L);
        }

        public LayoutVh onCreateViewHolder(ViewGroup parent, int viewType) {
            View view = LayoutInflater.from((Context)parent.getContext()).inflate(this.mLayoutResId, parent, false);
            if (this.mCallback != null) {
                this.mCallback.onInflateComplete(view, parent);
            }
            return new LayoutVh(view);
        }

        public void onBindViewHolder(LayoutVh holder, int position) {
        }

        public int getItemCount() {
            return this.mVisible ? 1 : 0;
        }

        public long getItemId(int position) {
            return this.mStableId;
        }

        public int getItemViewType(int position) {
            return this.mItemType;
        }

        public boolean isVisible() {
            return this.mVisible;
        }

        public void setVisible(boolean visible) {
            if (this.mVisible && !visible) {
                this.mVisible = false;
                this.notifyItemRemoved(0);
            } else if (!this.mVisible && visible) {
                this.mVisible = true;
                this.notifyItemInserted(0);
            }
        }

        protected static class LayoutVh
        extends RecyclerView.ViewHolder {
            public LayoutVh(View itemView) {
                super(itemView);
            }
        }
    }

    public static interface Callback {
        public void onInflateComplete(View var1, ViewGroup var2);
    }
}

