/*
 * Decompiled with CFR 0.152.
 */
package su.j2e.rvjoiner;

import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.view.ViewGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RvJoiner {
    private static final String TAG = RvJoiner.class.getName();
    private HostAdapter mHostAdapter;
    private boolean mAutoUpdate;
    private Map<Joinable, DataObserver> mJoinableToObserver = new HashMap<Joinable, DataObserver>();

    public RvJoiner(boolean autoUpdate, boolean hasStableIds) {
        this.mAutoUpdate = autoUpdate;
        this.mHostAdapter = new HostAdapter(hasStableIds);
    }

    public RvJoiner() {
        this(true, false);
    }

    public RvJoiner(boolean hasStableIds) {
        this(true, hasStableIds);
    }

    public int getJoinableCount() {
        return this.mHostAdapter.getJoinableCountInternal();
    }

    public boolean add(Joinable joinable, int location) {
        if (joinable == null) {
            return false;
        }
        boolean wasAdded = this.mHostAdapter.addJoinableInternal(joinable, location);
        if (wasAdded && this.mAutoUpdate) {
            try {
                if (this.mJoinableToObserver.get(joinable) == null) {
                    this.mJoinableToObserver.put(joinable, new DataObserver(joinable, this.mHostAdapter));
                }
                joinable.getAdapter().registerAdapterDataObserver((RecyclerView.AdapterDataObserver)this.mJoinableToObserver.get(joinable));
            }
            catch (IllegalStateException ex) {
                Log.d((String)TAG, (String)"add: observer was already registered");
            }
        }
        return wasAdded;
    }

    public boolean add(Joinable joinable) {
        return this.add(joinable, this.getJoinableCount());
    }

    public boolean remove(Joinable joinable) {
        if (joinable == null) {
            return false;
        }
        if (this.mAutoUpdate) {
            try {
                joinable.getAdapter().unregisterAdapterDataObserver((RecyclerView.AdapterDataObserver)this.mJoinableToObserver.get(joinable));
            }
            catch (IllegalArgumentException | IllegalStateException ex) {
                Log.d((String)TAG, (String)"remove: observer not registered");
            }
        }
        return this.mHostAdapter.removeJoinableInternal(joinable);
    }

    public RecyclerView.Adapter getAdapter() {
        return this.mHostAdapter;
    }

    public PositionInfo getPositionInfo(int joinedPosition) {
        return this.mHostAdapter.getPositionInfoInternal(joinedPosition);
    }

    private static class DataObserver
    extends RecyclerView.AdapterDataObserver {
        private Joinable mJoinable;
        private HostAdapter mHostAdapter;

        private DataObserver(Joinable joinable, HostAdapter hostAdapter) {
            this.mJoinable = joinable;
            this.mHostAdapter = hostAdapter;
        }

        public void onChanged() {
            this.mHostAdapter.notifyDataSetChanged();
        }

        public void onItemRangeChanged(int positionStart, int itemCount) {
            this.mHostAdapter.notifyItemRangeChanged(this.getJoinedPosition(positionStart), itemCount);
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
            this.mHostAdapter.notifyItemRangeInserted(this.getJoinedPosition(positionStart), itemCount);
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            this.mHostAdapter.notifyItemRangeRemoved(this.getJoinedPosition(positionStart), itemCount);
        }

        public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
            if (itemCount == 1) {
                this.mHostAdapter.notifyItemMoved(this.getJoinedPosition(fromPosition), this.getJoinedPosition(toPosition));
            } else if (itemCount > 1) {
                this.onChanged();
            }
        }

        private int getJoinedPosition(int realPosition) {
            return this.mHostAdapter.getJoinedPosition(realPosition, this.mJoinable);
        }
    }

    private static class HostAdapter
    extends RecyclerView.Adapter {
        private static final String TAG = HostAdapter.class.getName();
        private List<Joinable> mJoinables = new ArrayList<Joinable>();
        private SparseArray<PositionInfo> mItemInfoCache = new SparseArray();
        private int mLastGeneratedJoinedTypeId = 0;
        private SparseIntArray mJoinedTypeToRealType = new SparseIntArray();
        private SparseArray<Joinable> mJoinedTypeToJoinable = new SparseArray();
        private Map<Joinable, SparseIntArray> mJoinableToRealToJoinedTypes = new HashMap<Joinable, SparseIntArray>();
        private int mCurrentItemCount = 0;
        private List<Integer> mJoinedPosToJoinedType = new ArrayList<Integer>();
        private List<Integer> mJoinedPosToRealPos = new ArrayList<Integer>();
        private List<Joinable> mJoinedPosToJoinable = new ArrayList<Joinable>();
        private Map<Joinable, int[]> mJoinableToJoinedPosArray = new HashMap<Joinable, int[]>();

        private HostAdapter(boolean hasStableIds) {
            this.setHasStableIds(hasStableIds);
            this.registerAdapterDataObserver(new RecyclerView.AdapterDataObserver(){

                public void onChanged() {
                    HostAdapter.this.postDataSetChanged();
                }

                public void onItemRangeChanged(int positionStart, int itemCount) {
                    this.onChanged();
                }

                public void onItemRangeInserted(int positionStart, int itemCount) {
                    this.onChanged();
                }

                public void onItemRangeRemoved(int positionStart, int itemCount) {
                    this.onChanged();
                }

                public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
                    this.onChanged();
                }
            });
        }

        public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int joinedType) {
            return ((Joinable)this.mJoinedTypeToJoinable.get(joinedType)).getAdapter().onCreateViewHolder(parent, this.mJoinedTypeToRealType.get(joinedType));
        }

        public void onBindViewHolder(RecyclerView.ViewHolder holder, int joinedPosition) {
            this.mJoinedPosToJoinable.get(joinedPosition).getAdapter().onBindViewHolder(holder, this.mJoinedPosToRealPos.get(joinedPosition).intValue());
        }

        public long getItemId(int joinedPosition) {
            return this.mJoinedPosToJoinable.get(joinedPosition).getAdapter().getItemId(this.mJoinedPosToRealPos.get(joinedPosition).intValue());
        }

        public int getItemCount() {
            return this.mCurrentItemCount;
        }

        public int getItemViewType(int joinedPosition) {
            return this.mJoinedPosToJoinedType.get(joinedPosition);
        }

        private int getJoinableCountInternal() {
            return this.mJoinables.size();
        }

        private int getJoinableStartPosition(Joinable joinable) {
            int positionStart = 0;
            for (Joinable currentJoinable : this.mJoinables) {
                if (currentJoinable == joinable) {
                    return positionStart;
                }
                positionStart += currentJoinable.getAdapter().getItemCount();
            }
            return -1;
        }

        private boolean addJoinableInternal(@NonNull Joinable joinable, int location) {
            if (!this.mJoinables.contains(joinable)) {
                this.mJoinables.add(location, joinable);
                this.postStructureChanged(joinable);
                int positionStart = this.getJoinableStartPosition(joinable);
                this.notifyItemRangeInserted(positionStart, joinable.getAdapter().getItemCount());
                return true;
            }
            return false;
        }

        private boolean removeJoinableInternal(@NonNull Joinable joinable) {
            int positionStart = this.getJoinableStartPosition(joinable);
            if (positionStart != -1) {
                this.mJoinables.remove(joinable);
                this.postStructureChanged(joinable);
                this.notifyItemRangeRemoved(positionStart, joinable.getAdapter().getItemCount());
                return true;
            }
            return false;
        }

        private void postStructureChanged(Joinable diffJoinable) {
            if (this.mJoinables.contains(diffJoinable)) {
                SparseIntArray realToJoinedTypes = new SparseIntArray(diffJoinable.getTypeCount());
                for (int i = 0; i < diffJoinable.getTypeCount(); ++i) {
                    int newTypeId;
                    ++this.mLastGeneratedJoinedTypeId;
                    this.mJoinedTypeToJoinable.put(newTypeId, (Object)diffJoinable);
                    this.mJoinedTypeToRealType.put(newTypeId, diffJoinable.getTypeByIndex(i));
                    realToJoinedTypes.put(diffJoinable.getTypeByIndex(i), newTypeId);
                }
                this.mJoinableToRealToJoinedTypes.put(diffJoinable, realToJoinedTypes);
            }
        }

        private void postDataSetChanged() {
            this.mCurrentItemCount = 0;
            this.mJoinedPosToJoinedType.clear();
            this.mJoinedPosToRealPos.clear();
            this.mJoinedPosToJoinable.clear();
            this.mJoinableToJoinedPosArray.clear();
            for (Joinable joinable : this.mJoinables) {
                int[] joinedPosArray = new int[joinable.getAdapter().getItemCount()];
                for (int i = 0; i < joinable.getAdapter().getItemCount(); ++i) {
                    joinedPosArray[i] = this.mCurrentItemCount++;
                    int itemRealType = joinable.getAdapter().getItemViewType(i);
                    int itemJoinedType = this.mJoinableToRealToJoinedTypes.get(joinable).get(itemRealType);
                    this.mJoinedPosToJoinedType.add(itemJoinedType);
                    this.mJoinedPosToRealPos.add(i);
                    this.mJoinedPosToJoinable.add(joinable);
                }
                this.mJoinableToJoinedPosArray.put(joinable, joinedPosArray);
            }
            this.mItemInfoCache.clear();
        }

        private PositionInfo getPositionInfoInternal(int joinedPosition) {
            PositionInfo positionInfo = (PositionInfo)this.mItemInfoCache.get(joinedPosition);
            if (positionInfo == null) {
                try {
                    positionInfo = new PositionInfo(joinedPosition, this.mJoinedPosToRealPos.get(joinedPosition), this.mJoinedPosToJoinable.get(joinedPosition), this.mJoinedPosToJoinedType.get(joinedPosition), this.mJoinedTypeToRealType.get(this.mJoinedPosToJoinedType.get(joinedPosition).intValue()));
                    this.mItemInfoCache.put(joinedPosition, (Object)positionInfo);
                }
                catch (IndexOutOfBoundsException ex) {
                    Log.e((String)TAG, (String)("getPositionInfoInternal: position doesn't exist: " + joinedPosition), (Throwable)ex);
                }
            }
            return positionInfo;
        }

        private int getJoinedPosition(int realPosition, Joinable joinable) {
            int[] joinedPosArray = this.mJoinableToJoinedPosArray.get(joinable);
            if (joinedPosArray != null && realPosition >= 0 && realPosition < joinedPosArray.length) {
                return this.mJoinableToJoinedPosArray.get(joinable)[realPosition];
            }
            return -1;
        }
    }

    public static class RealPositionProvider {
        private RvJoiner mRvJoiner;

        public RealPositionProvider(RvJoiner rvJoiner) {
            this.mRvJoiner = rvJoiner;
        }

        public int getRealPosition(int joinedPosition) {
            if (this.mRvJoiner == null) {
                return joinedPosition;
            }
            PositionInfo positionInfo = this.mRvJoiner.getPositionInfo(joinedPosition);
            return positionInfo != null ? positionInfo.realPosition : -1;
        }
    }

    public static class PositionInfo {
        public final int joinedPosition;
        public final int realPosition;
        public final Joinable joinable;
        public final int joinedType;
        public final int realType;

        private PositionInfo(int joinedPosition, int realPosition, Joinable joinable, int joinedType, int realType) {
            this.joinedPosition = joinedPosition;
            this.realPosition = realPosition;
            this.joinable = joinable;
            this.joinedType = joinedType;
            this.realType = realType;
        }
    }

    public static interface Joinable {
        public RecyclerView.Adapter getAdapter();

        public int getTypeCount();

        public int getTypeByIndex(int var1);
    }
}

