/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.base;

import com.alibaba.fastjson.JSON;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.ResponseEntity;
import org.springframework.ui.ModelMap;
import top.ibase4j.core.support.HttpCode;
import top.ibase4j.core.support.Pagination;
import top.ibase4j.core.util.InstanceUtil;
import top.ibase4j.core.util.ShiroUtil;
import top.ibase4j.core.util.WebUtil;

public abstract class AbstractController {
    protected Logger logger = LogManager.getLogger();

    protected Long getCurrUser() {
        return ShiroUtil.getCurrentUser();
    }

    protected Long getCurrUser(HttpServletRequest request) {
        Object id = WebUtil.getCurrentUser(request);
        if (id == null) {
            return null;
        }
        return Long.parseLong(id.toString());
    }

    protected ResponseEntity<ModelMap> setSuccessModelMap() {
        return this.setSuccessModelMap(new ModelMap(), null);
    }

    protected ResponseEntity<ModelMap> setSuccessModelMap(ModelMap modelMap) {
        return this.setSuccessModelMap(modelMap, null);
    }

    protected ResponseEntity<ModelMap> setSuccessModelMap(Object data) {
        return this.setModelMap(new ModelMap(), HttpCode.OK, data);
    }

    protected ResponseEntity<ModelMap> setSuccessModelMap(ModelMap modelMap, Object data) {
        return this.setModelMap(modelMap, HttpCode.OK, data);
    }

    protected ResponseEntity<ModelMap> setModelMap(HttpCode code) {
        return this.setModelMap(new ModelMap(), code, null);
    }

    protected ResponseEntity<ModelMap> setModelMap(String code, String msg) {
        return this.setModelMap(new ModelMap(), code, msg, null);
    }

    protected ResponseEntity<ModelMap> setModelMap(ModelMap modelMap, HttpCode code) {
        return this.setModelMap(modelMap, code, null);
    }

    protected ResponseEntity<ModelMap> setModelMap(HttpCode code, Object data) {
        return this.setModelMap(new ModelMap(), code, data);
    }

    protected ResponseEntity<ModelMap> setModelMap(String code, String msg, Object data) {
        return this.setModelMap(new ModelMap(), code, msg, data);
    }

    protected ResponseEntity<ModelMap> setModelMap(ModelMap modelMap, HttpCode code, Object data) {
        return this.setModelMap(modelMap, code.value().toString(), code.msg(), data);
    }

    protected ResponseEntity<ModelMap> setModelMap(ModelMap modelMap, String code, String msg, Object data) {
        if (!modelMap.isEmpty()) {
            LinkedHashMap map = InstanceUtil.newLinkedHashMap();
            map.putAll(modelMap);
            modelMap.clear();
            for (String key : map.keySet()) {
                if (key.startsWith("org.springframework.validation.BindingResult") || key.equals("void")) continue;
                modelMap.put((Object)key, map.get(key));
            }
        }
        if (data != null) {
            if (data instanceof Pagination) {
                Pagination page = (Pagination)data;
                modelMap.put((Object)"rows", page.getRecords());
                modelMap.put((Object)"current", (Object)page.getCurrent());
                modelMap.put((Object)"size", (Object)page.getSize());
                modelMap.put((Object)"pages", (Object)page.getPages());
                modelMap.put((Object)"total", (Object)page.getTotal());
            } else if (data instanceof List) {
                modelMap.put((Object)"rows", data);
                modelMap.put((Object)"total", (Object)((List)data).size());
            } else {
                modelMap.put((Object)"data", data);
            }
        }
        modelMap.put((Object)"code", (Object)code);
        modelMap.put((Object)"msg", (Object)msg);
        modelMap.put((Object)"timestamp", (Object)System.currentTimeMillis());
        this.logger.info("response===>{}", (Object)JSON.toJSONString((Object)modelMap));
        return ResponseEntity.ok((Object)modelMap);
    }
}

