/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.interceptor;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.net.util.Base64;
import top.ibase4j.core.interceptor.BaseInterceptor;
import top.ibase4j.core.support.HttpCode;
import top.ibase4j.core.support.security.coder.MDCoder;
import top.ibase4j.core.support.security.coder.RSACoder;
import top.ibase4j.core.util.CacheUtil;
import top.ibase4j.core.util.DataUtil;
import top.ibase4j.core.util.FileUtil;
import top.ibase4j.core.util.WebUtil;

public class SignInterceptor
extends BaseInterceptor {
    private List<String> whiteUrls;
    private int _size = 0;

    public SignInterceptor() {
        String path = SignInterceptor.class.getResource("/").getFile();
        this.whiteUrls = FileUtil.readFile(path + "white/signWhite.txt");
        this._size = null == this.whiteUrls ? 0 : this.whiteUrls.size();
    }

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String url = request.getRequestURL().toString();
        String refer = request.getHeader("Referer");
        if (url.contains("/app/secret.api") || refer != null && refer.contains("/swagger") || WebUtil.isWhiteRequest(url, this._size, this.whiteUrls)) {
            logger.info("SignInterceptor skip");
            return super.preHandle(request, response, handler);
        }
        String uuid = request.getHeader("UUID");
        if (DataUtil.isEmpty(uuid)) {
            return WebUtil.write(response, HttpCode.METHOD_NOT_ALLOWED.value(), "\u7f3a\u5c11\u7b7e\u540d\u5fc5\u987b\u6761\u4ef6");
        }
        String publicKey = (String)CacheUtil.getCache().get("S:iBase4J:SIGN:" + uuid);
        if (DataUtil.isEmpty(publicKey)) {
            return WebUtil.write(response, HttpCode.NOT_EXTENDED.value(), "\u5bc6\u94a5\u5df2\u8fc7\u671f");
        }
        Map<String, Object> params = WebUtil.getParameterMap(request);
        Object[] keys = params.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        StringBuilder sb = new StringBuilder();
        for (Object key : keys) {
            if ("sign".equals(key) || "dataFile".equals(key)) continue;
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(((String)key).length()).append("=").append(params.get(key).toString().length());
        }
        String data = Base64.encodeBase64String((byte[])MDCoder.encodeMD5(sb.toString().getBytes("UTF-8")));
        String sign = (String)params.get("sign");
        if (sign == null) {
            return WebUtil.write(response, HttpCode.NOT_ACCEPTABLE.value(), "\u8bf7\u6c42\u53c2\u6570\u672a\u7b7e\u540d");
        }
        sign = sign.replace(' ', '+');
        if (!RSACoder.verify(data.getBytes("UTF-8"), Base64.decodeBase64((String)publicKey), Base64.decodeBase64((String)sign))) {
            return WebUtil.write(response, HttpCode.FORBIDDEN.value(), HttpCode.FORBIDDEN.msg());
        }
        logger.info("SignInterceptor successful");
        return super.preHandle(request, response, handler);
    }
}

