/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.support.cache.redisson;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.redisson.api.RMap;
import org.redisson.api.RMapCache;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.spring.cache.CacheConfig;
import org.redisson.spring.cache.RedissonCache;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class SpringCacheManager
implements CacheManager,
ResourceLoaderAware,
InitializingBean {
    private ResourceLoader resourceLoader;
    private boolean allowNullValues;
    private Codec codec;
    private RedissonClient redisson;
    private Map<String, CacheConfig> configMap = new LinkedHashMap<String, CacheConfig>();
    private Map<String, CacheConfig> patternMap = new LinkedHashMap<String, CacheConfig>();
    private String configLocation;
    private String regExpConfigLocation;

    public SpringCacheManager() {
    }

    public SpringCacheManager(RedissonClient redisson, Map<String, CacheConfig> config) {
        this(redisson, config, null, null);
    }

    public SpringCacheManager(RedissonClient redisson, Map<String, CacheConfig> config, Codec codec) {
        this(redisson, config, null, codec);
    }

    public SpringCacheManager(RedissonClient redisson, Map<String, CacheConfig> config, Map<String, CacheConfig> patternConfig) {
        this(redisson, config, patternConfig, null);
    }

    public SpringCacheManager(RedissonClient redisson, Map<String, CacheConfig> config, Map<String, CacheConfig> patternConfig, Codec codec) {
        this.redisson = redisson;
        if (config != null) {
            this.configMap.putAll(config);
        }
        if (patternConfig != null) {
            this.patternMap.putAll(patternConfig);
        }
        this.codec = codec;
    }

    public SpringCacheManager(RedissonClient redisson, String configLocation) {
        this(redisson, configLocation, null, null);
    }

    public SpringCacheManager(RedissonClient redisson, String configLocation, String regExpConfigLocation) {
        this(redisson, configLocation, regExpConfigLocation, null);
    }

    public SpringCacheManager(RedissonClient redisson, String configLocation, Codec codec) {
        this(redisson, configLocation, null, codec);
    }

    public SpringCacheManager(RedissonClient redisson, String configLocation, String regExpConfigLocation, Codec codec) {
        this.allowNullValues = true;
        this.redisson = redisson;
        this.configLocation = configLocation;
        this.regExpConfigLocation = regExpConfigLocation;
        this.codec = codec;
    }

    public void setConfigLocation(String configLocation) {
        this.configLocation = configLocation;
    }

    public void setRegExpConfigLocation(String regExpConfigLocation) {
        this.regExpConfigLocation = regExpConfigLocation;
    }

    public void setConfig(Map<String, ? extends CacheConfig> config) {
        this.configMap.clear();
        if (config == null) {
            return;
        }
        this.configMap.putAll(config);
    }

    public void setPatternConfig(Map<String, CacheConfig> config) {
        this.patternMap.clear();
        if (config == null) {
            return;
        }
        this.patternMap.putAll(config);
    }

    public void setRedisson(RedissonClient redisson) {
        this.redisson = redisson;
    }

    public void setCodec(Codec codec) {
        this.codec = codec;
    }

    public void setAllowNullValues(boolean allowNullValues) {
        this.allowNullValues = allowNullValues;
    }

    public Cache getCache(String name) {
        RMapCache<Object, Object> map;
        String cacheName;
        CacheConfig config = this.configMap.get(name);
        if (config == null) {
            Pattern pattern = this.testRegExp(name);
            if (pattern == null) {
                config = new CacheConfig();
                this.configMap.put(name, config);
                RMap<Object, Object> map2 = this.createMap(name);
                return new RedissonCache(map2, this.allowNullValues);
            }
            config = this.patternMap.get(name);
            cacheName = pattern.pattern();
        } else {
            cacheName = name;
        }
        if (config.getMaxIdleTime() == 0L && config.getTTL() == 0L) {
            map = this.createMap(cacheName);
            return new RedissonCache(map, this.allowNullValues);
        }
        map = this.createMapCache(cacheName);
        return new RedissonCache(map, config, this.allowNullValues);
    }

    private Pattern testRegExp(String name) {
        for (String regex : this.patternMap.keySet()) {
            Pattern pattern = Pattern.compile(regex);
            if (!pattern.matcher(name).matches()) continue;
            return pattern;
        }
        return null;
    }

    private RMap<Object, Object> createMap(String name) {
        if (this.codec != null) {
            return this.redisson.getMap(name, this.codec);
        }
        return this.redisson.getMap(name);
    }

    private RMapCache<Object, Object> createMapCache(String name) {
        if (this.codec != null) {
            return this.redisson.getMapCache(name, this.codec);
        }
        return this.redisson.getMapCache(name);
    }

    public Collection<String> getCacheNames() {
        Set names = Collections.emptySet();
        names.addAll(this.getConfigNames());
        names.addAll(this.getPatternNames());
        return Collections.unmodifiableSet(names);
    }

    public Collection<String> getConfigNames() {
        return Collections.unmodifiableSet(this.configMap.keySet());
    }

    public Collection<String> getPatternNames() {
        Set patterns = Collections.emptySet();
        for (String k : this.patternMap.keySet()) {
            patterns.add(k);
        }
        return Collections.unmodifiableSet(patterns);
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void afterPropertiesSet() throws Exception {
        Resource resource;
        if (this.configLocation != null) {
            resource = this.resourceLoader.getResource(this.configLocation);
            try {
                this.setConfig(CacheConfig.fromJSON((InputStream)resource.getInputStream()));
            }
            catch (IOException e) {
                try {
                    this.setConfig(CacheConfig.fromYAML((InputStream)resource.getInputStream()));
                }
                catch (IOException e1) {
                    throw new BeanDefinitionStoreException("Could not parse cache configuration at [" + this.configLocation + "]", (Throwable)e1);
                }
            }
        }
        if (this.regExpConfigLocation != null) {
            Map confs;
            resource = this.resourceLoader.getResource(this.regExpConfigLocation);
            try {
                confs = CacheConfig.fromJSON((InputStream)resource.getInputStream());
            }
            catch (IOException e) {
                try {
                    confs = CacheConfig.fromYAML((InputStream)resource.getInputStream());
                }
                catch (IOException e1) {
                    throw new BeanDefinitionStoreException("Could not parse cache configuration at [" + this.configLocation + "]", (Throwable)e1);
                }
            }
            for (Map.Entry conf : confs.entrySet()) {
                this.patternMap.put((String)conf.getKey(), (CacheConfig)conf.getValue());
            }
        }
    }
}

