/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.support.scheduler;

import com.alibaba.fastjson.JSON;
import java.sql.Timestamp;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import top.ibase4j.core.support.email.Email;
import top.ibase4j.core.support.mq.QueueSender;
import top.ibase4j.core.support.scheduler.SchedulerService;
import top.ibase4j.core.util.EmailUtil;
import top.ibase4j.core.util.NativeUtil;
import top.ibase4j.model.TaskFireLog;

public class JobListener
implements org.quartz.JobListener {
    private static Logger logger = LogManager.getLogger(JobListener.class);
    @Lazy
    @Autowired
    private SchedulerService schedulerService;
    private QueueSender emailQueueSender;
    private static ExecutorService executorService = Executors.newCachedThreadPool();
    private static String JOB_LOG = "jobLog";

    public void setEmailQueueSender(QueueSender emailQueueSender) {
        this.emailQueueSender = emailQueueSender;
    }

    public String getName() {
        return "taskListener";
    }

    public void jobExecutionVetoed(JobExecutionContext context) {
    }

    public void jobToBeExecuted(JobExecutionContext context) {
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        String targetObject = jobDataMap.getString("targetObject");
        String targetMethod = jobDataMap.getString("targetMethod");
        if (logger.isInfoEnabled()) {
            logger.info("\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\u6267\u884c\uff1a{}.{}", (Object)targetObject, (Object)targetMethod);
        }
        TaskFireLog log = new TaskFireLog();
        log.setStartTime(context.getFireTime());
        log.setGroupName(targetObject);
        log.setTaskName(targetMethod);
        log.setStatus("I");
        log.setServerHost(NativeUtil.getHostName());
        log.setServerDuid(NativeUtil.getDUID());
        this.schedulerService.updateLog(log);
        jobDataMap.put(JOB_LOG, (Object)log);
    }

    public void jobWasExecuted(JobExecutionContext context, JobExecutionException exp) {
        TaskFireLog log;
        Timestamp end = new Timestamp(System.currentTimeMillis());
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        String targetObject = jobDataMap.getString("targetObject");
        String targetMethod = jobDataMap.getString("targetMethod");
        if (logger.isInfoEnabled()) {
            logger.info("\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u7ed3\u675f\uff1a{}.{}", (Object)targetObject, (Object)targetMethod);
        }
        if ((log = (TaskFireLog)jobDataMap.get((Object)JOB_LOG)) != null) {
            log.setEndTime(end);
            if (exp != null) {
                logger.error("\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25: [" + targetObject + "." + targetMethod + "]", (Throwable)exp);
                String contactEmail = jobDataMap.getString("contactEmail");
                if (StringUtils.isNotBlank((CharSequence)contactEmail)) {
                    String topic = String.format("\u8c03\u5ea6[%s.%s]\u53d1\u751f\u5f02\u5e38", targetMethod, targetMethod);
                    this.sendEmail(new Email(contactEmail, topic, exp.getMessage()));
                }
                log.setStatus("E");
                log.setFireInfo(exp.getMessage());
            } else if (log.getStatus().equals("I")) {
                log.setStatus("S");
            }
        }
        executorService.submit(new Runnable(){

            @Override
            public void run() {
                if (log != null) {
                    try {
                        JobListener.this.schedulerService.updateLog(log);
                    }
                    catch (Exception e) {
                        logger.error("Update TaskRunLog cause error. The log object is : " + JSON.toJSONString((Object)log), (Throwable)e);
                    }
                }
            }
        });
    }

    private void sendEmail(final Email email) {
        executorService.submit(new Runnable(){

            @Override
            public void run() {
                if (JobListener.this.emailQueueSender != null) {
                    JobListener.this.emailQueueSender.send("iBase4J.emailSender", email);
                } else {
                    logger.info("\u5c06\u53d1\u9001\u90ae\u4ef6\u81f3\uff1a" + email.getSendTo());
                    EmailUtil.sendEmail(email);
                }
            }
        });
    }
}

