/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.support.scheduler.job;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.context.ApplicationContext;
import top.ibase4j.core.base.provider.IBaseProvider;
import top.ibase4j.core.base.provider.Parameter;
import top.ibase4j.core.support.generator.Sequence;
import top.ibase4j.core.util.CacheUtil;
import top.ibase4j.core.util.DataUtil;
import top.ibase4j.core.util.MathUtil;

public class BaseJob
implements Job {
    private final Logger logger = LogManager.getLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        block11: {
            long start = System.currentTimeMillis();
            JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
            String taskType = jobDataMap.getString("taskType");
            String targetObject = jobDataMap.getString("targetObject");
            String targetMethod = jobDataMap.getString("targetMethod");
            String key = targetMethod + "." + targetObject;
            try {
                this.logger.info("\u5b9a\u65f6\u4efb\u52a1[{}.{}]\u5f00\u59cb", (Object)targetObject, (Object)targetMethod);
                String requestId = Sequence.next().toString();
                if (!CacheUtil.getCache().lock(key, requestId, 18000L)) break block11;
                try {
                    Object refer;
                    ApplicationContext applicationContext = (ApplicationContext)context.getScheduler().getContext().get((Object)"applicationContext");
                    if ("LOCAL".equals(taskType)) {
                        refer = applicationContext.getBean(targetObject);
                        refer.getClass().getDeclaredMethod(targetMethod, new Class[0]).invoke(refer, new Object[0]);
                    } else if ("DUBBO".equals(taskType)) {
                        if (DataUtil.isEmpty(jobDataMap.getString("targetSystem"))) {
                            refer = applicationContext.getBean(targetObject);
                            refer.getClass().getDeclaredMethod(targetMethod, new Class[0]).invoke(refer, new Object[0]);
                        } else {
                            IBaseProvider provider = (IBaseProvider)applicationContext.getBean(jobDataMap.getString("targetSystem"));
                            provider.execute(new Parameter(targetObject, targetMethod));
                        }
                    } else {
                        refer = applicationContext.getBean(targetObject);
                        refer.getClass().getDeclaredMethod(targetMethod, new Class[0]).invoke(refer, new Object[0]);
                    }
                    Double time = (double)(System.currentTimeMillis() - start) / 1000.0;
                    this.logger.info("\u5b9a\u65f6\u4efb\u52a1[{}.{}]\u7528\u65f6\uff1a{}s", (Object)targetObject, (Object)targetMethod, (Object)time.toString());
                }
                finally {
                    this.unLock(key, requestId);
                }
            }
            catch (Exception e) {
                throw new JobExecutionException((Throwable)e);
            }
        }
    }

    private void unLock(String key, String requestId) {
        try {
            CacheUtil.getCache().unlock(key, requestId);
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
            try {
                Thread.sleep(MathUtil.getRandom(100.0, 2000.0).longValue());
            }
            catch (Exception e2) {
                this.logger.error("", (Throwable)e2);
            }
            this.unLock(key, requestId);
        }
    }
}

