/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.util;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.ibase4j.core.exception.BusinessException;
import top.ibase4j.core.support.cache.ICacheManager;
import top.ibase4j.core.support.generator.Sequence;
import top.ibase4j.core.util.DataUtil;
import top.ibase4j.core.util.InstanceUtil;
import top.ibase4j.core.util.MathUtil;
import top.ibase4j.core.util.PropertiesUtil;
import top.ibase4j.mapper.LockMapper;
import top.ibase4j.model.Lock;

public final class CacheUtil {
    private static Logger logger = LogManager.getLogger();
    private static LockMapper lockMapper;
    private static ICacheManager cacheManager;
    private static ICacheManager lockManager;
    private static Map<String, ReentrantLock> thread;
    private static ExecutorService executorService;

    public static void setLockMapper(LockMapper lockMapper) {
        CacheUtil.lockMapper = lockMapper;
    }

    public static void setCacheManager(ICacheManager cacheManager) {
        CacheUtil.cacheManager = cacheManager;
    }

    public static void setLockManager(ICacheManager cacheManager) {
        lockManager = cacheManager;
    }

    public static ICacheManager getCache() {
        return cacheManager;
    }

    public static ICacheManager getLockManager() {
        return lockManager;
    }

    public static boolean getLock(String key, String requestId) {
        return CacheUtil.getLock(key, key, requestId);
    }

    public static boolean getLock(String key, String requestId, int seconds) {
        return CacheUtil.getLock(key, key, requestId, seconds);
    }

    public static boolean getLock(String key, String name, String requestId) {
        return CacheUtil.getLock(key, name, requestId, 60);
    }

    public static boolean getLock(final String key, final String name, String requestId, final int seconds) {
        logger.debug("TOLOCK : " + key);
        try {
            boolean seccess = lockManager.lock(key, requestId, seconds);
            if (seccess) {
                executorService.execute(new Runnable(){

                    @Override
                    public void run() {
                        CacheUtil.getDBLock(key, name, seconds);
                    }
                });
            }
            return seccess;
        }
        catch (Exception e) {
            logger.error("\u4eceredis\u83b7\u53d6\u9501\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            return CacheUtil.getDBLock(key, name, seconds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Boolean getDBLock(final String key, final String name, final int seconds) {
        try {
            thread.put(key, new ReentrantLock());
            thread.get(key).lock();
            try {
                final Lock param = new Lock();
                param.setKey(key);
                Lock lock = (Lock)lockMapper.selectOne(param);
                if (lock == null) {
                    Boolean bl = executorService.submit(new Callable<Boolean>(){

                        @Override
                        public Boolean call() throws Exception {
                            logger.debug("\u4fdd\u5b58\u9501\u4fe1\u606f\u5230\u6570\u636e\u5e93>" + key);
                            param.setName(name);
                            param.setExpireSecond(seconds);
                            return lockMapper.insert(param) == 1;
                        }
                    }).get();
                    return bl;
                }
                Boolean bl = false;
                return bl;
            }
            finally {
                thread.get(key).unlock();
            }
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u9501\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            try {
                Thread.sleep(50L);
                return CacheUtil.getDBLock(key, name, seconds);
            }
            catch (InterruptedException e1) {
                logger.error("\u7ebf\u7a0b\u7b49\u5f85\u5f02\u5e38", (Throwable)e1);
            }
            return CacheUtil.getDBLock(key, name, seconds);
        }
    }

    public static void unLock(String key, String requestId) {
        logger.debug("UNLOCK : " + key);
        try {
            lockManager.unlock(key, requestId);
        }
        catch (Exception e) {
            logger.error("\u4eceredis\u5220\u9664\u9501\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
        CacheUtil.deleteLock(key, 1);
    }

    private static void deleteLock(final String key, int times) {
        boolean success;
        block11: {
            success = false;
            try {
                if (!thread.containsKey(key)) break block11;
                thread.get(key).lock();
                try {
                    logger.debug("\u4ece\u6570\u636e\u5e93\u5220\u9664\u9501\u4fe1\u606f>" + key);
                    success = executorService.submit(new Callable<Boolean>(){

                        @Override
                        public Boolean call() throws Exception {
                            HashMap<String, String> columnMap = InstanceUtil.newHashMap("key_", key);
                            return lockMapper.deleteByMap(columnMap) > 0;
                        }
                    }).get();
                }
                finally {
                    thread.get(key).unlock();
                }
            }
            catch (Exception e) {
                logger.error("\u4ece\u6570\u636e\u5e93\u5220\u9664\u9501\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            }
        }
        if (!success) {
            if (times > PropertiesUtil.getInt("deleteLock.maxTimes", 20)) {
                return;
            }
            if (thread.containsKey(key)) {
                logger.warn(key + "\u4ece\u6570\u636e\u5e93\u5220\u9664\u9501\u4fe1\u606f\u5931\u8d25,\u7a0d\u5019\u518d\u6b21\u5c1d\u8bd5...");
            }
            try {
                Thread.sleep(MathUtil.getRandom(100.0, 1000.0).longValue());
            }
            catch (InterruptedException e1) {
                logger.error("\u7ebf\u7a0b\u7b49\u5f85\u5f02\u5e38", (Throwable)e1);
            }
            CacheUtil.deleteLock(key, times + 1);
        } else {
            thread.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshTimes(String key, int seconds, int frequency, String message) {
        String requestId = Sequence.next().toString();
        if (CacheUtil.getLock(key + "-LOCK", "\u6b21\u6570\u9650\u5236", requestId, 10)) {
            try {
                Integer times = 1;
                String timesStr = (String)lockManager.get(key);
                if (DataUtil.isNotEmpty(timesStr) && (times = Integer.valueOf(Integer.valueOf(timesStr) + 1)) > frequency) {
                    throw new BusinessException(message);
                }
                lockManager.set(key, (Serializable)((Object)times.toString()), seconds);
            }
            finally {
                CacheUtil.unLock(key + "-LOCK", requestId);
            }
        } else {
            CacheUtil.refreshTimes(key, seconds, frequency, message);
        }
    }

    static {
        thread = InstanceUtil.newConcurrentHashMap();
        executorService = Executors.newFixedThreadPool(50);
    }
}

