/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public final class DataUtil {
    private DataUtil() {
    }

    public static final String byte2hex(byte[] b) {
        StringBuilder hs = new StringBuilder(b.length * 2);
        String stmp = "";
        for (byte element : b) {
            stmp = Integer.toHexString(element & 0xFF);
            if (stmp.length() == 1) {
                hs.append("0").append(stmp);
                continue;
            }
            hs.append(stmp);
        }
        return hs.toString();
    }

    public static final byte[] hex2byte(String hs) {
        byte[] b = hs.getBytes();
        if (b.length % 2 != 0) {
            throw new IllegalArgumentException("\u957f\u5ea6\u4e0d\u662f\u5076\u6570");
        }
        byte[] b2 = new byte[b.length / 2];
        for (int n = 0; n < b.length; n += 2) {
            String item = new String(b, n, 2);
            b2[n / 2] = (byte)Integer.parseInt(item, 16);
        }
        return b2;
    }

    public static final String getFullPathRelateClass(String relatedPath, Class<?> cls) {
        String path = null;
        if (relatedPath == null) {
            throw new NullPointerException();
        }
        String clsPath = DataUtil.getPathFromClass(cls);
        File clsFile = new File(clsPath);
        String tempPath = clsFile.getParent() + File.separator + relatedPath;
        File file = new File(tempPath);
        try {
            path = file.getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return path;
    }

    public static final String getPathFromClass(Class<?> cls) {
        String path = null;
        if (cls == null) {
            throw new NullPointerException();
        }
        URL url = DataUtil.getClassLocationURL(cls);
        if (url != null) {
            path = url.getPath();
            if ("jar".equalsIgnoreCase(url.getProtocol())) {
                try {
                    path = new URL(path).getPath();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                int location = path.indexOf("!/");
                if (location != -1) {
                    path = path.substring(0, location);
                }
            }
            File file = new File(path);
            try {
                path = file.getCanonicalPath();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return path;
    }

    public static final boolean isEmpty(Object pObj) {
        if (pObj == null || "".equals(pObj)) {
            return true;
        }
        return pObj instanceof String ? ((String)pObj).trim().length() == 0 : (pObj instanceof Collection ? ((Collection)pObj).size() == 0 : pObj instanceof Map && ((Map)pObj).size() == 0);
    }

    public static final boolean isNotEmpty(Object pObj) {
        if (pObj == null || "".equals(pObj)) {
            return false;
        }
        return !(pObj instanceof String ? ((String)pObj).trim().length() == 0 : (pObj instanceof Collection ? ((Collection)pObj).size() == 0 : pObj instanceof Map && ((Map)pObj).size() == 0));
    }

    public static final String[] trim(String[] paramArray) {
        if (ArrayUtils.isEmpty((Object[])paramArray)) {
            return paramArray;
        }
        String[] resultArray = new String[paramArray.length];
        for (int i = 0; i < paramArray.length; ++i) {
            String param = paramArray[i];
            resultArray[i] = StringUtils.trim((String)param);
        }
        return resultArray;
    }

    private static URL getClassLocationURL(Class<?> cls) {
        if (cls == null) {
            throw new IllegalArgumentException("null input: cls");
        }
        URL result = null;
        String clsAsResource = cls.getName().replace('.', '/').concat(".class");
        ProtectionDomain pd = cls.getProtectionDomain();
        if (pd != null) {
            CodeSource cs = pd.getCodeSource();
            if (cs != null) {
                result = cs.getLocation();
            }
            if (result != null && "file".equals(result.getProtocol())) {
                try {
                    if (result.toExternalForm().endsWith(".jar") || result.toExternalForm().endsWith(".zip")) {
                        result = new URL("jar:".concat(result.toExternalForm()).concat("!/").concat(clsAsResource));
                    } else if (new File(result.getFile()).isDirectory()) {
                        result = new URL(result, clsAsResource);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        if (result == null) {
            ClassLoader clsLoader = cls.getClassLoader();
            result = clsLoader != null ? clsLoader.getResource(clsAsResource) : ClassLoader.getSystemResource(clsAsResource);
        }
        return result;
    }

    public static final <K> K ifNull(K k, K defaultValue) {
        if (k == null) {
            return defaultValue;
        }
        return k;
    }
}

