/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.util;

import com.alibaba.fastjson.JSON;
import com.esotericsoftware.reflectasm.MethodAccess;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.ibase4j.core.exception.DataParseException;
import top.ibase4j.core.exception.InstanceException;
import top.ibase4j.core.util.TypeParseUtil;

public final class InstanceUtil {
    protected static Logger logger = LogManager.getLogger();
    private static Map<String, MethodAccess> methodMap = InstanceUtil.newHashMap();
    public static Map<String, Class<?>> clazzMap = new HashMap();

    private InstanceUtil() {
    }

    public static final <T> T to(Object orig, Class<T> clazz) {
        T bean = null;
        try {
            PropertyDescriptor[] propertyDescriptors;
            bean = clazz.newInstance();
            Class<?> cls = orig.getClass();
            BeanInfo orgInfo = Introspector.getBeanInfo(cls);
            PropertyDescriptor[] orgPty = orgInfo.getPropertyDescriptors();
            HashMap propertyMap = InstanceUtil.newHashMap();
            for (PropertyDescriptor property : orgPty) {
                propertyMap.put(property.getName(), property);
            }
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String key = property.getName();
                if (key.equals("class") || !propertyMap.containsKey(key)) continue;
                Method getter = ((PropertyDescriptor)propertyMap.get(key)).getReadMethod();
                Method setter = property.getWriteMethod();
                Object value = "";
                try {
                    value = getter.invoke(orig, new Object[0]);
                    value = TypeParseUtil.convert(value, property.getPropertyType(), null);
                    setter.invoke(bean, value);
                }
                catch (Exception e) {
                    logger.error("to Error " + key + ":" + value + ">" + e);
                }
            }
        }
        catch (Exception e) {
            logger.error("to Error " + e);
        }
        return bean;
    }

    public static final <T> T parse(String json, Class<T> clazz) {
        try {
            Map map = (Map)JSON.parseObject((String)json, Map.class);
            return InstanceUtil.transMap2Bean(map, clazz);
        }
        catch (Exception e) {
            logger.error("parse", (Throwable)e);
            return null;
        }
    }

    public static <T> T transMap2Bean(Map<String, Object> map, Class<T> clazz) {
        T bean = null;
        try {
            PropertyDescriptor[] propertyDescriptors;
            bean = clazz.newInstance();
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String key = property.getName();
                if (!map.containsKey(key)) continue;
                Object value = map.get(key);
                Method setter = property.getWriteMethod();
                setter.invoke(bean, TypeParseUtil.convert(value, property.getPropertyType(), null));
            }
        }
        catch (Exception e) {
            logger.error("transMap2Bean Error ", (Throwable)e);
        }
        return bean;
    }

    public static Map<String, Object> transBean2Map(Object obj) {
        HashMap<String, Object> map = InstanceUtil.newHashMap();
        if (obj == null) {
            return map;
        }
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
            for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String key = property.getName();
                if (key.equals("class")) continue;
                Method getter = property.getReadMethod();
                Object value = getter.invoke(obj, new Object[0]);
                map.put(key, value);
            }
        }
        catch (Exception e) {
            logger.error("transBean2Map Error " + e);
        }
        return map;
    }

    public static <T> T getDiff(T oldBean, T newBean) {
        if (oldBean == null && newBean != null) {
            return newBean;
        }
        if (newBean == null) {
            return null;
        }
        Class<?> cls1 = oldBean.getClass();
        try {
            PropertyDescriptor[] propertyDescriptors;
            Object object = cls1.newInstance();
            BeanInfo beanInfo = Introspector.getBeanInfo(cls1);
            for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String key = property.getName();
                if (key.equals("class")) continue;
                Method getter = property.getReadMethod();
                Method setter = property.getWriteMethod();
                Object oldValue = getter.invoke(oldBean, new Object[0]);
                Object newValue = getter.invoke(newBean, new Object[0]);
                if (setter == null || newValue == null || newValue.equals(oldValue)) continue;
                setter.invoke(object, newValue);
            }
            return (T)object;
        }
        catch (Exception e) {
            throw new DataParseException(e);
        }
    }

    public static final Class<?> getClass(String clazz) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            if (loader != null) {
                return Class.forName(clazz, true, loader);
            }
            return Class.forName(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new InstanceException(e);
        }
    }

    public static final <E> List<E> getInstanceList(Class<E> cls, List<?> list) {
        ArrayList<Object> resultList = InstanceUtil.newArrayList();
        Object object = null;
        for (Object name : list) {
            Map map = (Map)name;
            object = InstanceUtil.newInstance(cls, new Object[]{map});
            resultList.add(object);
        }
        return resultList;
    }

    public static final <E> List<E> getInstanceList(Class<E> cls, ResultSet rs) {
        ArrayList<E> resultList = InstanceUtil.newArrayList();
        try {
            E object = cls.newInstance();
            Field[] fields = cls.getDeclaredFields();
            while (rs.next()) {
                object = cls.newInstance();
                for (Field field : fields) {
                    String fieldName = field.getName();
                    PropertyUtils.setProperty(object, (String)fieldName, (Object)rs.getObject(fieldName));
                }
                resultList.add(object);
            }
        }
        catch (Exception e) {
            throw new InstanceException(e);
        }
        return resultList;
    }

    public static final <E> E newInstance(Class<E> cls, Map<String, ?> map) {
        E object = null;
        try {
            object = cls.newInstance();
            BeanUtils.populate(object, map);
        }
        catch (Exception e) {
            throw new InstanceException(e);
        }
        return object;
    }

    public static final Object newInstance(String clazz) {
        try {
            return InstanceUtil.getClass(clazz).newInstance();
        }
        catch (Exception e) {
            throw new InstanceException(e);
        }
    }

    public static final <K> K newInstance(Class<K> cls, Object ... args) {
        try {
            Class[] argsClass = null;
            if (args != null) {
                argsClass = new Class[args.length];
                int j = args.length;
                for (int i = 0; i < j; ++i) {
                    argsClass[i] = args[i].getClass();
                }
            }
            Constructor<K> cons = cls.getConstructor(argsClass);
            return cons.newInstance(args);
        }
        catch (Exception e) {
            throw new InstanceException(e);
        }
    }

    public static final Object newInstance(String className, Object ... args) {
        try {
            Class<?> newoneClass = clazzMap.get(className);
            if (newoneClass == null) {
                newoneClass = Class.forName(className);
                clazzMap.put(className, newoneClass);
            }
            return InstanceUtil.newInstance(newoneClass, args);
        }
        catch (Exception e) {
            throw new InstanceException(e);
        }
    }

    public static final Object invokeMethod(Object owner, String methodName, Object ... args) {
        Class<?> ownerClass = owner.getClass();
        String key = null;
        if (args != null) {
            Object[] argsClass = new Class[args.length];
            int j = args.length;
            for (int i = 0; i < j; ++i) {
                if (args[i] == null) continue;
                argsClass[i] = args[i].getClass();
            }
            key = ownerClass + "_" + methodName + "_" + StringUtils.join((Object[])argsClass, (String)",");
        } else {
            key = ownerClass + "_" + methodName;
        }
        MethodAccess methodAccess = methodMap.get(key);
        if (methodAccess == null) {
            methodAccess = MethodAccess.get(ownerClass);
            methodMap.put(key, methodAccess);
        }
        return methodAccess.invoke(owner, methodName, args);
    }

    public static final <E> ArrayList<E> newArrayList() {
        return new ArrayList();
    }

    public static final <E> ArrayList<E> newArrayList(E ... e) {
        ArrayList<E> list = InstanceUtil.newArrayList();
        Collections.addAll(list, e);
        return list;
    }

    public static final <k, v> HashMap<k, v> newHashMap() {
        return new HashMap();
    }

    public static final <E> HashSet<E> newHashSet() {
        return new HashSet();
    }

    public static final <k, v> Hashtable<k, v> newHashtable() {
        return new Hashtable();
    }

    public static final <k, v> LinkedHashMap<k, v> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    public static final <E> LinkedHashSet<E> newLinkedHashSet() {
        return new LinkedHashSet();
    }

    public static final <E> LinkedList<E> newLinkedList() {
        return new LinkedList();
    }

    public static final <k, v> TreeMap<k, v> newTreeMap() {
        return new TreeMap();
    }

    public static final <E> TreeSet<E> newTreeSet() {
        return new TreeSet();
    }

    public static final <E> Vector<E> newVector() {
        return new Vector();
    }

    public static final <k, v> WeakHashMap<k, v> newWeakHashMap() {
        return new WeakHashMap();
    }

    public static final <k, v> HashMap<k, v> newHashMap(k key, v value) {
        HashMap<k, v> map = InstanceUtil.newHashMap();
        map.put(key, value);
        return map;
    }

    public static final <k, v> LinkedHashMap<k, v> newLinkedHashMap(k key, v value) {
        LinkedHashMap<k, v> map = InstanceUtil.newLinkedHashMap();
        map.put(key, value);
        return map;
    }

    public static final <k, v> ConcurrentHashMap<k, v> newConcurrentHashMap() {
        return new ConcurrentHashMap();
    }

    public static final <e> ConcurrentSkipListSet<e> newConcurrentSkipListSet() {
        return new ConcurrentSkipListSet();
    }

    public static <E> Set<E> newHashSet(E[] e) {
        HashSet<E> set = InstanceUtil.newHashSet();
        Collections.addAll(set, e);
        return set;
    }
}

