/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.devicev4;

import com.sansec.devicev4.CryptoVersion;
import com.sansec.devicev4.SwxaDeviceFactory;
import com.sansec.devicev4.api.CryptoException;
import com.sansec.devicev4.api.ISDSCrypto;
import com.sansec.devicev4.gb.struct.DeviceInfo;
import com.sansec.devicev4.gb.struct.key.IDSArefPublicKey;
import com.sansec.devicev4.gb.struct.key.IRSArefPublicKey;
import com.sansec.devicev4.gb.struct.key.dsa.DSArefKeyPair;
import com.sansec.devicev4.gb.struct.key.dsa.DSArefSignature;
import com.sansec.devicev4.gb.struct.key.ecdsa.ECDSArefKeyPair;
import com.sansec.devicev4.gb.struct.key.ecdsa.ECDSArefPublicKey;
import com.sansec.devicev4.gb.struct.key.ecdsa.ECDSArefSignature;
import com.sansec.devicev4.gb.struct.key.rsa.RSArefKeyPair;
import com.sansec.devicev4.gb.struct.key.sm2.SM2refCipher;
import com.sansec.devicev4.gb.struct.key.sm2.SM2refKeyPair;
import com.sansec.devicev4.gb.struct.key.sm2.SM2refPublicKey;
import com.sansec.devicev4.gb.struct.key.sm2.SM2refSignature;
import com.sansec.devicev4.util.BytesUtil;
import com.sansec.devicev4.util.PrintUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Random;

public class Main {
    static ISDSCrypto crypto = null;

    public Main() throws CryptoException {
        crypto = SwxaDeviceFactory.getInstance();
    }

    public Main(String deviceFactoryName) throws CryptoException {
        crypto = SwxaDeviceFactory.getInstance(deviceFactoryName);
    }

    public Main(String deviceFactoryName, String configFile) throws CryptoException {
        crypto = SwxaDeviceFactory.getInstance(deviceFactoryName, configFile);
    }

    private void getDeviceInfo_Test() {
        DeviceInfo pstDeviceInfo = null;
        try {
            pstDeviceInfo = crypto.getDeviceInfo();
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println(pstDeviceInfo.toString());
    }

    private void createRandom_Test() throws IOException {
        System.out.print("\u968f\u673a\u6570\u957f\u5ea6[\u5b57\u8282]\uff1a");
        String str = new BufferedReader(new InputStreamReader(System.in)).readLine();
        byte[] random = new byte[]{};
        try {
            random = crypto.generateRandom(Integer.parseInt(str));
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("-->Random:\n" + PrintUtil.toHexString(random));
    }

    private void getInternalRSAPubKey() throws IOException {
        System.out.print("\u5bc6\u94a5\u7d22\u5f15\uff1a");
        String str = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int index = Integer.parseInt(str);
        System.out.println("1-SignKey|2-EncKey:");
        String typeStr = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int type = Integer.parseInt(typeStr);
        IRSArefPublicKey publicKey = null;
        try {
            publicKey = crypto.getRSAPublicKey(index, type);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("-->Type[" + type + "]PublicKey:\n" + publicKey.toString());
    }

    private void creatExternalRSAKeyPair() throws IOException {
        System.out.print("\u5bc6\u94a5\u957f\u5ea6(bit)\uff1a");
        String str = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int keySize = Integer.parseInt(str);
        RSArefKeyPair keyPair = null;
        try {
            keyPair = crypto.generateRSAKeyPair(keySize);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("-->RSAKeyPair:\n" + keyPair.toString());
    }

    private void internalRSAEnc_Dec() throws IOException {
        System.out.print("\u5bc6\u94a5\u7d22\u5f15\uff1a");
        String str = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int index = Integer.parseInt(str);
        System.out.print("\u6570\u636e\u957f\u5ea6=bit/8\uff1a");
        str = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int dataLength = Integer.parseInt(str);
        byte[] inputData = new byte[dataLength];
        new Random().nextBytes(inputData);
        System.out.println("1-SignKey|2-EncKey:");
        String typeStr = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int type = Integer.parseInt(typeStr);
        System.out.println("Input:\n" + PrintUtil.toHexString(inputData));
        byte[] signOut = new byte[]{};
        try {
            signOut = crypto.rsaPublicKeyOperation(index, type, inputData);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("-->Type[" + type + "]_public_Out:\n" + PrintUtil.toHexString(signOut));
        byte[] verfyOut = null;
        try {
            verfyOut = crypto.rsaPrivateKeyOperation(index, type, signOut);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("-->Type[" + type + "]_private_Out:\n" + PrintUtil.toHexString(verfyOut));
    }

    private void internalRSASign_Verfiy() throws IOException {
        System.out.print("\u5bc6\u94a5\u7d22\u5f15\uff1a");
        String str = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int index = Integer.parseInt(str);
        System.out.print("\u6570\u636e\u957f\u5ea6=bit/8\uff1a");
        str = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int dataLength = Integer.parseInt(str);
        System.out.println("1-SignKey|2-EncKey:");
        String typeStr = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int type = Integer.parseInt(typeStr);
        byte[] inputData = new byte[dataLength];
        new Random().nextBytes(inputData);
        System.out.println("Input:\n" + PrintUtil.toHexString(inputData));
        byte[] signOut = null;
        try {
            signOut = crypto.rsaPrivateKeyOperation(index, type, inputData);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("-->Type[" + type + "]_private_Out:\n" + PrintUtil.toHexString(signOut));
        byte[] signVOut = null;
        try {
            signVOut = crypto.rsaPublicKeyOperation(index, type, signOut);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("-->Type[" + type + "]_public_Out:\n" + PrintUtil.toHexString(signVOut));
    }

    private void externalRSAEnc_Dec() throws IOException {
        System.out.print("\u5bc6\u94a5\u957f\u5ea6(bit)\uff1a");
        String str = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int keySize = Integer.parseInt(str);
        System.out.print("\u6570\u636e\u957f\u5ea6=bit/8\uff1a");
        str = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int dataLength = Integer.parseInt(str);
        RSArefKeyPair keyPair = null;
        try {
            keyPair = crypto.generateRSAKeyPair(keySize);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println(keyPair.toString());
        byte[] inputData = new byte[dataLength];
        new Random().nextBytes(inputData);
        System.out.println("Input:\n" + PrintUtil.toHexString(inputData));
        byte[] encOut = null;
        try {
            encOut = crypto.rsaPublicKeyOperation(keyPair.getPublicKey(), inputData);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("-->public_Out:\n" + PrintUtil.toHexString(encOut));
        byte[] decOut = null;
        try {
            decOut = crypto.rsaPrivateKeyOperation(keyPair.getPrivateKey(), encOut);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("-->private_Out:\n" + PrintUtil.toHexString(decOut));
    }

    private void externalRSASign_Verfiy() throws IOException {
        System.out.print("\u5bc6\u94a5\u957f\u5ea6(bit)\uff1a");
        String str = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int keySize = Integer.parseInt(str);
        System.out.print("\u6570\u636e\u957f\u5ea6=bit/8\uff1a");
        str = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int dataLength = Integer.parseInt(str);
        RSArefKeyPair keyPair = null;
        try {
            keyPair = crypto.generateRSAKeyPair(keySize);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println(keyPair.toString());
        byte[] inputData = new byte[dataLength];
        new Random().nextBytes(inputData);
        System.out.println("Input:\n" + PrintUtil.toHexString(inputData));
        byte[] signOut = new byte[]{};
        try {
            signOut = crypto.rsaPrivateKeyOperation(keyPair.getPrivateKey(), inputData);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("-->private_Out:\n" + PrintUtil.toHexString(signOut));
        byte[] verfiyOut = new byte[]{};
        try {
            verfiyOut = crypto.rsaPublicKeyOperation(keyPair.getPublicKey(), signOut);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("-->public_Out:\n" + PrintUtil.toHexString(verfiyOut));
    }

    private void getInternalSM2PubKey() throws IOException {
        System.out.print("\u5bc6\u94a5\u7d22\u5f15\uff1a");
        String str = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int index = Integer.parseInt(str);
        System.out.println("1-SignKey|2-EncKey:");
        String typeStr = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int type = Integer.parseInt(typeStr);
        SM2refPublicKey signPublicKey = null;
        try {
            signPublicKey = crypto.getSM2PublicKey(index, type);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("-->Type[" + type + "]_SM2refPublicKey:\n" + signPublicKey.toString());
    }

    private void creatExternalSM2KeyPair() throws IOException {
        System.out.print("\u5bc6\u94a5\u957f\u5ea6(bit)\uff1a");
        String str = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int keySize = Integer.parseInt(str);
        SM2refKeyPair keyPair = null;
        try {
            keyPair = crypto.generateSM2KeyPair(keySize);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("-->SM2refKeyPair:\n" + keyPair.toString());
    }

    private void internalSM2Enc_Dec() throws IOException {
        System.out.print("\u5bc6\u94a5\u7d22\u5f15\uff1a");
        String str = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int index = Integer.parseInt(str);
        System.out.print("\u6570\u636e\u957f\u5ea6<137\uff1a");
        str = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int dataLength = Integer.parseInt(str);
        byte[] inputData = new byte[dataLength];
        new Random().nextBytes(inputData);
        System.out.println("1-SignKey|2-EncKey:");
        String typeStr = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int type = Integer.parseInt(typeStr);
        System.out.println("Input:\n" + PrintUtil.toHexString(inputData));
        SM2refCipher signencOut = null;
        try {
            signencOut = crypto.sm2Encrypt(index, type, inputData);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("-->Type[" + type + "]_Key_SM2refCipher:\n" + signencOut.toString());
        byte[] signdecOut = new byte[]{};
        try {
            signdecOut = crypto.sm2Decrypt(index, type, signencOut);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("-->Type[" + type + "]_Key_out:\n" + PrintUtil.toHexString(signdecOut));
    }

    private void externalSM2Enc_Dec() throws IOException {
        int keySize = 256;
        System.out.print("\u6570\u636e\u957f\u5ea6<137\uff1a");
        String str = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int dataLength = Integer.parseInt(str);
        SM2refKeyPair keyPair = null;
        try {
            keyPair = crypto.generateSM2KeyPair(keySize);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println(keyPair.toString());
        byte[] inputData = new byte[dataLength];
        new Random().nextBytes(inputData);
        System.out.println("Input:\n" + PrintUtil.toHexString(inputData));
        SM2refCipher encOut = null;
        try {
            encOut = crypto.sm2Encrypt(keyPair.getPublicKey(), inputData);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("-->SM2refCipher:\n" + encOut.toString());
        byte[] decOut = new byte[]{};
        try {
            decOut = crypto.sm2Decrypt(keyPair.getPrivateKey(), encOut);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("-->decOut:\n" + PrintUtil.toHexString(decOut));
    }

    private void internalSM2Sign_Verfiy() throws IOException {
        System.out.print("\u5bc6\u94a5\u7d22\u5f15\uff1a");
        String str = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int index = Integer.parseInt(str);
        System.out.print("\u6570\u636e\u957f\u5ea6(32)\uff1a");
        str = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int dataLength = Integer.parseInt(str);
        byte[] inputData = new byte[dataLength];
        new Random().nextBytes(inputData);
        System.out.println("1-SignKey|2-EncKey:");
        String typeStr = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int type = Integer.parseInt(typeStr);
        System.out.println("Input:\n" + PrintUtil.toHexString(inputData));
        SM2refSignature signOut = null;
        try {
            signOut = crypto.sm2Sign(index, type, inputData);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("-->Type[" + type + "]_Key_SM2refSignature:\n" + signOut.toString());
        boolean flag = false;
        try {
            flag = crypto.sm2Verify(index, type, inputData, signOut);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("-->Type[" + type + "]_Key_flag:" + flag);
    }

    private void externalSM2Sign_Verfiy() throws IOException {
        int keySize = 256;
        System.out.print("\u6570\u636e\u957f\u5ea6(32)\uff1a");
        String str = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int dataLength = Integer.parseInt(str);
        SM2refKeyPair keyPair = null;
        try {
            keyPair = crypto.generateSM2KeyPair(keySize);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println(keyPair.toString());
        byte[] inputData = new byte[dataLength];
        new Random().nextBytes(inputData);
        SM2refSignature signOut = null;
        try {
            signOut = crypto.sm2Sign(keyPair.getPrivateKey(), inputData);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("-->SM2refSignature:\n" + signOut.toString());
        boolean flag = false;
        try {
            flag = crypto.sm2Verify(keyPair.getPublicKey(), inputData, signOut);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("-->flag:" + flag);
    }

    private void internalSysEnc_Dec() throws IOException {
        System.out.println("        ECB     CBC     CFB     OFB     MAC     CTR     GCM");
        System.out.println("SM1:    101     102     104     108     110     120        ");
        System.out.println("SSF33:  201     202     204     208     210     220        ");
        System.out.println("AES:    401     402     404     408     410     420     440");
        System.out.println("3DES:   801     802     804     808     810     820        ");
        System.out.println("SM4:    2001    2002                            2020       ");
        System.out.println("DES:    4001    4002    4004    4008    4010    4020       ");
        System.out.print("\u7b97\u6cd5\uff1a");
        String algstr = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int alg = Integer.parseInt(algstr, 16);
        System.out.print("\u5bc6\u94a5\u7d22\u5f15\uff1a");
        String str = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int index = Integer.parseInt(str);
        System.out.print("\u6570\u636e\u957f\u5ea6\uff1a");
        str = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int dataLength = Integer.parseInt(str);
        System.out.print("IV\u957f\u5ea6\uff1a");
        str = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int ivLength = Integer.parseInt(str);
        byte[] inputData = new byte[dataLength];
        new Random().nextBytes(inputData);
        System.out.println("inputData:\n" + PrintUtil.toHexString(inputData));
        byte[] iv = new byte[ivLength];
        new Random().nextBytes(iv);
        System.out.println("ivData:\n" + PrintUtil.toHexString(iv));
        byte[] encOut = null;
        try {
            encOut = crypto.encrypt(alg, index, iv, inputData);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("-->encOut:\n" + PrintUtil.toHexString(encOut));
        byte[] decOut = null;
        try {
            decOut = crypto.decrypt(alg, index, iv, encOut);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("-->decOut:\n" + PrintUtil.toHexString(decOut));
    }

    private void externalSysEnc_Dec() throws IOException {
        System.out.println("        ECB     CBC     CFB     OFB     MAC     CTR     GCM");
        System.out.println("SM1:    101     102     104     108     110     120        ");
        System.out.println("SSF33:  201     202     204     208     210     220        ");
        System.out.println("AES:    401     402     404     408     410     420     440");
        System.out.println("3DES:   801     802     804     808     810     820        ");
        System.out.println("SM4:    2001    2002                            2020       ");
        System.out.println("DES:    4001    4002    4004    4008    4010    4020       ");
        System.out.print("\u7b97\u6cd5\uff1a");
        String algstr = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int alg = Integer.parseInt(algstr, 16);
        System.out.print("\u5bc6\u94a5\u957f\u5ea6[\u5b57\u8282]\uff1a");
        String str = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int keyLength = Integer.parseInt(str);
        System.out.print("\u6570\u636e\u957f\u5ea6\uff1a");
        str = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int dataLength = Integer.parseInt(str);
        System.out.print("IV\u957f\u5ea6\uff1a");
        str = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int ivLength = Integer.parseInt(str);
        byte[] random = null;
        try {
            random = crypto.generateRandom(keyLength);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("Key:\n" + PrintUtil.toHexString(random));
        byte[] inputData = new byte[dataLength];
        new Random().nextBytes(inputData);
        System.out.println("inputData:\n" + PrintUtil.toHexString(inputData));
        byte[] iv = new byte[ivLength];
        new Random().nextBytes(iv);
        System.out.println("ivData:\n" + PrintUtil.toHexString(iv));
        byte[] encOut = null;
        try {
            encOut = crypto.encrypt(alg, random, iv, inputData);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("-->encOut:\n" + PrintUtil.toHexString(encOut));
        byte[] decOut = null;
        try {
            decOut = crypto.decrypt(alg, random, iv, encOut);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("-->decOut:\n" + PrintUtil.toHexString(decOut));
    }

    private void internalSysCheck() throws IOException {
        System.out.print("\u5bc6\u94a5\u7d22\u5f15\uff1a");
        String str = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int index = Integer.parseInt(str);
        System.out.print("\u6570\u636e\u957f\u5ea6\uff1a");
        str = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int dataLength = Integer.parseInt(str);
        System.out.print("IV\u957f\u5ea6\uff1a");
        str = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int ivLength = Integer.parseInt(str);
        byte[] inputData = new byte[dataLength];
        System.out.println("inputData:\n" + PrintUtil.toHexString(inputData));
        byte[] encOut = new byte[]{};
        try {
            encOut = crypto.encrypt(2049, index, new byte[ivLength], inputData);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("-->encOut:\n" + PrintUtil.toHexString(encOut));
    }

    private void getInternalDSAPubKey() throws IOException {
        System.out.print("\u5bc6\u94a5\u7d22\u5f15\uff1a");
        String str = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int index = Integer.parseInt(str);
        System.out.println("1-SignKey|2-EncKey:");
        String typeStr = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int type = Integer.parseInt(typeStr);
        IDSArefPublicKey publicKey = null;
        try {
            publicKey = crypto.getDSAPublicKey(index, type);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("-->Type[" + type + "]PublicKey:\n" + publicKey.toString());
    }

    private void creatExternalDSAKeyPair() throws IOException {
        System.out.print("\u5bc6\u94a5\u957f\u5ea6(bit)\uff1a");
        String str = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int keySize = Integer.parseInt(str);
        DSArefKeyPair keyPair = null;
        try {
            keyPair = crypto.generateDSAKeyPair(keySize);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("-->DSAKeyPair:\n" + keyPair.toString());
    }

    private void internalDSASign_Verfiy() throws IOException {
        System.out.print("\u5bc6\u94a5\u7d22\u5f15\uff1a");
        String str = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int index = Integer.parseInt(str);
        System.out.print("\u6570\u636e\u957f\u5ea6\uff1a");
        str = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int dataLength = Integer.parseInt(str);
        System.out.println("1-SignKey|2-EncKey:");
        String typeStr = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int type = Integer.parseInt(typeStr);
        byte[] inputData = new byte[dataLength];
        new Random().nextBytes(inputData);
        System.out.println("Input:\n" + PrintUtil.toHexString(inputData));
        DSArefSignature signOut = null;
        try {
            signOut = crypto.dsaSign(index, type, inputData);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("-->Type[" + type + "]_Key_DSArefSignature:\n" + signOut.toString());
        boolean flag = false;
        try {
            flag = crypto.dsaVerify(index, type, inputData, signOut);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("-->Type[" + type + "]_Key_flag:" + flag);
    }

    private void externalDSASign_Verfiy() throws IOException {
        System.out.print("\u5bc6\u94a5\u957f\u5ea6(bit)\uff1a");
        String str = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int keySize = Integer.parseInt(str);
        System.out.print("\u6570\u636e\u957f\u5ea6\uff1a");
        str = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int dataLength = Integer.parseInt(str);
        DSArefKeyPair keyPair = null;
        try {
            keyPair = crypto.generateDSAKeyPair(keySize);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println(keyPair.toString());
        byte[] inputData = new byte[dataLength];
        new Random().nextBytes(inputData);
        DSArefSignature signOut = null;
        try {
            signOut = crypto.dsaSign(keyPair.getPrivateKey(), inputData);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("-->DSArefSignature:\n" + signOut.toString());
        boolean flag = false;
        try {
            flag = crypto.dsaVerify(keyPair.getPublicKey(), inputData, signOut);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("-->flag:" + flag);
    }

    private void getInternalECDSAPubKey() throws IOException {
        System.out.print("\u5bc6\u94a5\u7d22\u5f15\uff1a");
        String str = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int index = Integer.parseInt(str);
        System.out.println("1-SignKey|2-EncKey:");
        String typeStr = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int type = Integer.parseInt(typeStr);
        ECDSArefPublicKey publicKey = null;
        try {
            publicKey = crypto.getECDSAPublicKey(index, type);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("-->Type[" + type + "]PublicKey:\n" + publicKey.toString());
    }

    private void creatExternalECDSAKeyPair() throws IOException {
        System.out.println("1: P-192 P-224 P-256 P-384 P-521");
        System.out.println("2: K-163 K-233 K-283 K-409 K-571");
        System.out.println("3: B-233 B-283 B-409 B-571 B-163");
        System.out.println("4: BrainPool-160r1 BrainPool-192r1 BrainPool-224r1 BrainPool-256r1 BrainPool-320r1 BrainPool-384r1 BrainPool-512r1");
        System.out.println("5: BrainPool-160t1 BrainPool-192t1 BrainPool-224t1 BrainPool-256t1 BrainPool-320t1 BrainPool-384t1 BrainPool-512t1");
        System.out.print("\u66f2\u7ebf(1|2|3|4|5)\uff1a");
        String str = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int curetype = Integer.parseInt(str);
        int cType = 0;
        switch (curetype) {
            case 1: {
                cType = 524289;
                break;
            }
            case 2: {
                cType = 524290;
                break;
            }
            case 3: {
                cType = 524291;
                break;
            }
            case 4: {
                cType = 524292;
                break;
            }
            case 5: {
                cType = 524293;
            }
        }
        System.out.print("\u5bc6\u94a5\u957f\u5ea6(bit)\uff1a");
        str = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int keySize = Integer.parseInt(str);
        ECDSArefKeyPair keyPair = null;
        try {
            keyPair = crypto.generateECDSAKeyPair(keySize, cType);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("-->ECDSAKeyPair:\n" + keyPair.toString());
    }

    private void internalECDSASign_Verfiy() throws IOException {
        System.out.print("\u5bc6\u94a5\u7d22\u5f15\uff1a");
        String str = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int index = Integer.parseInt(str);
        System.out.print("\u6570\u636e\u957f\u5ea6\uff1a");
        str = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int dataLength = Integer.parseInt(str);
        System.out.println("1-SignKey|2-EncKey:");
        String typeStr = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int type = Integer.parseInt(typeStr);
        byte[] inputData = new byte[dataLength];
        new Random().nextBytes(inputData);
        System.out.println("Input:\n" + PrintUtil.toHexString(inputData));
        ECDSArefSignature signOut = null;
        try {
            signOut = crypto.ecdsaSign(index, type, inputData);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("-->Type[" + type + "]_Key_ECDSArefSignature:\n" + signOut.toString());
        boolean flag = false;
        try {
            flag = crypto.ecdsaVerify(index, type, inputData, signOut);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("-->Type[" + type + "]_Key_flag:" + flag);
    }

    private void externalECDSASign_Verfiy() throws IOException {
        System.out.println("1: P-192 P-224 P-256 P-384 P-521");
        System.out.println("2: K-163 K-233 K-283 K-409 K-571");
        System.out.println("3: B-233 B-283 B-409 B-571 B-163");
        System.out.println("4: BrainPool-160r1 BrainPool-192r1 BrainPool-224r1 BrainPool-256r1 BrainPool-320r1 BrainPool-384r1 BrainPool-512r1");
        System.out.println("5: BrainPool-160t1 BrainPool-192t1 BrainPool-224t1 BrainPool-256t1 BrainPool-320t1 BrainPool-384t1 BrainPool-512t1");
        System.out.print("\u66f2\u7ebf(1|2|3|4|5)\uff1a");
        String str = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int curetype = Integer.parseInt(str);
        int cType = 0;
        switch (curetype) {
            case 1: {
                cType = 524289;
                break;
            }
            case 2: {
                cType = 524290;
                break;
            }
            case 3: {
                cType = 524291;
                break;
            }
            case 4: {
                cType = 524292;
                break;
            }
            case 5: {
                cType = 524293;
            }
        }
        System.out.print("\u5bc6\u94a5\u957f\u5ea6(bit)\uff1a");
        str = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int keySize = Integer.parseInt(str);
        ECDSArefKeyPair keyPair = null;
        try {
            keyPair = crypto.generateECDSAKeyPair(keySize, cType);
        }
        catch (CryptoException e) {
            e.printStackTrace();
        }
        System.out.print("\u6570\u636e\u957f\u5ea6\uff1a");
        str = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int dataLength = Integer.parseInt(str);
        byte[] inputData = new byte[dataLength];
        new Random().nextBytes(inputData);
        ECDSArefSignature signOut = null;
        try {
            signOut = crypto.ecdsaSign(keyPair.getPrivateKey(), inputData);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("-->ECDSArefSignature:\n" + signOut.toString());
        boolean flag = false;
        try {
            flag = crypto.ecdsaVerify(keyPair.getPublicKey(), inputData, signOut);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("-->flag:" + flag);
    }

    private int getHmcAlg() throws IOException {
        System.out.print("1:SM3 2:SHA1 3:SHA256 4:SHA512 5:SHA384 6:SHA224");
        System.out.print("\u7b97\u6cd5\uff1a");
        String algstr = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int alg = Integer.parseInt(algstr);
        int algT = 0;
        switch (alg) {
            case 1: {
                algT = 1;
                break;
            }
            case 2: {
                algT = 2;
                break;
            }
            case 3: {
                algT = 4;
                break;
            }
            case 4: {
                algT = 8;
                break;
            }
            case 5: {
                algT = 16;
                break;
            }
            case 6: {
                algT = 32;
            }
        }
        return algT;
    }

    private void internalHMAC() throws IOException {
        int algT = this.getHmcAlg();
        System.out.print("\u5bc6\u94a5\u7d22\u5f15\uff1a");
        String str = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int index = Integer.parseInt(str);
        System.out.print("\u6570\u636e\u957f\u5ea6\uff1a");
        str = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int dataLength = Integer.parseInt(str);
        byte[] inputData = new byte[dataLength];
        new Random().nextBytes(inputData);
        System.out.println("inputData:\n" + PrintUtil.toHexString(inputData));
        byte[] hmacOut = null;
        try {
            hmacOut = crypto.generateHMAC(algT, index, inputData);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("-->hmacOut:\n" + PrintUtil.toHexString(hmacOut));
    }

    private void externalHMAC() throws IOException {
        int algT = this.getHmcAlg();
        System.out.print("\u5bc6\u94a5\u957f\u5ea6[\u5b57\u8282]\uff1a");
        String str = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int keyLength = Integer.parseInt(str);
        System.out.print("\u6570\u636e\u957f\u5ea6\uff1a");
        str = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int dataLength = Integer.parseInt(str);
        byte[] inputData = new byte[dataLength];
        new Random().nextBytes(inputData);
        System.out.println("inputData:\n" + PrintUtil.toHexString(inputData));
        byte[] key = null;
        try {
            key = crypto.generateRandom(keyLength);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        byte[] hmacOut = null;
        try {
            hmacOut = crypto.generateHMAC(algT, key, inputData);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("-->hmacOut:\n" + PrintUtil.toHexString(hmacOut));
    }

    private void externalStandardHMAC() throws IOException {
        byte[] sha1Key = new byte[]{125, 29, -41, -117, -71, -127, -99, -97, -119, 41, -96, -33, 40, 112, -93, -104};
        byte[] sha224Key = new byte[]{-32, -4, -110, -3, 100, -86, 26, -13, 27, -10, 27, 126, 17, -109, 17, 123, -66, -32, 106, -17, 35, -79, 59, -18};
        byte[] sha256Key = new byte[]{113, -12, -122, -19, 16, -113, -115, -113, 72, -47, 78, -4, 53, -77, -22, -97, 34, -91, 36, 4, -3, 48, 111, -100};
        byte[] sha384Key = new byte[]{27, 53, 72, 92, -27, -15, 10, 120, -77, 94, 116, 97, -66, 40, -107, -64};
        byte[] sha512Key = new byte[]{18, 46, -126, -2, -48, 124, 64, 10, 24, -99, 52, 111, 107, 94, 2, 13, -73, 68, 48, 36, -50, 43, 56, 23};
        byte[] sha1Input = new byte[]{-35, -84, -79, -69, 2, -20, 28, 49, -70, -75, 45, -3, -109, -81, -8, -73, 90, -68, -29, -10, -42, -34, 0, 91, -74, 85, -102, -47, -57, 7, 14, 18, 106, 37, -36, 110, 70, 12, -2, -56, 58, 105, 121, -31, -107, -95, 49, -39, -118, 112, 1, -14, -34, -48, 11, -104, -28, 28, 77, -98, -85, 117, 118, -53, 118, 101, -9, -107, 108, -62, 92, 44, -111, -43, -35, -70, -11, -68, 48, -23, 44, 13, -94, -89, -3, -68, 102, 38, 94, 63, 45, 38, -95, -17, -9, 118, -24, -78, 40, -72, -34, -41, -34, 102, -87, 65, -126, 18, 26, -56, -99, -14, 39, -36, -19, -101, -100, 107, -71, 13, 13, 5, 97, -16, 15, 63, 57, 29};
        byte[] sha224Input = new byte[]{32, -88, -76, -46, 38, -48, -52, 30, -58, -95, -118, -107, -113, -5, -99, 58, 73, 25, -91, 59, 53, -61, -104, -55, -106, -59, 101, 38, 111, -95, -40, 0, -113, -127, -66, -3, -53, 111, 73, -105, -117, -56, -74, 42, -120, -18, 44, 75, -45, 62, -24, 92, 26, 66, -105, 93, 39, 39, 3, 5, -87, 113, -14, 18, 55, -19, 75, -35, -110, -25, 123, 49, 42, -98, 23, 93, -28, -11, -61, -120, 27, 107, 82, 69, -27, 77, 47, 104, -105, 43, -5, 23, -117, -120, 119, 36, 32, -43, -91, -102, 3, -95, 42, -107, -83, 10, -9, 87, 45, 119, 40, -103, 40, -119, 44, 31, 30, 78, 39, -113, -18, -72, -108, -125, -99, 78, 47, -35};
        byte[] sha256Input = new byte[]{-71, 82, -102, -69, -39, -82, -111, -12, 24, 114, 2, -86, 25, 71, 65, -12, 104, 21, -26, 24, 2, 118, 116, -96, 24, 106, 56, -80, 16, 76, 116, -106, -51, 4, -67, -93, 48, 127, -94, 57, -34, 92, -114, 38, 68, -24, -16, 48, -39, 77, -104, -15, -93, 6, 100, -26, -3, -106, 29, -62, -105, 122, -100, 8, -66, 92, 49, -40, -34, -119, 69, 9, 69, -91, 61, 121, 41, -98, -94, -95, -19, -34, 127, 109, -96, -59, 11, 74, -57, 86, -120, -128, 92, 48, 107, -62, 22, -64, -67, 3, -21, -74, -63, -116, -44, -75, -41, 76, -48, 79, -96, 111, 43, 48, 99, 50, 0, -103, -80, -11, -3, 17, 67, -111, 102, 87, 42, -19};
        byte[] sha384Input = new byte[]{116, 68, 110, 16, -6, 59, 43, 43, -19, -46, 80, 66, 91, -76, 104, 1, 75, -102, -37, 124, -107, -56, 104, -49, -9, -38, -49, 1, 100, -64, -50, 47, -97, 8, 79, -26, 9, 91, -32, -48, -72, 75, 99, -109, -56, 76, 7, -10, -10, -1, 119, 70, 106, -73, 81, -8, -43, 54, -39, -113, -68, -73, -17, -64, 20, 50, 62, -44, 14, -37, -73, 79, 52, -21, 62, -49, -75, -92, -94, 54, -3, -113, -45, 11, -119, 9, 79, 30, -6, -3, -34, 107, 104, -13, 127, 65, -8, 74, -94, -92, -79, -63, -105, -17, -117, 61, 71, -66, -55, -58, 34, 10, -119, -46, 88, -106, -102, -58, 76, -118, -115, -70, 70, 94, 15, 124, 103, -6};
        byte[] sha512Input = new byte[]{110, -13, -41, -128, 116, -4, -86, -127, 73, 54, 19, 67, 78, -115, 28, 57, 117, 59, -22, -121, -91, -102, 63, 114, 96, 54, 68, 21, -93, 39, -122, 86, 13, -98, 62, 25, 68, -67, -43, -76, -107, -84, -89, -94, -38, -23, 8, 123, -95, -33, -124, 35, -118, -69, 107, 66, -15, 123, -114, -11, -51, 71, 67, -60, -40, 5, -81, -45, -15, 40, 68, 92, -66, -56, -120, 92, -107, -8, 24, -115, -99, 84, -19, -107, 48, -39, -33, 125, -124, -6, 103, 100, -117, -17, -87, 117, 23, 81, -78, 22, 66, -28, -2, 98, 13, -76, 61, -38, 71, 99, 86, 87, -79, -63, -83, 68, 95, -99, -94, 9, 97, -37, 90, -54, -93, -57, -63, 82};
        byte[] sha1Mac = new byte[]{78, -36, -42, 10, 31, -95, -119, 98, -106, -36, -69, 87, 123, 58, -67, -92, 87, -95, 119, 110};
        byte[] sha224Mac = new byte[]{2, 78, 40, 59, -5, 35, -66, 101, 83, 114, 26, -91, 93, 74, -73, 1, -6, -92, -11, 75, -117, -56, 91, 111, 45, 117, -64, 47};
        byte[] sha256Mac = new byte[]{-44, 73, -100, 40, 112, 73, 64, 114, 82, -58, 74, 88, -116, -92, -17, -46, 111, -81, -26, 39, 8, -33, 79, 92, -68, 10, -83, -107, -117, 114, 92, 67};
        byte[] sha384Mac = new byte[]{-87, 110, 4, 60, 42, -115, 28, -64, -10, -20, -48, -85, -117, 56, 126, 35, -127, 13, -89, 35, -99, 62, 67, -41, -20, 27, 94, 116, -65, -36, 112, 4, -85, -120, -20, -12, 44, 74, -96, 99, -91, 32, 3, -47, -125, -88, -108, -110};
        byte[] sha512Mac = new byte[]{104, 22, 86, -67, -49, 92, -100, 63, -20, 44, -26, -16, -22, 92, 99, -99, -100, 122, 84, 19, 95, -116, -72, 104, -110, 6, 93, -71, 9, 36, 108, -25, 120, 112, 108, 46, -29, -42, 65, 8, 115, 97, 62, 123, -2, 58, -45, 5, -65, 47, -60, 27, -64, 36, 42, 21, 127, -80, 37, 50, 119, 68, -125, 74};
        try {
            byte[] hmacOut = null;
            boolean flag = false;
            hmacOut = crypto.generateHMAC(2, sha1Key, sha1Input);
            flag = BytesUtil.isEqual(sha1Mac, hmacOut);
            System.out.println("SHA1\u6bd4\u8f83:" + flag);
            hmacOut = crypto.generateHMAC(32, sha224Key, sha224Input);
            flag = BytesUtil.isEqual(sha224Mac, hmacOut);
            System.out.println("SHA224\u6bd4\u8f83:" + flag);
            hmacOut = crypto.generateHMAC(4, sha256Key, sha256Input);
            flag = BytesUtil.isEqual(sha256Mac, hmacOut);
            System.out.println("SHA256\u6bd4\u8f83:" + flag);
            hmacOut = crypto.generateHMAC(16, sha384Key, sha384Input);
            flag = BytesUtil.isEqual(sha384Mac, hmacOut);
            System.out.println("SHA384\u6bd4\u8f83:" + flag);
            hmacOut = crypto.generateHMAC(8, sha512Key, sha512Input);
            flag = BytesUtil.isEqual(sha512Mac, hmacOut);
            System.out.println("SHA512\u6bd4\u8f83:" + flag);
        }
        catch (CryptoException e) {
            e.printStackTrace();
        }
    }

    private void genPBKDF2Key() throws IOException {
        int algT = this.getHmcAlg();
        System.out.print("\u8fed\u4ee3\u6b21\u6570\uff1a");
        String str = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int iteraCount = Integer.parseInt(str);
        System.out.print("\u8f93\u51fa\u957f\u5ea6[\u5b57\u8282]\uff1a");
        str = new BufferedReader(new InputStreamReader(System.in)).readLine();
        int outLength = Integer.parseInt(str);
        System.out.print("\u53e3\u4ee4\uff1a");
        String pwd = new BufferedReader(new InputStreamReader(System.in)).readLine();
        System.out.print("\u76d0\uff1a");
        String salt = new BufferedReader(new InputStreamReader(System.in)).readLine();
        byte[] key = null;
        try {
            key = crypto.genPBKDF2Key(algT, iteraCount, outLength, pwd.toCharArray(), salt.getBytes());
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("-->PBKDF2Key:\n" + PrintUtil.toHexString(key));
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            StringBuffer text = new StringBuffer();
            text.append("[Version]\n");
            text.append(CryptoVersion.version);
            text.append("[\u8c03\u7528]\n");
            text.append("1.SwxaDeviceFactory.getInstance():\n");
            text.append("\t\u8c03\u7528\u9ed8\u8ba4\u7684com.sansec.devicev4.crypto_hsm.SDSCryptoFactory.\n");
            text.append("2.SwxaDeviceFactory.getInstance(String deviceFactoryName)\uff1a\n");
            text.append("\t\u4f20\u9012\u7c7b\u4f3c\u201ccom.sansec.devicev4.crypto_hsm.SDSCryptoFactory\u201d\u7684\u5168\u8def\u5f84\uff0c\u8c03\u7528\u7279\u5b9a\u7684\u52a0\u5bc6\u8bbe\u522b\u5de5\u5382\u83b7\u53d6\u52a0\u5bc6\u5bf9\u8c61.\n");
            text.append("3.SwxaDeviceFactory.getInstance(String deviceFactoryName, String userConfigFile)\uff1a\n");
            text.append("\t\u4f20\u9012\u7c7b\u4f3c\u201ccom.sansec.devicev4.crypto_hsm.SDSCryptoFactory\u201d\u7684\u5168\u8def\u5f84|Null|\"\",\u4ee5\u53ca\u914d\u7f6e\u6587\u4ef6\u7684\u8def\u5f84\uff0c\u8c03\u7528\u7279\u5b9a\u7684\u52a0\u5bc6\u8bbe\u522b\u5de5\u5382\u83b7\u53d6\u52a0\u5bc6\u5bf9\u8c61.Null|\"\"\u7684\u60c5\u51b5\u4e0b\u8c03\u7528\u9ed8\u8ba4\u7684\u5de5\u5382\u7c7b\u3002\n");
            System.out.println(text.toString());
        } else {
            Main instanseHSMTest = null;
            if (args.length == 1 && "sansec".equalsIgnoreCase(args[0])) {
                System.out.println("1\u4e2a\u53c2\u6570\uff1asansec");
                instanseHSMTest = new Main();
                Main.doTest(instanseHSMTest);
            } else if (args.length == 2 && "sansec".equalsIgnoreCase(args[0])) {
                if ("default".equalsIgnoreCase(args[1])) {
                    System.out.println("2\u4e2a\u53c2\u6570\uff1asansec default");
                    instanseHSMTest = new Main(null);
                } else {
                    System.out.println("2\u4e2a\u53c2\u6570\uff1asansec deviceFactoryName");
                    instanseHSMTest = new Main(args[1]);
                }
                Main.doTest(instanseHSMTest);
            } else if (args.length == 3 && "sansec".equalsIgnoreCase(args[0])) {
                if ("default".equalsIgnoreCase(args[1])) {
                    System.out.println("3\u4e2a\u53c2\u6570\uff1asansec default userConfigFile");
                    instanseHSMTest = new Main(null, args[2]);
                } else {
                    System.out.println("3\u4e2a\u53c2\u6570\uff1asansec deviceFactoryName userConfigFile");
                    instanseHSMTest = new Main(args[1], args[2]);
                }
                Main.doTest(instanseHSMTest);
            } else {
                System.out.println("Hello world!");
            }
        }
    }

    public static void doTest(Main instanseHSMTest) throws IOException {
        block31: while (true) {
            System.out.println("++++++++++++++++++++++++++++++++++Crypto\u529f\u80fd\u6d4b\u8bd5++++++++++++++++++++++++++++++++");
            System.out.println("1:\u83b7\u53d6\u8bbe\u5907\u4fe1\u606f\t2:\u4ea7\u751f\u968f\u673a\u6570");
            System.out.println("3:\u83b7\u53d6RSA\u5185\u90e8\u516c\u94a5  4\uff1a\u4ea7\u751f\u5916\u90e8RSA\u5bc6\u94a5\u5bf9  5:\u5185\u90e8RSA\u52a0\u5bc6\u89e3\u5bc6 6:\u5185\u90e8RSA\u7b7e\u540d\u9a8c\u7b7e  7:\u5916\u90e8RSA\u52a0\u5bc6\u89e3\u5bc6 8:\u5916\u90e8RSA\u7b7e\u540d\u9a8c\u7b7e ");
            System.out.println("9\uff1a\u83b7\u53d6SM2\u516c\u94a5     10:\u4ea7\u751f\u5916\u90e8SM2\u5bc6\u94a5\u5bf9 11:\u5185\u90e8SM2\u52a0\u5bc6\u89e3\u5bc6\t    12:\u5916\u90e8SM2\u52a0\u5bc6\u89e3\u5bc6  13:\u5185\u90e8SM2\u7b7e\u540d\u9a8c\u7b7e 14:\u5916\u90e8SM2\u7b7e\u540d\u9a8c\u7b7e");
            System.out.println("15:\u5185\u90e8\u5bf9\u79f0\u5bc6\u94a5\u52a0\u5bc6\u89e3\u5bc6   16:\u5916\u90e8\u5bf9\u79f0\u5bc6\u94a5\u52a0\u5bc6\u89e3\u5bc6    17:(\u91d1\u878d)\u5185\u90e8\u5bf9\u79f0\u5bc6\u94a5\u6821\u9a8c\u503c");
            System.out.println("18:\u83b7\u53d6DSA\u5185\u90e8\u516c\u94a5  19\uff1a\u4ea7\u751fDSA\u5916\u90e8\u5bc6\u94a5\u5bf9  20:\u5185\u90e8DSA\u7b7e\u540d\u9a8c\u7b7e  21:\u5916\u90e8DSA\u7b7e\u540d\u9a8c\u7b7e");
            System.out.println("22:\u83b7\u53d6ECDSA\u5185\u90e8\u516c\u94a5  23\uff1a\u4ea7\u751fECDSA\u5916\u90e8\u5bc6\u94a5\u5bf9  24:\u5185\u90e8ECDSA\u7b7e\u540d\u9a8c\u7b7e  25:\u5916\u90e8ECDSA\u7b7e\u540d\u9a8c\u7b7e");
            System.out.println("26:\u5185\u90e8\u5bc6\u94a5Hmac  27:\u5916\u90e8\u5bc6\u94a5Hmac 28:\u5916\u90e8\u5bc6\u94a5Hmac[\u6807\u51c6\u6570\u636e]");
            System.out.println("29:PBKDF2");
            System.out.println("+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
            System.out.print("\u9009\u62e9\u6d4b\u8bd5\uff1a");
            String str = new BufferedReader(new InputStreamReader(System.in)).readLine();
            int choice = Integer.parseInt(str);
            switch (choice) {
                case 1: {
                    instanseHSMTest.getDeviceInfo_Test();
                    continue block31;
                }
                case 2: {
                    instanseHSMTest.createRandom_Test();
                    continue block31;
                }
                case 3: {
                    instanseHSMTest.getInternalRSAPubKey();
                    continue block31;
                }
                case 4: {
                    instanseHSMTest.creatExternalRSAKeyPair();
                    continue block31;
                }
                case 5: {
                    instanseHSMTest.internalRSAEnc_Dec();
                    continue block31;
                }
                case 6: {
                    instanseHSMTest.internalRSASign_Verfiy();
                    continue block31;
                }
                case 7: {
                    instanseHSMTest.externalRSAEnc_Dec();
                    continue block31;
                }
                case 8: {
                    instanseHSMTest.externalRSASign_Verfiy();
                    continue block31;
                }
                case 9: {
                    instanseHSMTest.getInternalSM2PubKey();
                    continue block31;
                }
                case 10: {
                    instanseHSMTest.creatExternalSM2KeyPair();
                    continue block31;
                }
                case 11: {
                    instanseHSMTest.internalSM2Enc_Dec();
                    continue block31;
                }
                case 12: {
                    instanseHSMTest.externalSM2Enc_Dec();
                    continue block31;
                }
                case 13: {
                    instanseHSMTest.internalSM2Sign_Verfiy();
                    continue block31;
                }
                case 14: {
                    instanseHSMTest.externalSM2Sign_Verfiy();
                    continue block31;
                }
                case 15: {
                    instanseHSMTest.internalSysEnc_Dec();
                    continue block31;
                }
                case 16: {
                    instanseHSMTest.externalSysEnc_Dec();
                    continue block31;
                }
                case 17: {
                    instanseHSMTest.internalSysCheck();
                    continue block31;
                }
                case 18: {
                    instanseHSMTest.getInternalDSAPubKey();
                    continue block31;
                }
                case 19: {
                    instanseHSMTest.creatExternalDSAKeyPair();
                    continue block31;
                }
                case 20: {
                    instanseHSMTest.internalDSASign_Verfiy();
                    continue block31;
                }
                case 21: {
                    instanseHSMTest.externalDSASign_Verfiy();
                    continue block31;
                }
                case 22: {
                    instanseHSMTest.getInternalECDSAPubKey();
                    continue block31;
                }
                case 23: {
                    instanseHSMTest.creatExternalECDSAKeyPair();
                    continue block31;
                }
                case 24: {
                    instanseHSMTest.internalECDSASign_Verfiy();
                    continue block31;
                }
                case 25: {
                    instanseHSMTest.externalECDSASign_Verfiy();
                    continue block31;
                }
                case 26: {
                    instanseHSMTest.internalHMAC();
                    continue block31;
                }
                case 27: {
                    instanseHSMTest.externalHMAC();
                    continue block31;
                }
                case 28: {
                    instanseHSMTest.externalStandardHMAC();
                }
                case 29: {
                    instanseHSMTest.genPBKDF2Key();
                    continue block31;
                }
            }
            break;
        }
    }
}

