/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.devicev4.crypto_hsm;

import com.sansec.devicev4.CryptoVersion;
import com.sansec.devicev4.api.CryptoException;
import com.sansec.devicev4.api.ISDSCrypto;
import com.sansec.devicev4.api.ISDSCryptoFactory;
import com.sansec.devicev4.crypto_hsm.config.ConfigFile;
import com.sansec.devicev4.crypto_hsm.config.ConfigFileException;
import com.sansec.devicev4.crypto_hsm.sds.CMDCrypto;
import com.sansec.devicev4.crypto_hsm.sds.LIBCrypto;
import com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket.HSMPool;
import com.sansec.devicev4.log.CryptoLogger;
import java.util.logging.Logger;

public class SDSCryptoFactory
implements ISDSCryptoFactory {
    private Logger logger = CryptoLogger.logger;
    private static ISDSCrypto instance = null;
    private static ConfigFile configFile = null;

    private static String getVersion() {
        return CryptoVersion.version;
    }

    @Override
    public ISDSCrypto getInstance() throws CryptoException {
        return this.getInstance(null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ISDSCrypto getInstance(String loginPass, String keyStorePass, String trustStorePass) throws CryptoException {
        if (instance != null) return instance;
        Class<SDSCryptoFactory> clazz = SDSCryptoFactory.class;
        synchronized (SDSCryptoFactory.class) {
            this.logger.severe(SDSCryptoFactory.getVersion());
            if (instance != null) return instance;
            String path = ConfigFile.findCoinfigFilePath();
            if (path == null) {
                this.logger.severe("swsds.ini cannot find in default path(Jar):" + path);
                throw new CryptoException("swsds.ini cannot find in default path(Jar):" + path);
            }
            this.logger.severe("swsds.ini default path=" + path);
            instance = this.newInstance(path, loginPass, keyStorePass, trustStorePass);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public ISDSCrypto getInstance(String userConfigFile) throws CryptoException {
        return this.getInstance(userConfigFile, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ISDSCrypto getInstance(String userConfigFile, String loginPass, String keyStorePass, String trustStorePass) throws CryptoException {
        if (instance != null) return instance;
        Class<SDSCryptoFactory> clazz = SDSCryptoFactory.class;
        synchronized (SDSCryptoFactory.class) {
            if (instance != null) return instance;
            this.logger.severe(SDSCryptoFactory.getVersion());
            String path = userConfigFile;
            if (path == null) {
                this.logger.severe("swsds.ini can not be null");
                throw new CryptoException("swsds.ini can not be null");
            }
            this.logger.severe("swsds.ini path=" + path);
            instance = this.newInstance(path, loginPass, keyStorePass, trustStorePass);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return instance;
        }
    }

    public static void releaseInstance() {
        ConfigFile.releaseInstance();
        HSMPool.release();
        instance = null;
    }

    private ISDSCrypto newInstance(String path, String loginPass, String keyStorePass, String trustStorePass) throws CryptoException {
        ISDSCrypto instance = null;
        configFile = ConfigFile.getInstance();
        try {
            configFile.loadConfig(path);
        }
        catch (ConfigFileException ex) {
            this.logger.severe(path + ex.getMessage());
            throw new CryptoException(ex.getMessage());
        }
        try {
            switch (configFile.getDeviceType()) {
                case 1: {
                    HSMPool pool = HSMPool.getPool();
                    pool.initialize(configFile, loginPass, keyStorePass, trustStorePass);
                    instance = new CMDCrypto();
                    break;
                }
                case 2: {
                    instance = new LIBCrypto(configFile.getDeviceType());
                    break;
                }
                default: {
                    throw new CryptoException("Illegal Device Type.");
                }
            }
        }
        catch (Exception ex) {
            SDSCryptoFactory.releaseInstance();
            this.logger.severe("Device initialization failed:" + ex.toString());
            ex.printStackTrace();
            throw new CryptoException("Device initialization failed:" + ex.getMessage());
        }
        return instance;
    }
}

