/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.devicev4.crypto_hsm.config;

import com.sansec.devicev4.crypto_hsm.config.ConfigConst;
import com.sansec.devicev4.crypto_hsm.config.ConfigFileException;
import com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket.HSMPool;
import com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket.bean.HSMInfo;
import com.sansec.devicev4.log.CryptoLogger;
import com.sansec.devicev4.log.LogFormatter;
import com.sansec.devicev4.util.JarUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Logger;

public class ConfigFile {
    private Logger logger = CryptoLogger.logger;
    private static boolean watchFlag = false;
    private String configPath = null;
    private List<HSMInfo> server = new ArrayList<HSMInfo>();
    private int deviceType = 1;
    private int iLogLevel = 1;
    private int connectTimeout = 0;
    private int serviceTimeout = 0;
    private int poolsize = 0;
    private int cardType = 1;
    private String swLibFile = null;
    private String jniLibFile = null;
    private boolean ssl = false;
    private boolean sslLog = false;
    private String protocol = null;
    private String keyStore = null;
    private String keyStorePassword = null;
    private String keyStoreType = null;
    private String trustKeyStore = null;
    private String trustKeyStorePassword = null;
    private String trustKeyStoreType = null;
    private String includeCipherSuiteFilter = null;
    private String excludeCipherSuiteFilter = null;
    private static ConfigFile configFile = null;

    private ConfigFile() {
    }

    public static synchronized ConfigFile getInstance() {
        if (configFile == null) {
            configFile = new ConfigFile();
        }
        return configFile;
    }

    public static void releaseInstance() {
        configFile = null;
    }

    public int getDeviceType() {
        return this.deviceType;
    }

    public List<HSMInfo> getServer() {
        return this.server;
    }

    public int getiLogLevel() {
        return this.iLogLevel;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getServiceTimeout() {
        return this.serviceTimeout;
    }

    public int getPoolsize() {
        return this.poolsize;
    }

    public int getCardType() {
        return this.cardType;
    }

    public void setCardType(int cardType) {
        this.cardType = cardType;
    }

    public String getSwLibFile() {
        return this.swLibFile;
    }

    public void setSwLibFile(String swLibFile) {
        this.swLibFile = swLibFile;
    }

    public String getJniLibFile() {
        return this.jniLibFile;
    }

    public void setJniLibFile(String jniLibFile) {
        this.jniLibFile = jniLibFile;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public boolean isSslLog() {
        return this.sslLog;
    }

    public void setSslLog(boolean sslLog) {
        this.sslLog = sslLog;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(String keyStore) {
        this.keyStore = keyStore;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public String getTrustKeyStore() {
        return this.trustKeyStore;
    }

    public void setTrustKeyStore(String trustKeyStore) {
        this.trustKeyStore = trustKeyStore;
    }

    public String getTrustKeyStorePassword() {
        return this.trustKeyStorePassword;
    }

    public void setTrustKeyStorePassword(String trustKeyStorePassword) {
        this.trustKeyStorePassword = trustKeyStorePassword;
    }

    public String getTrustKeyStoreType() {
        return this.trustKeyStoreType;
    }

    public void setTrustKeyStoreType(String trustKeyStoreType) {
        this.trustKeyStoreType = trustKeyStoreType;
    }

    public String getIncludeCipherSuiteFilter() {
        return this.includeCipherSuiteFilter;
    }

    public void setIncludeCipherSuiteFilter(String includeCipherSuiteFilter) {
        this.includeCipherSuiteFilter = includeCipherSuiteFilter;
    }

    public String getExcludeCipherSuiteFilter() {
        return this.excludeCipherSuiteFilter;
    }

    public void setExcludeCipherSuiteFilter(String excludeCipherSuiteFilter) {
        this.excludeCipherSuiteFilter = excludeCipherSuiteFilter;
    }

    public static String findCoinfigFilePath() {
        String path = null;
        JarUtil util = new JarUtil(JarUtil.class);
        path = util.getJarPath() + File.separatorChar + "swsds.ini";
        if (new File(path).exists()) {
            return path;
        }
        return path;
    }

    public void loadConfig(String filePath) throws ConfigFileException {
        this.configPath = filePath;
        this.initLogger(filePath);
        String value = this.getValue(filePath, "Device", "device");
        if (value == null || value.trim().length() == 0) {
            value = "CMD";
            this.logger.severe("Get <device> value error,use DEFAULT_DEV_NAME:CMD");
        }
        if ("CMD".equalsIgnoreCase(value)) {
            this.deviceType = 1;
        } else if ("LIB".equalsIgnoreCase(value)) {
            this.deviceType = 2;
        } else if ("SOF".equalsIgnoreCase(value)) {
            this.deviceType = 0;
        } else {
            this.logger.severe("[Device] : device = " + value + " not support");
            throw new ConfigFileException("[Device] : device = " + value + " not support");
        }
        this.logger.info("[Device] : device = " + value);
        switch (this.deviceType) {
            case 1: {
                this.loadHSMConfig();
                break;
            }
        }
        new MyFileWatchDog(filePath).start();
    }

    private void loadHSMConfig() throws ConfigFileException {
        this.logger.info("-> ConfigFile.loadHSMConfig()...");
        for (int i = 1; i <= 10; ++i) {
            HSMInfo info = this.getHsmInfo(i);
            if (info == null) continue;
            this.server.add(info);
        }
        String value = this.getValue(this.configPath, "Timeout", "connect");
        if (value == null) {
            this.connectTimeout = 10;
            this.logger.severe("Get <connect> value error,use DEFAULT_CONNECT_TIMEOUT:10");
        } else {
            try {
                this.connectTimeout = Integer.parseInt(value);
            }
            catch (Exception e) {
                this.logger.severe("[Timeout] : <connect> isn't number");
                throw new ConfigFileException("[Timeout] : <connect> isn't number");
            }
        }
        this.logger.fine("[Timeout] : connect = " + this.connectTimeout);
        value = this.getValue(this.configPath, "Timeout", "service");
        if (value == null) {
            this.serviceTimeout = 30;
            this.logger.severe("Get <service> value error,use DEFAULT_SERVICE_TIMEOUT:30");
        } else {
            try {
                this.serviceTimeout = Integer.parseInt(value);
            }
            catch (Exception e) {
                this.logger.severe("[Timeout] : <service> isn't number");
                throw new ConfigFileException("[Timeout] : <service> isn't number");
            }
        }
        this.logger.fine("[Timeout] : service = " + this.connectTimeout);
        value = this.getValue(this.configPath, "ConnectionPool", "poolsize");
        if (value == null) {
            this.poolsize = 10;
            this.logger.severe("Get <poolsize> value error,use DEFAULT_CONNECT_POOLSIZE:10");
        } else {
            try {
                this.poolsize = Integer.parseInt(value);
            }
            catch (Exception e) {
                this.logger.severe("[ConnectionPool] : poolsize isn't number");
                throw new ConfigFileException("[ConnectionPool] : poolsize isn't number");
            }
        }
        this.logger.fine("[ConnectionPool] : poolsize = " + this.poolsize);
        value = this.getValue(this.configPath, "SSL", "ssl");
        if (value == null || value.trim().length() == 0) {
            value = "false";
        }
        try {
            this.ssl = value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("on") || value.equalsIgnoreCase("true") || value.equalsIgnoreCase("1");
        }
        catch (Exception e) {
            this.logger.severe("[SSL] : ssl isn't boolean");
            throw new ConfigFileException("[SSL] : ssl isn't boolean");
        }
        this.logger.fine("[SSL] : ssl = " + this.ssl);
        if (this.ssl) {
            value = this.getValue(this.configPath, "SSL", "ssllog");
            if (value == null || value.trim().length() == 0) {
                value = "false";
            }
            try {
                this.sslLog = value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("on") || value.equalsIgnoreCase("true") || value.equalsIgnoreCase("1");
            }
            catch (Exception e) {
                this.sslLog = false;
                this.logger.severe("[SSL] : sslLog isn't boolean,,use DEFAULT_SSL_LOG:false");
            }
            this.logger.fine("[SSL] : ssllog = " + this.sslLog);
            if (this.sslLog) {
                System.setProperty("javax.net.debug", "ssl,handshake,trustmanager");
            }
            if ((value = this.getValue(this.configPath, "SSL", "protocol")) == null || value.trim().length() == 0) {
                value = "TLSV1.2";
            }
            this.protocol = value;
            this.logger.fine("[SSL] : protocol = " + this.protocol);
            value = this.getValue(this.configPath, "SSL", "keystore");
            if (value == null || value.trim().length() == 0) {
                value = "";
            }
            if (value.contains("$")) {
                value = CryptoLogger.getEnvPath(value, this.configPath);
            }
            this.keyStore = value;
            this.logger.fine("[SSL] : keystore = " + this.keyStore);
            value = this.getValue(this.configPath, "SSL", "keystorepassword");
            if (value == null || value.trim().length() == 0) {
                value = "11111111";
            }
            this.keyStorePassword = value;
            value = this.getValue(this.configPath, "SSL", "keystoretype");
            if (value == null || value.trim().length() == 0) {
                value = "JKS";
            }
            this.keyStoreType = value;
            this.logger.fine("[SSL] : keystoretype = " + this.keyStoreType);
            value = this.getValue(this.configPath, "SSL", "trustkeystore");
            if (value == null || value.trim().length() == 0) {
                value = "";
            }
            if (value.contains("$")) {
                value = CryptoLogger.getEnvPath(value, this.configPath);
            }
            this.trustKeyStore = value;
            this.logger.fine("[SSL] : trustkeystore = " + this.trustKeyStore);
            value = this.getValue(this.configPath, "SSL", "trustkeystorepassword");
            if (value == null || value.trim().length() == 0) {
                value = "11111111";
            }
            this.trustKeyStorePassword = value;
            value = this.getValue(this.configPath, "SSL", "trustkeystoretype");
            if (value == null || value.trim().length() == 0) {
                value = "JKS";
            }
            this.trustKeyStoreType = value;
            this.logger.fine("[SSL] : trustkeystoretype = " + this.trustKeyStoreType);
            value = this.getValue(this.configPath, "SSL", "includeciphersuitefilter");
            if (value == null || value.trim().length() == 0) {
                value = "";
            }
            this.includeCipherSuiteFilter = value;
            this.includeCipherSuiteFilter = this.includeCipherSuiteFilter.replaceAll("\\*", "\\\\w*");
            this.logger.fine("[SSL] : includeciphersuitefilter = " + this.includeCipherSuiteFilter);
            value = this.getValue(this.configPath, "SSL", "excludeciphersuitefilter");
            if (value == null || value.trim().length() == 0) {
                value = "";
            }
            this.excludeCipherSuiteFilter = value;
            this.excludeCipherSuiteFilter = this.excludeCipherSuiteFilter.replaceAll("\\*", "\\\\w*");
            this.logger.fine("[SSL] : excludeciphersuitefilter = " + this.excludeCipherSuiteFilter);
        }
        this.logger.info("-> ConfigFile.loadHSMConfig() end");
    }

    private String getValue(String filePath, String item, String key) {
        String str = null;
        item = "[" + item + "]";
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(filePath)));
            boolean findItem = false;
            while ((line = br.readLine()) != null) {
                if (line.trim().equals("") || line.charAt(0) == '#') continue;
                String tmpLine = line.toLowerCase();
                if (tmpLine.contains(item.toLowerCase())) {
                    findItem = true;
                    continue;
                }
                if (findItem && tmpLine.contains(key.toLowerCase())) {
                    str = line.substring(line.indexOf("=") + 1);
                    str = str.trim();
                    break;
                }
                if (!findItem || !tmpLine.contains("[")) continue;
                break;
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
        return str;
    }

    private void initLogger(String filePath) {
        File logFile;
        File logParentFile;
        Handler[] handlers;
        this.logger.info("-> ConfigFile.initLogger()...");
        for (Handler handler : handlers = this.logger.getHandlers()) {
            if (handler instanceof FileHandler) {
                handler.close();
            }
            this.logger.removeHandler(handler);
        }
        this.logger.setUseParentHandlers(false);
        String logLevel = this.getValue(filePath, "ErrorLog", "level");
        int iLogLevel = 0;
        if (logLevel == null) {
            iLogLevel = 1;
        } else {
            try {
                iLogLevel = Integer.parseInt(logLevel);
            }
            catch (Exception e) {
                e.printStackTrace();
                iLogLevel = 1;
            }
        }
        this.iLogLevel = iLogLevel;
        String logsize = this.getValue(filePath, "ErrorLog", "maxsize");
        int iLogSize = 0;
        if (logsize == null) {
            iLogSize = 100;
        } else {
            try {
                iLogSize = Integer.parseInt(logsize);
            }
            catch (Exception e) {
                e.printStackTrace();
                iLogSize = 100;
            }
        }
        String logcount = this.getValue(filePath, "ErrorLog", "count");
        int iLogCount = 0;
        if (logcount == null) {
            iLogCount = 10;
        } else {
            try {
                iLogCount = Integer.parseInt(logcount);
            }
            catch (Exception e) {
                e.printStackTrace();
                iLogCount = 10;
            }
        }
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setLevel(CryptoLogger.toLevel(iLogLevel));
        consoleHandler.setFormatter(new LogFormatter());
        this.logger.addHandler(consoleHandler);
        String logPath = this.getValue(filePath, "ErrorLog", "logfile");
        if (logPath == null) {
            logPath = CryptoLogger.getParentPath(filePath) + ConfigConst.DEFAULT_LOG_PATH;
        }
        if (!CryptoLogger.isFullPath(logPath)) {
            logPath = logPath.contains("$") ? CryptoLogger.getEnvPath(logPath, filePath) : CryptoLogger.getParentPath(filePath) + File.separatorChar + logPath;
        }
        if ((logParentFile = (logFile = new File(logPath)).getParentFile()).isFile() || !logParentFile.exists()) {
            logParentFile.mkdirs();
        }
        FileHandler fileHandler = null;
        try {
            fileHandler = new FileHandler(logPath, iLogSize * 1024 * 1024, iLogCount, true);
        }
        catch (Exception e) {
            this.logger.severe("swsds.ini path is " + filePath);
            e.printStackTrace();
            return;
        }
        fileHandler.setLevel(CryptoLogger.toLevel(iLogLevel));
        fileHandler.setFormatter(new LogFormatter());
        this.logger.addHandler(fileHandler);
        this.logger.setLevel(CryptoLogger.toLevel(iLogLevel));
        this.logger.fine("Configfile(swsds.ini) path = " + filePath);
        this.logger.fine("[ErrorLog] : log = " + logPath);
        this.logger.fine("[ErrorLog] : level = " + CryptoLogger.toLevel(iLogLevel));
        this.logger.info("-> ConfigFile.initLogger() end");
    }

    private HSMInfo getHsmInfo(int index) throws ConfigFileException {
        String item = "HSM" + index;
        String ip = this.getValue(this.configPath, item, "ip");
        if (ip == null) {
            return null;
        }
        this.logger.fine("[" + item + "] : ip = " + ip);
        String passwd = this.getValue(this.configPath, item, "passwd");
        if (passwd == null) {
            // empty if block
        }
        int port = 8008;
        String value = this.getValue(this.configPath, item, "port");
        if (value == null) {
            this.logger.severe("[" + item + "] :Get <port> value error,use DEFAULT_CONN_PORT:" + 8008);
        } else {
            try {
                port = Integer.parseInt(value);
            }
            catch (Exception e) {
                this.logger.severe("[" + item + "] : port isn't number");
                throw new ConfigFileException("[" + item + "] : port isn't number");
            }
        }
        this.logger.fine("[" + item + "] : port = " + port);
        HSMInfo info = new HSMInfo(ip, port, passwd);
        this.logger.info("[" + item + "] : load success,continue.");
        return info;
    }

    private void doOnChanges() {
        String logLevel = this.getValue(this.configPath, "ErrorLog", "level");
        int iLogLevel = 0;
        if (logLevel == null) {
            iLogLevel = 1;
        } else {
            try {
                iLogLevel = Integer.parseInt(logLevel);
            }
            catch (Exception e) {
                this.logger.severe("logLevel is not digit.");
                iLogLevel = 1;
            }
        }
        if (this.iLogLevel != iLogLevel) {
            Handler[] handlers;
            this.iLogLevel = iLogLevel;
            for (Handler handler : handlers = this.logger.getHandlers()) {
                handler.setLevel(CryptoLogger.toLevel(this.iLogLevel));
                this.logger.info("change logLevel to:" + this.iLogLevel);
            }
        }
        for (int i = 1; i <= 10; ++i) {
            HSMInfo info = null;
            try {
                info = this.getHsmInfo(i);
            }
            catch (ConfigFileException e) {
                e.printStackTrace();
                continue;
            }
            if (info == null) continue;
            if (this.alreadyExist(info)) {
                this.logger.fine(info.getIp() + " alreay in list");
                continue;
            }
            int maxIndex = this.server.size();
            this.server.add(info);
            HSMPool pool = HSMPool.getPool();
            if (pool == null) {
                this.logger.severe("HSM pool is not initialized");
                return;
            }
            this.logger.fine(info.getIp() + " add to list");
            pool.addHsm(configFile, maxIndex);
        }
    }

    private boolean alreadyExist(HSMInfo info) {
        for (HSMInfo tmp : this.server) {
            if (!tmp.getIp().equals(info.getIp())) continue;
            return true;
        }
        return false;
    }

    private class MyFileWatchDog
    extends Thread {
        public static final long DEFAULT_DELAY = 60000L;
        protected String filename;
        protected long delay = 60000L;
        File file;
        long lastModif = 0L;
        boolean warnedAlready = false;
        boolean interrupted = false;

        protected MyFileWatchDog(String filename) {
            this.filename = filename;
            this.file = new File(filename);
            this.lastModif = this.file.lastModified();
            this.setDaemon(true);
            this.checkAndConfigure();
        }

        protected void doOnChange() {
            ConfigFile.this.doOnChanges();
        }

        public void setDelay(long delay) {
            this.delay = delay;
        }

        protected void checkAndConfigure() {
            boolean fileExists;
            try {
                fileExists = this.file.exists();
            }
            catch (SecurityException e) {
                ConfigFile.this.logger.severe("Was not allowed to read check file existance, file:[" + this.filename + "].");
                this.interrupted = true;
                return;
            }
            if (fileExists) {
                long l = this.file.lastModified();
                if (l > this.lastModif) {
                    this.lastModif = l;
                    this.doOnChange();
                    this.warnedAlready = false;
                }
            } else if (!this.warnedAlready) {
                ConfigFile.this.logger.info("[" + this.filename + "] does not exist.");
                this.warnedAlready = true;
            }
        }

        @Override
        public void run() {
            if (watchFlag) {
                return;
            }
            watchFlag = true;
            while (!this.interrupted) {
                try {
                    Thread.sleep(this.delay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.checkAndConfigure();
            }
        }
    }
}

