/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.devicev4.crypto_hsm.sds;

import com.sansec.devicev4.api.CryptoException;
import com.sansec.devicev4.api.ISDSCrypto;
import com.sansec.devicev4.crypto_hsm.sds.lib.jna.SDFInterface;
import com.sansec.devicev4.gb.GBErrorCode_SDR;
import com.sansec.devicev4.gb.struct.DeviceInfo;
import com.sansec.devicev4.gb.struct.DeviceRunStatus;
import com.sansec.devicev4.gb.struct.key.IDSArefPrivateKey;
import com.sansec.devicev4.gb.struct.key.IDSArefPublicKey;
import com.sansec.devicev4.gb.struct.key.IRSArefPrivateKey;
import com.sansec.devicev4.gb.struct.key.IRSArefPublicKey;
import com.sansec.devicev4.gb.struct.key.dsa.DSArefKeyPair;
import com.sansec.devicev4.gb.struct.key.dsa.DSArefSignature;
import com.sansec.devicev4.gb.struct.key.ecdsa.ECDSArefKeyPair;
import com.sansec.devicev4.gb.struct.key.ecdsa.ECDSArefPrivateKey;
import com.sansec.devicev4.gb.struct.key.ecdsa.ECDSArefPublicKey;
import com.sansec.devicev4.gb.struct.key.ecdsa.ECDSArefSignature;
import com.sansec.devicev4.gb.struct.key.rsa.RSArefKeyPair;
import com.sansec.devicev4.gb.struct.key.rsa.RSArefPrivateKeyEx;
import com.sansec.devicev4.gb.struct.key.rsa.RSArefPrivateKeyLite;
import com.sansec.devicev4.gb.struct.key.rsa.RSArefPublicKeyEx;
import com.sansec.devicev4.gb.struct.key.rsa.RSArefPublicKeyLite;
import com.sansec.devicev4.gb.struct.key.sm2.SM2refCipher;
import com.sansec.devicev4.gb.struct.key.sm2.SM2refKeyPair;
import com.sansec.devicev4.gb.struct.key.sm2.SM2refPrivateKey;
import com.sansec.devicev4.gb.struct.key.sm2.SM2refPublicKey;
import com.sansec.devicev4.gb.struct.key.sm2.SM2refSignature;
import com.sansec.devicev4.log.CryptoLogger;
import com.sansec.devicev4.util.BytesUtil;
import com.sansec.devicev4.util.ECDSAUtil;
import com.sansec.devicev4.util.JarUtil;
import com.sansec.devicev4.util.SymmetryUtil;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.math.BigInteger;
import java.util.logging.Logger;

public final class LIBCrypto
implements ISDSCrypto {
    private static Logger logger = CryptoLogger.logger;
    private SDFInterface instanseSDF = null;
    private static PointerByReference phDeviceHandle = null;

    public LIBCrypto(int deviceType) throws CryptoException {
        switch (deviceType) {
            case 2: {
                JarUtil util = new JarUtil(JarUtil.class);
                String jnaLibPath = util.getJarPath();
                System.setProperty("jna.library.path", jnaLibPath);
                logger.fine("jna.library.path:" + jnaLibPath);
                this.instanseSDF = SDFInterface.instanseLib;
                logger.fine("DeviceType.LIB");
                logger.info("LIB ConfigFile use lib's default read path.");
                this.openDevice();
                break;
            }
            default: {
                throw new CryptoException("Illegal Device Type.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void openDevice() throws CryptoException {
        if (phDeviceHandle != null) return;
        Class<LIBCrypto> clazz = LIBCrypto.class;
        synchronized (LIBCrypto.class) {
            if (phDeviceHandle != null) return;
            PointerByReference ppDevice = new PointerByReference(Pointer.NULL);
            int flag = this.instanseSDF.SDF_OpenDevice(ppDevice);
            if (flag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
            phDeviceHandle = ppDevice;
            logger.info("Device open.");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public DeviceInfo getDeviceInfo() throws CryptoException {
        logger.info("-> LIBCrypto.getDeviceInfo()...");
        DeviceInfo pstDeviceInfo = new DeviceInfo();
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandleHandle = ppSessionHandle.getValue();
            int funFlag = this.instanseSDF.SDF_GetDeviceInfo(pSessionHandleHandle, pstDeviceInfo);
            if (funFlag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(funFlag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(funFlag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        logger.info("-> LIBCrypto.getDeviceInfo() end.");
        return pstDeviceInfo;
    }

    @Override
    public DeviceRunStatus getDeviceRunStatus() throws CryptoException {
        throw new CryptoException("CardCrypto unrealized method...");
    }

    @Override
    public int[] getKeyStatus(int keyType) throws CryptoException {
        throw new CryptoException("CardCrypto unrealized method...");
    }

    @Override
    public byte[] generateRandom(int randomLength) throws CryptoException {
        logger.info("-> LIBCrypto.generateRandom()...");
        logger.fine("randomLength:" + randomLength);
        byte[] random = null;
        if (randomLength <= 0) {
            logger.info("Illegal Random Length.");
            throw new CryptoException("Illegal Random Length.");
        }
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            random = new byte[randomLength];
            Pointer pSessionHandle = ppSessionHandle.getValue();
            int flag = this.instanseSDF.SDF_GenerateRandom(pSessionHandle, randomLength, random);
            if (flag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        logger.fine("random:" + BytesUtil.bytes2hex(random));
        logger.info("-> LIBCrypto.generateRandom() end.");
        return random;
    }

    @Override
    public IRSArefPublicKey getRSAPublicKey(int keyIndex, int keyType) throws CryptoException {
        logger.info("-> LIBCrypto.getRSAPublicKey()...");
        logger.fine("keyIndex:" + keyIndex);
        logger.fine("keyType:" + keyType);
        if (keyType != 1 && keyType != 2) {
            logger.info("Illegal key type(KEY_TYPE_SIGN|KEY_TYPE_ENC):" + keyType + ".");
            throw new CryptoException("Illegal key type(KEY_TYPE_SIGN|KEY_TYPE_ENC):" + keyType + ".");
        }
        RSArefPublicKeyEx pRsaPubKey = null;
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandle = ppSessionHandle.getValue();
            pRsaPubKey = new RSArefPublicKeyEx();
            int flag = 0;
            flag = keyType == 2 ? this.instanseSDF.SDF_ExportEncPublicKey_RSA(pSessionHandle, keyIndex, pRsaPubKey) : this.instanseSDF.SDF_ExportSignPublicKey_RSA(pSessionHandle, keyIndex, pRsaPubKey);
            if (flag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        Structure publicKey = null;
        publicKey = pRsaPubKey.bits <= 2048 ? new RSArefPublicKeyLite(pRsaPubKey.getBits(), BytesUtil.subbytes(pRsaPubKey.getM(), 0, 256), BytesUtil.subbytes(pRsaPubKey.getM(), 256, 256)) : new RSArefPublicKeyEx(pRsaPubKey.getBits(), pRsaPubKey.getM(), pRsaPubKey.getE());
        logger.fine("publicKey:" + ((Object)publicKey).toString());
        logger.info("-> LIBCrypto.getRSAPublicKey() end.");
        return publicKey;
    }

    @Override
    public RSArefKeyPair generateRSAKeyPair(int keysize) throws CryptoException {
        logger.info("-> LIBCrypto.generateRSAKeyPair()...");
        logger.fine("keysize" + keysize);
        if (keysize < 1024 || keysize > 4096 || keysize % 128 != 0) {
            throw new CryptoException("Illegal key length:" + keysize + ".");
        }
        Structure pRsaPubKey = null;
        Structure pRsaPriKey = null;
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandle = ppSessionHandle.getValue();
            if (keysize <= 2048) {
                pRsaPubKey = new RSArefPublicKeyLite.ByReference();
                pRsaPriKey = new RSArefPrivateKeyLite.ByReference();
            } else {
                pRsaPubKey = new RSArefPublicKeyEx.ByReference();
                pRsaPriKey = new RSArefPrivateKeyEx.ByReference();
            }
            int flag = this.instanseSDF.SDF_GenerateKeyPair_RSA(pSessionHandle, keysize, (IRSArefPublicKey)((Object)pRsaPubKey), (IRSArefPrivateKey)((Object)pRsaPriKey));
            if (flag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        logger.fine("pRsaPubKey:" + ((Object)pRsaPubKey).toString());
        logger.fine("pRsaPriKey:" + ((Object)pRsaPriKey).toString());
        logger.info("-> LIBCrypto.generateRSAKeyPair() end.");
        return new RSArefKeyPair((IRSArefPublicKey)((Object)pRsaPubKey), (IRSArefPrivateKey)((Object)pRsaPriKey));
    }

    @Override
    public RSArefKeyPair generateRSAKeyPair(int keysize, int exponent) throws CryptoException {
        throw new CryptoException("CardCrypto unrealized method...");
    }

    @Override
    public void generateRSAKeyPair(int keyIndex, int keyType, int keysize) throws CryptoException {
        throw new CryptoException("CardCrypto unrealized method...");
    }

    @Override
    public byte[] rsaPublicKeyOperation(int keyIndex, int keyType, byte[] input) throws CryptoException {
        logger.info("-> LIBCrypto.rsaPublicKeyOperation()...");
        logger.fine("keyIndex:" + keyIndex);
        logger.fine("keyType:" + keyType);
        logger.fine("input:" + BytesUtil.bytes2hex(input));
        if (keyType != 1 && keyType != 2) {
            logger.info("Illegal key type(KEY_TYPE_SIGN|KEY_TYPE_ENC):" + keyType + ".");
            throw new CryptoException("Illegal key type(KEY_TYPE_SIGN|KEY_TYPE_ENC):" + keyType + ".");
        }
        if (input == null || 0 == input.length) {
            logger.info("The input data is null.");
            throw new CryptoException("The input data is null.");
        }
        byte[] pucDataOutput = null;
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandleHandle = ppSessionHandle.getValue();
            RSArefPublicKeyEx pRsaPubKey = new RSArefPublicKeyEx();
            int keyFlag = 0;
            keyFlag = keyType == 2 ? this.instanseSDF.SDF_ExportEncPublicKey_RSA(pSessionHandleHandle, keyIndex, pRsaPubKey) : this.instanseSDF.SDF_ExportSignPublicKey_RSA(pSessionHandleHandle, keyIndex, pRsaPubKey);
            if (keyFlag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(keyFlag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(keyFlag));
            }
            Structure publicKey = null;
            publicKey = pRsaPubKey.bits <= 2048 ? new RSArefPublicKeyLite(pRsaPubKey.getBits(), BytesUtil.subbytes(pRsaPubKey.getM(), 0, 256), BytesUtil.subbytes(pRsaPubKey.getM(), 256, 256)) : new RSArefPublicKeyEx(pRsaPubKey.getBits(), pRsaPubKey.getM(), pRsaPubKey.getE());
            int keyLenth = publicKey.getBits() >> 3;
            if (keyLenth != input.length) {
                logger.info("Illegal input data length[" + keyLenth + "]:" + input.length);
                throw new CryptoException("Illegal input data length[" + keyLenth + "]:" + input.length);
            }
            BigInteger inputInteger = new BigInteger(1, input);
            BigInteger publicM = new BigInteger(1, publicKey.getM());
            if (inputInteger.compareTo(publicM) > 0) {
                logger.info("Illegal input data >publickey.M");
                throw new CryptoException("Illegal input data >publickey.M");
            }
            IntByReference puiOutputLength = new IntByReference(0);
            pucDataOutput = new byte[input.length];
            int flag = 0;
            flag = keyType == 1 ? this.instanseSDF.SDF_InternalPublicKeyOperation_RSA(pSessionHandleHandle, keyIndex, 65792, input, input.length, pucDataOutput, puiOutputLength) : this.instanseSDF.SDF_InternalPublicKeyOperation_RSA(pSessionHandleHandle, keyIndex, 66048, input, input.length, pucDataOutput, puiOutputLength);
            if (flag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        logger.fine("pucDataOutput:" + BytesUtil.bytes2hex(pucDataOutput));
        logger.info("-> LIBCrypto.rsaPublicKeyOperation() end.");
        return pucDataOutput;
    }

    @Override
    public byte[] rsaPrivateKeyOperation(int keyIndex, int keyType, byte[] input) throws CryptoException {
        logger.info("-> LIBCrypto.rsaPrivateKeyOperation()...");
        logger.fine("keyIndex:" + keyIndex);
        logger.fine("keyType:" + keyType);
        logger.fine("input:" + BytesUtil.bytes2hex(input));
        if (keyType != 1 && keyType != 2) {
            logger.info("Illegal key type(KEY_TYPE_SIGN|KEY_TYPE_ENC):" + keyType + ".");
            throw new CryptoException("Illegal key type(KEY_TYPE_SIGN|KEY_TYPE_ENC):" + keyType + ".");
        }
        if (input == null || 0 == input.length) {
            logger.info("The input data is null.");
            throw new CryptoException("The input data is null.");
        }
        byte[] pucDataOutput = null;
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandleHandle = ppSessionHandle.getValue();
            RSArefPublicKeyEx pRsaPubKey = new RSArefPublicKeyEx();
            int keyFlag = 0;
            keyFlag = keyType == 2 ? this.instanseSDF.SDF_ExportEncPublicKey_RSA(pSessionHandleHandle, keyIndex, pRsaPubKey) : this.instanseSDF.SDF_ExportSignPublicKey_RSA(pSessionHandleHandle, keyIndex, pRsaPubKey);
            if (keyFlag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(keyFlag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(keyFlag));
            }
            Structure publicKey = null;
            publicKey = pRsaPubKey.bits <= 2048 ? new RSArefPublicKeyLite(pRsaPubKey.getBits(), BytesUtil.subbytes(pRsaPubKey.getM(), 0, 256), BytesUtil.subbytes(pRsaPubKey.getM(), 256, 256)) : new RSArefPublicKeyEx(pRsaPubKey.getBits(), pRsaPubKey.getM(), pRsaPubKey.getE());
            int keyLenth = publicKey.getBits() >> 3;
            if (keyLenth != input.length) {
                logger.info("Illegal input data length[" + keyLenth + "]:" + input.length);
                throw new CryptoException("Illegal input data length[" + keyLenth + "]:" + input.length);
            }
            BigInteger inputInteger = new BigInteger(1, input);
            BigInteger publicM = new BigInteger(1, publicKey.getM());
            if (inputInteger.compareTo(publicM) > 0) {
                logger.info("Illegal input data >publickey.M");
                throw new CryptoException("Illegal input data >publickey.M");
            }
            IntByReference puiOutputLength = new IntByReference(0);
            pucDataOutput = new byte[input.length];
            int flag = 0;
            flag = keyType == 1 ? this.instanseSDF.SDF_InternalPrivateKeyOperation_RSA(pSessionHandleHandle, keyIndex, 65792, input, input.length, pucDataOutput, puiOutputLength) : this.instanseSDF.SDF_InternalPrivateKeyOperation_RSA(pSessionHandleHandle, keyIndex, 66048, input, input.length, pucDataOutput, puiOutputLength);
            if (flag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        logger.fine("pucDataOutput:" + BytesUtil.bytes2hex(pucDataOutput));
        logger.info("-> LIBCrypto.rsaPrivateKeyOperation() end.");
        return pucDataOutput;
    }

    @Override
    public byte[] rsaPublicKeyOperation(IRSArefPublicKey refPublicKey, byte[] input) throws CryptoException {
        logger.info("-> LIBCrypto.rsaPublicKeyOperation()...");
        logger.fine("refPublicKey:" + refPublicKey);
        logger.fine("input:" + BytesUtil.bytes2hex(input));
        if (refPublicKey == null) {
            logger.info("The PublicKey data is null.");
            throw new CryptoException("The PublicKey data is null.");
        }
        if (input == null || 0 == input.length) {
            logger.info("The input data is null.");
            throw new CryptoException("The input data is null.");
        }
        if (refPublicKey.getBits() >> 3 != input.length) {
            logger.info("Illegal input data length:" + input.length);
            throw new CryptoException("Illegal input data length:" + input.length);
        }
        BigInteger inputInteger = new BigInteger(1, input);
        BigInteger publicM = new BigInteger(1, refPublicKey.getM());
        if (inputInteger.compareTo(publicM) > 0) {
            logger.info("Illegal input data >publickey.M");
            throw new CryptoException("Illegal input data >publickey.M");
        }
        byte[] pucDataOutput = null;
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            IntByReference puiOutputLength;
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandleHandle = ppSessionHandle.getValue();
            int flag = this.instanseSDF.SDF_ExternalPublicKeyOperation_RSA(pSessionHandleHandle, refPublicKey, input, input.length, pucDataOutput = new byte[input.length], puiOutputLength = new IntByReference(0));
            if (flag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        logger.fine("pucDataOutput:" + BytesUtil.bytes2hex(pucDataOutput));
        logger.info("-> LIBCrypto.rsaPublicKeyOperation() end.");
        return pucDataOutput;
    }

    @Override
    public byte[] rsaPrivateKeyOperation(IRSArefPrivateKey refPrivateKey, byte[] input) throws CryptoException {
        logger.info("-> LIBCrypto.rsaPrivateKeyOperation()...");
        logger.fine("refPrivateKey:" + refPrivateKey.toString());
        logger.fine("input:" + BytesUtil.bytes2hex(input));
        if (null == refPrivateKey) {
            logger.info("The PrivateKey data is null.");
            throw new CryptoException("The PrivateKey data is null.");
        }
        if (input == null || 0 == input.length) {
            logger.info("The input data is null.");
            throw new CryptoException("The input data is null.");
        }
        if (refPrivateKey.getBits() >> 3 != input.length) {
            logger.info("Illegal input data length:" + input.length);
            throw new CryptoException("Illegal input data length:" + input.length);
        }
        BigInteger inputInteger = new BigInteger(1, input);
        BigInteger publicM = new BigInteger(1, refPrivateKey.getM());
        if (inputInteger.compareTo(publicM) > 0) {
            logger.info("Illegal input data > publickey.M");
            throw new CryptoException("Illegal input data > publickey.M");
        }
        byte[] pucDataOutput = null;
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            IntByReference puiOutputLength;
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandleHandle = ppSessionHandle.getValue();
            int flag = this.instanseSDF.SDF_ExternalPrivateKeyOperation_RSA(pSessionHandleHandle, refPrivateKey, input, input.length, pucDataOutput = new byte[input.length], puiOutputLength = new IntByReference(0));
            if (flag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        logger.fine("pucDataOutput:" + BytesUtil.bytes2hex(pucDataOutput));
        logger.info("-> LIBCrypto.rsaPrivateKeyOperation() end.");
        return pucDataOutput;
    }

    @Override
    public void rsaImportKeyPair(int keyIndex, int keyType, IRSArefPublicKey refPublicKey, IRSArefPrivateKey refPrivateKey) throws CryptoException {
        throw new CryptoException("CardCrypto unrealized method...");
    }

    @Override
    public SM2refPublicKey getSM2PublicKey(int keyIndex, int keyType) throws CryptoException {
        logger.info("-> LIBCrypto.getSM2PublicKey()...");
        logger.fine("keyIndex:" + keyIndex);
        logger.fine("keyType:" + keyType);
        if (keyType != 1 && keyType != 2) {
            logger.info("Illegal key type(KEY_TYPE_SIGN|KEY_TYPE_ENC):" + keyType + ".");
            throw new CryptoException("Illegal key type(KEY_TYPE_SIGN|KEY_TYPE_ENC):" + keyType + ".");
        }
        SM2refPublicKey pucPublicKey = null;
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandleHandle = ppSessionHandle.getValue();
            pucPublicKey = new SM2refPublicKey();
            int flag = 0;
            flag = keyType == 1 ? this.instanseSDF.SDF_ExportSignPublicKey_ECC(pSessionHandleHandle, keyIndex, pucPublicKey) : this.instanseSDF.SDF_ExportEncPublicKey_ECC(pSessionHandleHandle, keyIndex, pucPublicKey);
            if (flag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        SM2refPublicKey publicKey = new SM2refPublicKey(pucPublicKey.getX(), pucPublicKey.getY());
        logger.fine("publicKey:" + publicKey.toString());
        logger.info("-> LIBCrypto.getSM2PublicKey() end.");
        return publicKey;
    }

    @Override
    public SM2refKeyPair generateSM2KeyPair(int keysize) throws CryptoException {
        logger.info("-> LIBCrypto.generateSM2KeyPair()...");
        logger.fine("keysize:" + keysize);
        if (keysize != 256) {
            logger.info("Illegal SM2 key length:" + keysize + ".");
            throw new CryptoException("Illegal SM2 key length:" + keysize + ".");
        }
        SM2refPublicKey pucPublicKey = null;
        SM2refPrivateKey pucPrivateKey = null;
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandle = ppSessionHandle.getValue();
            int flag = this.instanseSDF.SDF_GenerateKeyPair_ECC(pSessionHandle, 131072, keysize, pucPublicKey = new SM2refPublicKey(), pucPrivateKey = new SM2refPrivateKey());
            if (flag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        logger.fine("pucPublicKey:" + pucPublicKey.toString());
        logger.fine("pucPrivateKey:" + pucPrivateKey.toString());
        logger.info("-> LIBCrypto.generateSM2KeyPair() end.");
        return new SM2refKeyPair(pucPublicKey, pucPrivateKey);
    }

    @Override
    public void generateSM2KeyPair(int keyIndex, int keyType, int keysize) throws CryptoException {
        throw new CryptoException("CardCrypto unrealized method...");
    }

    @Override
    public SM2refCipher sm2Encrypt(int keyIndex, int keyType, byte[] input) throws CryptoException {
        logger.info("-> LIBCrypto.sm2Encrypt()...");
        logger.fine("keyIndex:" + keyIndex);
        logger.fine("input:" + BytesUtil.bytes2hex(input));
        if (keyType != 1 && keyType != 2) {
            logger.info("Illegal key type(KEY_TYPE_SIGN|KEY_TYPE_ENC):" + keyType + ".");
            throw new CryptoException("Illegal key type(KEY_TYPE_SIGN|KEY_TYPE_ENC):" + keyType + ".");
        }
        if (input == null || 0 == input.length) {
            logger.info("The input data is null.");
            throw new CryptoException("The input data is null.");
        }
        if (input.length > 136) {
            logger.info("Illegal input data length:" + input.length + ".");
            throw new CryptoException("Illegal input data length:" + input.length + ".");
        }
        SM2refCipher sm2refCipher = null;
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandle = ppSessionHandle.getValue();
            sm2refCipher = new SM2refCipher();
            int flag = 0;
            flag = keyType == 1 ? this.instanseSDF.SDF_InternalEncrypt_ECC(pSessionHandle, keyIndex, 131328, input, input.length, sm2refCipher) : this.instanseSDF.SDF_InternalEncrypt_ECC(pSessionHandle, keyIndex, 132096, input, input.length, sm2refCipher);
            if (flag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        logger.fine("sm2refCipher:" + sm2refCipher.toString());
        logger.info("-> LIBCrypto.sm2Encrypt() end.");
        return sm2refCipher;
    }

    @Override
    public byte[] sm2Decrypt(int keyIndex, int keyType, SM2refCipher refCipher) throws CryptoException {
        logger.info("-> LIBCrypto.sm2Decrypt()...");
        logger.fine("keyIndex:" + keyIndex);
        logger.fine("refCipher:" + refCipher.toString());
        if (keyType != 1 && keyType != 2) {
            logger.info("Illegal key type(KEY_TYPE_SIGN|KEY_TYPE_ENC):" + keyType + ".");
            throw new CryptoException("Illegal key type(KEY_TYPE_SIGN|KEY_TYPE_ENC):" + keyType + ".");
        }
        if (refCipher == null) {
            logger.info("The SM2refCipher data is null.");
            throw new CryptoException("The SM2refCipher data is null.");
        }
        byte[] pucDataOutput = null;
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandle = ppSessionHandle.getValue();
            IntByReference puiOutputLength = new IntByReference(0);
            pucDataOutput = new byte[refCipher.cLength];
            int flag = 0;
            flag = keyType == 1 ? this.instanseSDF.SDF_InternalDecrypt_ECC(pSessionHandle, keyIndex, 131328, refCipher, pucDataOutput, puiOutputLength) : this.instanseSDF.SDF_InternalDecrypt_ECC(pSessionHandle, keyIndex, 132096, refCipher, pucDataOutput, puiOutputLength);
            if (flag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        logger.fine("pucDataOutput:" + BytesUtil.bytes2hex(pucDataOutput));
        logger.info("-> LIBCrypto.sm2Decrypt() end.");
        return pucDataOutput;
    }

    @Override
    public SM2refCipher sm2Encrypt(SM2refPublicKey publicKey, byte[] dataInput) throws CryptoException {
        logger.info("-> LIBCrypto.sm2Encrypt()...");
        logger.fine("publicKey:" + publicKey.toString());
        logger.fine("dataInput:" + BytesUtil.bytes2hex(dataInput));
        if (publicKey == null) {
            logger.info("The SM2refPublicKey data is null.");
            throw new CryptoException("The SM2refPublicKey data is null.");
        }
        if (dataInput == null || 0 == dataInput.length) {
            logger.info("The input data is null.");
            throw new CryptoException("The input data is null.");
        }
        if (dataInput.length > 136) {
            logger.info("Illegal input data length:" + dataInput.length + ".");
            throw new CryptoException("Illegal input data length:" + dataInput.length + ".");
        }
        SM2refCipher sm2refCipher = null;
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandle = ppSessionHandle.getValue();
            int flag = this.instanseSDF.SDF_ExternalEncrypt_ECC(pSessionHandle, 132096, publicKey, dataInput, dataInput.length, sm2refCipher = new SM2refCipher());
            if (flag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        logger.fine("sm2refCipher:" + sm2refCipher.toString());
        logger.info("-> LIBCrypto.sm2Encrypt() end.");
        return sm2refCipher;
    }

    @Override
    public byte[] sm2Decrypt(SM2refPrivateKey privateKey, SM2refCipher refCipher) throws CryptoException {
        logger.info("-> LIBCrypto.sm2Decrypt()...");
        logger.fine("privateKey:" + privateKey.toString());
        logger.fine("refCipher:" + refCipher.toString());
        if (privateKey == null) {
            logger.info("The SM2refPrivateKey data is null.");
            throw new CryptoException("The SM2refPrivateKey data is null.");
        }
        if (refCipher == null) {
            logger.info("The SM2refCipher data is null.");
            throw new CryptoException("The SM2refCipher data is null.");
        }
        byte[] pucDataOutput = null;
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            IntByReference puiOutputLength;
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandle = ppSessionHandle.getValue();
            int flag = this.instanseSDF.SDF_ExternalDecrypt_ECC(pSessionHandle, 132096, privateKey, refCipher, pucDataOutput = new byte[refCipher.cLength], puiOutputLength = new IntByReference(0));
            if (flag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        logger.fine("pucDataOutput:" + BytesUtil.bytes2hex(pucDataOutput));
        logger.info("-> LIBCrypto.sm2Decrypt() end.");
        return pucDataOutput;
    }

    @Override
    public SM2refSignature sm2Sign(int keyIndex, int keyType, byte[] input) throws CryptoException {
        logger.info("-> LIBCrypto.sm2Sign()...");
        logger.fine("keyIndex:" + keyIndex);
        logger.fine("input:" + BytesUtil.bytes2hex(input));
        if (keyType != 1 && keyType != 2) {
            logger.info("Illegal key type(KEY_TYPE_SIGN|KEY_TYPE_ENC):" + keyType + ".");
            throw new CryptoException("Illegal key type(KEY_TYPE_SIGN|KEY_TYPE_ENC):" + keyType + ".");
        }
        if (input == null || 0 == input.length) {
            logger.info("The input data is null.");
            throw new CryptoException("The input data is null.");
        }
        if (input.length != 32) {
            logger.info("Illegal input data length:" + input.length + ".");
            throw new CryptoException("Illegal input data length:" + input.length + ".");
        }
        SM2refSignature sm2refSignature = null;
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandle = ppSessionHandle.getValue();
            sm2refSignature = new SM2refSignature();
            int flag = 0;
            flag = keyType == 1 ? this.instanseSDF.SDF_InternalSign_ECC_Ex(pSessionHandle, keyIndex, 131328, input, input.length, sm2refSignature) : this.instanseSDF.SDF_InternalSign_ECC_Ex(pSessionHandle, keyIndex, 132096, input, input.length, sm2refSignature);
            if (flag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        logger.fine("sm2refSignature:" + sm2refSignature.toString());
        logger.info("-> LIBCrypto.sm2Sign() end.");
        return sm2refSignature;
    }

    @Override
    public boolean sm2Verify(int keyIndex, int keyType, byte[] dataInput, SM2refSignature refSig) throws CryptoException {
        logger.info("-> LIBCrypto.sm2Verify()...");
        logger.fine("keyIndex:" + keyIndex);
        logger.fine("dataInput:" + BytesUtil.bytes2hex(dataInput));
        if (keyType != 1 && keyType != 2) {
            logger.info("Illegal key type(KEY_TYPE_SIGN|KEY_TYPE_ENC):" + keyType + ".");
            throw new CryptoException("Illegal key type(KEY_TYPE_SIGN|KEY_TYPE_ENC):" + keyType + ".");
        }
        if (dataInput == null || 0 == dataInput.length) {
            logger.info("The input data is null.");
            throw new CryptoException("The input data is null.");
        }
        if (dataInput.length != 32) {
            logger.info("Illegal input data length:" + dataInput.length + ".");
            throw new CryptoException("Illegal input data length:" + dataInput.length + ".");
        }
        if (refSig == null) {
            logger.info("The SM2refSignature data is null.");
            throw new CryptoException("The SM2refSignature data is null.");
        }
        int flag = -1;
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandle = ppSessionHandle.getValue();
            flag = keyType == 1 ? this.instanseSDF.SDF_InternalVerify_ECC_Ex(pSessionHandle, keyIndex, 131328, dataInput, dataInput.length, refSig) : this.instanseSDF.SDF_InternalVerify_ECC_Ex(pSessionHandle, keyIndex, 132096, dataInput, dataInput.length, refSig);
            if (flag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(flag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        logger.info("-> LIBCrypto.sm2Verify() end.");
        if (flag != GBErrorCode_SDR.SDR_OK) {
            logger.fine("result:false");
            return false;
        }
        logger.fine("result:true");
        return true;
    }

    @Override
    public SM2refSignature sm2Sign(SM2refPrivateKey refPrivateKey, byte[] input) throws CryptoException {
        logger.info("-> LIBCrypto.sm2Sign()...");
        logger.fine("refPrivateKey:" + refPrivateKey.toString());
        logger.fine("input:" + BytesUtil.bytes2hex(input));
        if (refPrivateKey == null) {
            logger.info("The SM2refPrivateKey data is null.");
            throw new CryptoException("The SM2refPrivateKey data is null.");
        }
        if (input == null || 0 == input.length) {
            logger.info("The input data is null.");
            throw new CryptoException("The input data is null.");
        }
        if (input.length != 32) {
            logger.info("Illegal input data length:" + input.length + ".");
            throw new CryptoException("Illegal input data length:" + input.length + ".");
        }
        SM2refSignature sm2refSignature = null;
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandle = ppSessionHandle.getValue();
            int flag = this.instanseSDF.SDF_ExternalSign_ECC(pSessionHandle, 131328, refPrivateKey, input, input.length, sm2refSignature = new SM2refSignature());
            if (flag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        logger.fine("sm2refSignature:" + sm2refSignature.toString());
        logger.info("-> LIBCrypto.sm2Sign() end.");
        return sm2refSignature;
    }

    @Override
    public boolean sm2Verify(SM2refPublicKey refPublicKey, byte[] dataInput, SM2refSignature refSig) throws CryptoException {
        logger.info("-> LIBCrypto.sm2Verify()...");
        logger.fine("refPublicKey:" + refPublicKey.toString());
        logger.fine("dataInput:" + BytesUtil.bytes2hex(dataInput));
        logger.fine("refSig:" + refSig.toString());
        if (refPublicKey == null) {
            logger.info("The SM2refPublicKey data is null.");
            throw new CryptoException("The SM2refPublicKey data is null.");
        }
        if (dataInput == null || 0 == dataInput.length) {
            logger.info("The input data is null.");
            throw new CryptoException("The input data is null.");
        }
        if (dataInput.length != 32) {
            logger.info("Illegal input data length:" + dataInput.length + ".");
            throw new CryptoException("Illegal input data length:" + dataInput.length + ".");
        }
        if (refSig == null) {
            logger.info("The SM2refSignature data is null.");
            throw new CryptoException("The SM2refSignature data is null.");
        }
        int flag = -1;
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandle = ppSessionHandle.getValue();
            flag = this.instanseSDF.SDF_ExternalVerify_ECC(pSessionHandle, 131328, refPublicKey, dataInput, dataInput.length, refSig);
            if (flag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(flag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        logger.info("-> LIBCrypto.sm2Verify() end.");
        if (flag != GBErrorCode_SDR.SDR_OK) {
            logger.fine("result:false");
            return false;
        }
        logger.fine("result:true");
        return true;
    }

    @Override
    public byte[] keyAgreement_SM2(int flag, int keyIndex, SM2refPublicKey ownTmpPubKey, SM2refPrivateKey ownTmpPriKey, SM2refPublicKey opPubKey, SM2refPublicKey opTmpPubKey, int keyBits, byte[] ownId, byte[] opId) throws Exception {
        throw new CryptoException("CardCrypto unrealized method...");
    }

    @Override
    public void sm2ImportKeyPair(int keyIndex, int keyType, SM2refPublicKey refPublicKey, SM2refPrivateKey refPrivateKey) throws CryptoException {
        throw new CryptoException("CardCrypto unrealized method...");
    }

    @Override
    public ECDSArefKeyPair generateECDSAKeyPair(int keysize, int curetype) throws CryptoException {
        logger.info("-> LIBCrypto.generateECDSAKeyPair()...");
        logger.fine("keysize:" + keysize);
        logger.fine("curetype:" + curetype);
        if (!ECDSAUtil.checkCurveType(curetype)) {
            throw new CryptoException("Illegal ECDSA curve parameters( " + curetype + " )");
        }
        if (!ECDSAUtil.checkKeyLength(curetype, keysize)) {
            throw new CryptoException("Illegal ECDSA curve parameters( " + curetype + " )," + "key modulus( " + keysize + " )");
        }
        ECDSArefPublicKey pucPublicKey = null;
        ECDSArefPrivateKey pucPrivateKey = null;
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            int flag;
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandle = ppSessionHandle.getValue();
            pucPublicKey = new ECDSArefPublicKey();
            pucPrivateKey = new ECDSArefPrivateKey();
            if (curetype == 524289) {
                curetype = 0;
            }
            if ((flag = this.instanseSDF.SDF_GenerateKeyPair_ECDSA(pSessionHandle, 524288, keysize, curetype, pucPublicKey, pucPrivateKey)) != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        if (pucPublicKey.getCurvetype() == 0) {
            pucPublicKey.setCurvetype(524289);
            pucPrivateKey.setCurvetype(524289);
        }
        logger.fine("pucPublicKey:" + pucPublicKey.toString());
        logger.fine("pucPrivateKey:" + pucPrivateKey.toString());
        logger.info("-> LIBCrypto.generateECDSAKeyPair() end.");
        return new ECDSArefKeyPair(pucPublicKey, pucPrivateKey);
    }

    @Override
    public ECDSArefPublicKey getECDSAPublicKey(int keyIndex, int keyType) throws CryptoException {
        logger.info("-> LIBCrypto.getECDSAPublicKey()...");
        logger.fine("keyIndex:" + keyIndex);
        logger.fine("keyType:" + keyType);
        if (keyType != 1 && keyType != 2) {
            logger.info("Illegal key type(KEY_TYPE_SIGN|KEY_TYPE_ENC):" + keyType + ".");
            throw new CryptoException("Illegal key type(KEY_TYPE_SIGN|KEY_TYPE_ENC):" + keyType + ".");
        }
        ECDSArefPublicKey pucPublicKey = null;
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandleHandle = ppSessionHandle.getValue();
            pucPublicKey = new ECDSArefPublicKey();
            int flag = 0;
            flag = keyType == 1 ? this.instanseSDF.SDF_ExportSignPublicKey_ECDSA(pSessionHandleHandle, keyIndex, pucPublicKey) : this.instanseSDF.SDF_ExportEncPublicKey_ECDSA(pSessionHandleHandle, keyIndex, pucPublicKey);
            if (flag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        if (pucPublicKey.getCurvetype() == 0) {
            pucPublicKey.setCurvetype(524289);
        }
        logger.fine("publicKey:" + pucPublicKey.toString());
        logger.info("-> LIBCrypto.getECDSAPublicKey() end.");
        return pucPublicKey;
    }

    @Override
    public ECDSArefSignature ecdsaSign(int keyIndex, int keyType, byte[] input) throws CryptoException {
        logger.info("-> LIBCrypto.ecdsaSign()...");
        logger.fine("keyIndex:" + keyIndex);
        logger.fine("keyType:" + keyType);
        logger.fine("input:" + BytesUtil.bytes2hex(input));
        if (keyType != 1 && keyType != 2) {
            logger.info("Illegal key type(KEY_TYPE_SIGN|KEY_TYPE_ENC):" + keyType + ".");
            throw new CryptoException("Illegal key type(KEY_TYPE_SIGN|KEY_TYPE_ENC):" + keyType + ".");
        }
        if (keyIndex < 1) {
            throw new CryptoException("Illegal key index( " + keyIndex + " )");
        }
        if (input == null || input.length < 1) {
            throw new CryptoException("Input data is null");
        }
        ECDSArefSignature refSignature = null;
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandle = ppSessionHandle.getValue();
            IntByReference uiSignatureDataLength = new IntByReference(0);
            refSignature = new ECDSArefSignature();
            int flag = 0;
            byte[] signOut = new byte[160];
            flag = keyType == 1 ? this.instanseSDF.SDF_InternalSign_ECDSA(pSessionHandle, keyIndex, 524544, input, input.length, signOut, uiSignatureDataLength) : this.instanseSDF.SDF_InternalSign_ECDSA(pSessionHandle, keyIndex, 524800, input, input.length, signOut, uiSignatureDataLength);
            if (flag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
            int signLen = uiSignatureDataLength.getValue();
            byte[] signResult = new byte[signLen];
            System.arraycopy(signOut, 0, signResult, 0, signLen);
            refSignature.decode(signResult);
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        logger.fine("ecdsaRefSignature:" + refSignature.toString());
        logger.info("-> LIBCrypto.ecdsaSign() end.");
        return refSignature;
    }

    @Override
    public ECDSArefSignature ecdsaSign(ECDSArefPrivateKey refPrivateKey, byte[] input) throws CryptoException {
        logger.info("-> LIBCrypto.ecdsaSign()...");
        logger.fine("refPrivateKey:" + refPrivateKey.toString());
        logger.fine("input:" + BytesUtil.bytes2hex(input));
        if (refPrivateKey == null) {
            logger.info("The ECDSArefPrivateKey data is null.");
            throw new CryptoException("The ECDSArefPrivateKey data is null.");
        }
        if (input == null || input.length < 1) {
            throw new CryptoException("Input data is null");
        }
        ECDSArefSignature refSignature = null;
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            byte[] signOut;
            int flag;
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandle = ppSessionHandle.getValue();
            IntByReference uiSignatureDataLength = new IntByReference(0);
            refSignature = new ECDSArefSignature();
            if (refPrivateKey.getCurvetype() == 524289) {
                refPrivateKey.setCurvetype(0);
            }
            if ((flag = this.instanseSDF.SDF_ExternalSign_ECDSA(pSessionHandle, 524544, refPrivateKey, input, input.length, signOut = new byte[160], uiSignatureDataLength)) != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
            int signLen = uiSignatureDataLength.getValue();
            byte[] signResult = new byte[signLen];
            System.arraycopy(signOut, 0, signResult, 0, signLen);
            refSignature.decode(signResult);
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        logger.fine("ecdsaRefSignature:" + refSignature.toString());
        logger.info("-> LIBCrypto.sm2Sign() end.");
        return refSignature;
    }

    @Override
    public boolean ecdsaVerify(int keyIndex, int keyType, byte[] dataInput, ECDSArefSignature refSig) throws CryptoException {
        logger.info("-> LIBCrypto.ecdsaVerify()...");
        logger.fine("keyIndex:" + keyIndex);
        logger.fine("dataInput:" + BytesUtil.bytes2hex(dataInput));
        if (keyIndex < 1) {
            throw new CryptoException("Illegal key index( " + keyIndex + " )");
        }
        if (keyType != 1 && keyType != 2) {
            logger.info("Illegal key type(KEY_TYPE_SIGN|KEY_TYPE_ENC):" + keyType + ".");
            throw new CryptoException("Illegal key type(KEY_TYPE_SIGN|KEY_TYPE_ENC):" + keyType + ".");
        }
        if (dataInput == null || dataInput.length < 1) {
            throw new CryptoException("Input data is null");
        }
        if (refSig == null) {
            logger.info("The ECDSArefSignature data is null.");
            throw new CryptoException("The ECDSArefSignature data is null.");
        }
        int flag = -1;
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandle = ppSessionHandle.getValue();
            flag = keyType == 1 ? this.instanseSDF.SDF_InternalVerify_ECDSA(pSessionHandle, keyIndex, 524544, dataInput, dataInput.length, refSig, refSig.size()) : this.instanseSDF.SDF_InternalVerify_ECDSA(pSessionHandle, keyIndex, 524800, dataInput, dataInput.length, refSig, refSig.size());
            if (flag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(flag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        logger.info("-> LIBCrypto.ecdsaVerify() end.");
        if (flag != GBErrorCode_SDR.SDR_OK) {
            logger.fine("result:false");
            return false;
        }
        logger.fine("result:true");
        return true;
    }

    @Override
    public boolean ecdsaVerify(ECDSArefPublicKey refPublicKey, byte[] dataInput, ECDSArefSignature refSig) throws CryptoException {
        logger.info("-> LIBCrypto.ecdsaVerify()...");
        logger.fine("refPublicKey:" + refPublicKey.toString());
        logger.fine("dataInput:" + BytesUtil.bytes2hex(dataInput));
        logger.fine("refSig:" + refSig.toString());
        if (refPublicKey == null) {
            logger.info("The ECDSArefPublicKey data is null.");
            throw new CryptoException("The ECDSArefPublicKey data is null.");
        }
        if (dataInput == null || dataInput.length < 1) {
            throw new CryptoException("Input data is null");
        }
        if (refSig == null) {
            logger.info("The ECDSArefSignature data is null.");
            throw new CryptoException("The ECDSArefSignature data is null.");
        }
        int flag = -1;
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            Pointer pSessionHandle;
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            if (refPublicKey.getCurvetype() == 524289) {
                refPublicKey.setCurvetype(0);
            }
            if ((flag = this.instanseSDF.SDF_ExternalVerify_ECDSA(pSessionHandle = ppSessionHandle.getValue(), 524544, refPublicKey, dataInput, dataInput.length, refSig, refSig.size())) != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(flag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        logger.info("-> LIBCrypto.ecdsaVerify() end.");
        if (flag != GBErrorCode_SDR.SDR_OK) {
            logger.fine("result:false");
            return false;
        }
        logger.fine("result:true");
        return true;
    }

    @Override
    public DSArefKeyPair generateDSAKeyPair(int keysize) throws CryptoException {
        throw new CryptoException("CardCrypto unrealized method...");
    }

    @Override
    public IDSArefPublicKey getDSAPublicKey(int keyIndex, int keyType) throws CryptoException {
        throw new CryptoException("CardCrypto unrealized method...");
    }

    @Override
    public DSArefSignature dsaSign(int keyIndex, int keyType, byte[] input) throws CryptoException {
        throw new CryptoException("CardCrypto unrealized method...");
    }

    @Override
    public DSArefSignature dsaSign(IDSArefPrivateKey refPrivateKey, byte[] input) throws CryptoException {
        throw new CryptoException("CardCrypto unrealized method...");
    }

    @Override
    public boolean dsaVerify(int keyIndex, int keyType, byte[] dataInput, DSArefSignature refSig) throws CryptoException {
        throw new CryptoException("CardCrypto unrealized method...");
    }

    @Override
    public boolean dsaVerify(IDSArefPublicKey refPublicKey, byte[] dataInput, DSArefSignature refSig) throws CryptoException {
        throw new CryptoException("CardCrypto unrealized method...");
    }

    @Override
    public void generateKey(int keyIndex, int keysize) throws CryptoException {
        throw new CryptoException("CardCrypto unrealized method...");
    }

    @Override
    public byte[] encrypt(int algId, byte[] key, byte[] iv, byte[] input) throws CryptoException {
        logger.info("-> LIBCrypto.encrypt()...");
        logger.fine("algId:" + algId);
        logger.fine("key:" + BytesUtil.bytes2hex(key));
        logger.fine("iv:" + BytesUtil.bytes2hex(iv));
        logger.fine("input:" + BytesUtil.bytes2hex(input));
        if (key == null || 0 == key.length) {
            logger.info("The Key data is null.");
            throw new CryptoException("The Key data is null.");
        }
        if (!SymmetryUtil.isRightAlg(algId)) {
            logger.info("Illegal GBAlgorithmID_SGD:" + Integer.toHexString(algId));
            throw new CryptoException("Illegal GBAlgorithmID_SGD:" + Integer.toHexString(algId));
        }
        if (!SymmetryUtil.isRightIV(algId, iv)) {
            logger.info("IV data length error.");
            throw new CryptoException("IV data length error.");
        }
        if (!SymmetryUtil.isRightInput(algId, input)) {
            logger.info("Input data length error.");
            throw new CryptoException("Input data length error.");
        }
        byte[] pucDataOutput = null;
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandle = ppSessionHandle.getValue();
            PointerByReference phKeyHandle = new PointerByReference(Pointer.NULL);
            IntByReference puiOutputLength = new IntByReference(0);
            int flag = this.instanseSDF.SDF_ImportKey(pSessionHandle, key, key.length, phKeyHandle);
            if (flag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
            pucDataOutput = new byte[input.length];
            flag = this.instanseSDF.SDF_Encrypt(pSessionHandle, phKeyHandle.getValue(), algId, iv, input, input.length, pucDataOutput, puiOutputLength);
            if (flag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        logger.fine("pucDataOutput:" + BytesUtil.bytes2hex(pucDataOutput));
        logger.info("-> LIBCrypto.encrypt() end.");
        return pucDataOutput;
    }

    @Override
    public byte[] decrypt(int algId, byte[] key, byte[] iv, byte[] input) throws CryptoException {
        logger.info("-> LIBCrypto.decrypt()...");
        logger.fine("algId:" + algId);
        logger.fine("key:" + BytesUtil.bytes2hex(key));
        logger.fine("iv:" + BytesUtil.bytes2hex(iv));
        logger.fine("input:" + BytesUtil.bytes2hex(input));
        if (key == null || 0 == key.length) {
            logger.info("The Key data is null.");
            throw new CryptoException("The Key data is null.");
        }
        if (!SymmetryUtil.isRightAlg(algId)) {
            logger.info("Illegal GBAlgorithmID_SGD:" + Integer.toHexString(algId));
            throw new CryptoException("Illegal GBAlgorithmID_SGD:" + Integer.toHexString(algId));
        }
        if (!SymmetryUtil.isRightIV(algId, iv)) {
            logger.info("IV data length error.");
            throw new CryptoException("IV data length error.");
        }
        if (!SymmetryUtil.isRightInput(algId, input)) {
            logger.info("Input data length error.");
            throw new CryptoException("Input data length error.");
        }
        byte[] pucDataOutput = null;
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandle = ppSessionHandle.getValue();
            PointerByReference phKeyHandle = new PointerByReference(Pointer.NULL);
            IntByReference puiOutputLength = new IntByReference(0);
            int flag = this.instanseSDF.SDF_ImportKey(pSessionHandle, key, key.length, phKeyHandle);
            if (flag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
            pucDataOutput = new byte[input.length];
            flag = this.instanseSDF.SDF_Decrypt(pSessionHandle, phKeyHandle.getValue(), algId, iv, input, input.length, pucDataOutput, puiOutputLength);
            if (flag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        logger.fine("pucDataOutput:" + BytesUtil.bytes2hex(pucDataOutput));
        logger.info("-> LIBCrypto.decrypt() end.");
        return pucDataOutput;
    }

    @Override
    public byte[] encrypt(int algId, int keyIndex, byte[] iv, byte[] input) throws CryptoException {
        logger.info("-> LIBCrypto.encrypt()...");
        logger.fine("algId:" + algId);
        logger.fine("keyIndex:" + keyIndex);
        logger.fine("iv:" + BytesUtil.bytes2hex(iv));
        logger.fine("input:" + BytesUtil.bytes2hex(input));
        if (!SymmetryUtil.isRightAlg(algId)) {
            logger.info("Illegal GBAlgorithmID_SGD:" + Integer.toHexString(algId));
            throw new CryptoException("Illegal GBAlgorithmID_SGD:" + Integer.toHexString(algId));
        }
        if (!SymmetryUtil.isRightIV(algId, iv)) {
            logger.info("IV data length error.");
            throw new CryptoException("IV data length error.");
        }
        if (!SymmetryUtil.isRightInput(algId, input)) {
            logger.info("Input data length error.");
            throw new CryptoException("Input data length error.");
        }
        byte[] pucDataOutput = null;
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandle = ppSessionHandle.getValue();
            PointerByReference phKeyHandle = new PointerByReference(Pointer.NULL);
            IntByReference puiOutputLength = new IntByReference(0);
            int flag = this.instanseSDF.SDF_GetSymmKeyHandle(pSessionHandle, keyIndex, phKeyHandle);
            if (flag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
            pucDataOutput = new byte[input.length];
            flag = this.instanseSDF.SDF_Encrypt(pSessionHandle, phKeyHandle.getValue(), algId, iv, input, input.length, pucDataOutput, puiOutputLength);
            if (flag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        logger.fine("pucDataOutput:" + BytesUtil.bytes2hex(pucDataOutput));
        logger.info("-> LIBCrypto.encrypt() end.");
        return pucDataOutput;
    }

    @Override
    public byte[] decrypt(int algId, int keyIndex, byte[] iv, byte[] input) throws CryptoException {
        logger.info("-> LIBCrypto.decrypt()...");
        logger.fine("algId:" + algId);
        logger.fine("keyIndex:" + keyIndex);
        logger.fine("iv:" + BytesUtil.bytes2hex(iv));
        logger.fine("input:" + BytesUtil.bytes2hex(input));
        if (!SymmetryUtil.isRightAlg(algId)) {
            logger.info("Illegal GBAlgorithmID_SGD:" + Integer.toHexString(algId));
            throw new CryptoException("Illegal GBAlgorithmID_SGD:" + Integer.toHexString(algId));
        }
        if (!SymmetryUtil.isRightIV(algId, iv)) {
            logger.info("IV data length error.");
            throw new CryptoException("IV data length error.");
        }
        if (!SymmetryUtil.isRightInput(algId, input)) {
            logger.info("Input data length error.");
            throw new CryptoException("Input data length error.");
        }
        byte[] pucDataOutput = null;
        Pointer hDeviceHandle = phDeviceHandle.getValue();
        PointerByReference ppSessionHandle = new PointerByReference(Pointer.NULL);
        try {
            int openFlag = this.instanseSDF.SDF_OpenSession(hDeviceHandle, ppSessionHandle);
            if (openFlag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(openFlag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(openFlag));
            }
            Pointer pSessionHandle = ppSessionHandle.getValue();
            PointerByReference phKeyHandle = new PointerByReference(Pointer.NULL);
            IntByReference puiOutputLength = new IntByReference(0);
            int flag = this.instanseSDF.SDF_GetSymmKeyHandle(pSessionHandle, keyIndex, phKeyHandle);
            if (flag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
            pucDataOutput = new byte[input.length];
            flag = this.instanseSDF.SDF_Decrypt(pSessionHandle, phKeyHandle.getValue(), algId, iv, input, input.length, pucDataOutput, puiOutputLength);
            if (flag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(flag));
                throw new CryptoException(GBErrorCode_SDR.toErrorInfo(flag));
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        finally {
            int closeFlag = this.instanseSDF.SDF_CloseSession(ppSessionHandle.getValue());
            if (closeFlag != GBErrorCode_SDR.SDR_OK) {
                logger.info(GBErrorCode_SDR.toErrorInfo(closeFlag));
            }
        }
        logger.fine("pucDataOutput:" + BytesUtil.bytes2hex(pucDataOutput));
        logger.info("-> LIBCrypto.decrypt() end.");
        return pucDataOutput;
    }

    @Override
    public byte[] encrypt_add(int algId, byte[] key, byte[] iv, byte[] input, byte[] addInput) throws CryptoException {
        throw new CryptoException("CardCrypto unrealized method...");
    }

    @Override
    public byte[] decrypt_add(int algId, byte[] key, byte[] iv, byte[] input, byte[] addInput) throws CryptoException {
        throw new CryptoException("CardCrypto unrealized method...");
    }

    @Override
    public byte[] encrypt_add(int algId, int keyIndex, byte[] iv, byte[] input, byte[] addInput) throws CryptoException {
        throw new CryptoException("CardCrypto unrealized method...");
    }

    @Override
    public byte[] decrypt_add(int algId, int keyIndex, byte[] iv, byte[] input, byte[] addInput) throws CryptoException {
        throw new CryptoException("CardCrypto unrealized method...");
    }

    @Override
    public void inputKEK(int keyIndex, byte[] key) throws CryptoException {
        throw new CryptoException("CardCrypto unrealized method...");
    }

    @Override
    public void importKeyPair_ECC(int keyIndex, int keyType, int keyPriKeyIndex, byte[] eccPairEnvelopedKey) throws CryptoException {
        throw new CryptoException("CardCrypto unrealized method...");
    }

    @Override
    public void importEncKeyPair_ECC(int keyIndex, byte[] eccPairEnvelopedKey) throws CryptoException {
        throw new CryptoException("CardCrypto unrealized method...");
    }

    @Override
    public byte[] genKCV(int keyIndex) throws CryptoException {
        throw new CryptoException("CardCrypto unrealized method...");
    }

    @Override
    public byte[] generateHMAC(int algId, int keyIndex, byte[] input) throws CryptoException {
        throw new CryptoException("CardCrypto unrealized method...");
    }

    @Override
    public byte[] generateHMAC(int algId, byte[] key, byte[] input) throws CryptoException {
        throw new CryptoException("CardCrypto unrealized method...");
    }

    @Override
    public byte[] genPBKDF2Key(int hashAlg, int iteraCount, int outLength, char[] pwd, byte[] salt) throws CryptoException {
        throw new CryptoException("CardCrypto unrealized method...");
    }

    @Override
    public byte[] genPBKDF2KeyExt(int hashAlg, int iteraCount, int outLength, char[] pwd, byte[] salt, int keyIndex) throws CryptoException {
        throw new CryptoException("CardCrypto unrealized method...");
    }

    @Override
    public byte[] ecdhAgreement(int ecdsIndex, int keyType, byte[] pubKey) throws CryptoException {
        throw new CryptoException("CardCrypto unrealized method...");
    }

    @Override
    public byte[] ecdhAgreement(byte[] priKey, byte[] pubKey) throws CryptoException {
        throw new CryptoException("CardCrypto unrealized method...");
    }

    @Override
    public int hsmCreateFile(String fileName, int maxLength) throws CryptoException {
        throw new CryptoException("CardCrypto unrealized method...");
    }

    @Override
    public byte[] hsmReadFile(String fileName, int startPosition, int readLength) throws CryptoException {
        throw new CryptoException("CardCrypto unrealized method...");
    }

    @Override
    public int hsmWriteFile(String fileName, int startPosition, byte[] data) throws CryptoException {
        throw new CryptoException("CardCrypto unrealized method...");
    }

    @Override
    public int hsmDeleteFile(String fileName) throws CryptoException {
        throw new CryptoException("CardCrypto unrealized method...");
    }
}

