/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.devicev4.crypto_hsm.sds.cmd.hsm;

import com.sansec.devicev4.api.CryptoException;
import com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket.NetCommunication;
import com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket.bean.Request;
import com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket.bean.Response;
import com.sansec.devicev4.gb.GBErrorCode_SDR;
import com.sansec.devicev4.gb.struct.key.ByteKeyPair;
import com.sansec.devicev4.gb.struct.key.IDSArefPrivateKey;
import com.sansec.devicev4.gb.struct.key.IDSArefPublicKey;
import com.sansec.devicev4.gb.struct.key.IRSArefPrivateKey;
import com.sansec.devicev4.gb.struct.key.IRSArefPublicKey;
import com.sansec.devicev4.gb.struct.key.dsa.DSArefSignature;
import com.sansec.devicev4.gb.struct.key.ecdsa.ECDSArefPrivateKey;
import com.sansec.devicev4.gb.struct.key.ecdsa.ECDSArefPublicKey;
import com.sansec.devicev4.gb.struct.key.ecdsa.ECDSArefSignature;
import com.sansec.devicev4.gb.struct.key.sm2.SM2refCipher;
import com.sansec.devicev4.gb.struct.key.sm2.SM2refPrivateKey;
import com.sansec.devicev4.gb.struct.key.sm2.SM2refPublicKey;
import com.sansec.devicev4.gb.struct.key.sm2.SM2refSignature;
import com.sansec.devicev4.log.CryptoLogger;
import com.sansec.devicev4.util.BytesUtil;
import java.io.ByteArrayOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HSMCmd {
    static Logger logger = CryptoLogger.logger;

    private static byte[] getBytes(byte[] bytesResponse, int offset, int length) {
        return BytesUtil.subbytes(bytesResponse, offset, length);
    }

    private static Response communicate(Request request) throws CryptoException {
        NetCommunication net = new NetCommunication();
        return net.socketCommunication(request);
    }

    public static byte[] getDeviceInfo() throws CryptoException {
        logger.info("-> HSMCmd.getDeviceInfo()...");
        Request request = new Request(131073);
        logger.fine("=> Request:" + request.toString());
        Response response = HSMCmd.communicate(request);
        logger.fine("=> Response:" + response.toString());
        if (response.getErrorCode() != 0) {
            throw new CryptoException("getDeviceInfo error," + response.getErrorInfo() + "[0x" + Integer.toHexString(response.getErrorCode()) + "].");
        }
        int infoLen = BytesUtil.bytes2int(response.getData());
        byte[] info = HSMCmd.getBytes(response.getData(), 4, infoLen);
        logger.info("-> HSMCmd.getDeviceInfo() end");
        return info;
    }

    public static byte[] generateRandom(int length) throws CryptoException {
        logger.info("-> HSMCmd.generateRandom()...");
        logger.fine("=> length:" + length);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(BytesUtil.int2bytes(length));
        }
        catch (Exception e) {
            throw new CryptoException("Transform(int2bytes) length error.", e);
        }
        byte[] param = out.toByteArray();
        Request request = new Request(131074, param);
        logger.fine("=> Request:" + request.toString());
        Response response = HSMCmd.communicate(request);
        logger.fine("=> Response:" + response.toString());
        if (response.getErrorCode() != 0) {
            throw new CryptoException("generateRandom error," + response.getErrorInfo() + "[0x" + Integer.toHexString(response.getErrorCode()) + "].");
        }
        int rndLen = BytesUtil.bytes2int(response.getData());
        byte[] rnd = HSMCmd.getBytes(response.getData(), 4, rndLen);
        logger.info("-> HSMCmd.generateRandom() end");
        return rnd;
    }

    public static byte[] generateHMAC(int algId, int keyIndex, byte[] key, byte[] input) throws CryptoException {
        logger.info("-> HSMCmd.generateHMAC()...");
        logger.fine("=> algId=" + algId);
        logger.fine("=> keyIndex=" + keyIndex);
        logger.fine("=> key=" + (key == null ? "null" : BytesUtil.hexEncode(key)));
        logger.fine("=> input=" + BytesUtil.hexEncode(input));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(BytesUtil.int2bytes(algId));
            if (key == null) {
                out.write(BytesUtil.int2bytes(1));
                out.write(BytesUtil.int2bytes(keyIndex));
                out.write(BytesUtil.int2bytes(0));
            } else {
                out.write(BytesUtil.int2bytes(0));
                out.write(BytesUtil.int2bytes(0));
                out.write(BytesUtil.int2bytes(key.length));
                out.write(key);
            }
            out.write(BytesUtil.int2bytes(input.length));
            out.write(input);
        }
        catch (Exception e) {
            throw new CryptoException("Transform(int2bytes) length error.", e);
        }
        byte[] param = out.toByteArray();
        Request request = new Request(0x200010, param);
        logger.fine("=> Request:" + request.toString());
        Response response = HSMCmd.communicate(request);
        logger.fine("=> Response:" + response.toString());
        if (response.getErrorCode() != 0) {
            throw new CryptoException("generateRSAKeyPairEx error," + response.getErrorInfo() + "[0x" + Integer.toHexString(response.getErrorCode()) + "].");
        }
        int dataLength = BytesUtil.bytes2int(response.getData());
        byte[] dataOutput = HSMCmd.getBytes(response.getData(), 4, dataLength);
        logger.info("-> HSMCmd.generateHMAC() end");
        return dataOutput;
    }

    public static ByteKeyPair generateRSAKeyPairEx(int keyBits, int exponent) throws CryptoException {
        logger.info("-> HSMCmd.generateRSAKeyPairEx()...");
        logger.fine("=> keyBits=" + keyBits);
        logger.fine("=> exponent=" + exponent);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(BytesUtil.int2bytes(65536));
            out.write(BytesUtil.int2bytes(keyBits));
            out.write(BytesUtil.int2bytes(0));
            out.write(BytesUtil.int2bytes(exponent));
            out.write(BytesUtil.int2bytes(0));
            out.write(BytesUtil.int2bytes(0));
            out.write(BytesUtil.int2bytes(0));
            out.write(BytesUtil.int2bytes(0));
            out.write(BytesUtil.int2bytes(0));
        }
        catch (Exception e) {
            throw new CryptoException("Transform(int2bytes) length error.", e);
        }
        byte[] param = out.toByteArray();
        Request request = new Request(262164, param);
        logger.fine("=> Request:" + request.toString());
        Response response = HSMCmd.communicate(request);
        logger.fine("=> Response:" + response.toString());
        if (response.getErrorCode() != 0) {
            throw new CryptoException("generateRSAKeyPairEx error," + response.getErrorInfo() + "[0x" + Integer.toHexString(response.getErrorCode()) + "].");
        }
        int pubKeyLen = BytesUtil.bytes2int(response.getData());
        byte[] pubKeyData = HSMCmd.getBytes(response.getData(), 4, pubKeyLen);
        int priKeyLen = BytesUtil.bytes2int(response.getData(), 4 + pubKeyLen);
        byte[] priKeyData = HSMCmd.getBytes(response.getData(), 4 + pubKeyLen + 4, priKeyLen);
        if (logger.isLoggable(Level.FINEST)) {
            logger.fine("<= pubKeyLen=" + pubKeyLen);
            logger.fine("<= pubKeyData=" + BytesUtil.hexEncode(pubKeyData));
            logger.fine("<= priKeyLen=" + priKeyLen);
            logger.fine("<= priKeyData=" + BytesUtil.hexEncode(priKeyData));
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("-> HSMCmd.generateRSAKeyPairEx() end");
        }
        return new ByteKeyPair(pubKeyData, priKeyData);
    }

    public static byte[] exportPublicKey(int keyIndex, int kpTypeCode) throws CryptoException {
        logger.info("-> HSMCmd.exportPublicKey()...");
        logger.fine("=> keyIndex:" + keyIndex);
        logger.fine("=> kpTypeCode:" + kpTypeCode);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(BytesUtil.int2bytes(keyIndex));
            out.write(BytesUtil.int2bytes(kpTypeCode));
        }
        catch (Exception e) {
            throw new CryptoException("Transform(int2bytes) parameter error.", e);
        }
        byte[] param = out.toByteArray();
        Request request = new Request(262145, param);
        logger.fine("=> Request:" + request.toString());
        Response response = HSMCmd.communicate(request);
        logger.fine("=> Response:" + response.toString());
        if (response.getErrorCode() != 0) {
            throw new CryptoException("exportPublicKey error," + response.getErrorInfo() + "[0x" + Integer.toHexString(response.getErrorCode()) + "].");
        }
        int pubKeyLen = BytesUtil.bytes2int(response.getData());
        byte[] pubKeyData = HSMCmd.getBytes(response.getData(), 4, pubKeyLen);
        logger.info("-> HSMCmd.exportPublicKey() end");
        return pubKeyData;
    }

    public static ByteKeyPair generateKeyPair(int keyBits, int keyPairTypeCode) throws CryptoException {
        logger.info("-> HSMCmd.generateKeyPair()...");
        logger.fine("=> keyBits=" + keyBits);
        logger.fine("=> kpTypeCode=" + keyPairTypeCode);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(BytesUtil.int2bytes(keyPairTypeCode));
            out.write(BytesUtil.int2bytes(keyBits));
        }
        catch (Exception e) {
            throw new CryptoException("Transform(int2bytes) parameter error.", e);
        }
        byte[] param = out.toByteArray();
        Request request = new Request(262146, param);
        logger.fine("=> Request:" + request.toString());
        Response response = HSMCmd.communicate(request);
        logger.fine("=> Response:" + response.toString());
        if (response.getErrorCode() != 0) {
            throw new CryptoException("generateKeyPair error," + response.getErrorInfo() + "[0x" + Integer.toHexString(response.getErrorCode()) + "].");
        }
        int pubKeyLen = BytesUtil.bytes2int(response.getData());
        byte[] pubKeyData = HSMCmd.getBytes(response.getData(), 4, pubKeyLen);
        int priKeyLen = BytesUtil.bytes2int(response.getData(), 4 + pubKeyLen);
        byte[] priKeyData = HSMCmd.getBytes(response.getData(), 4 + pubKeyLen + 4, priKeyLen);
        logger.info("-> HSMCmd.generateKeyPair() end");
        return new ByteKeyPair(pubKeyData, priKeyData);
    }

    public static void generateKeyPair(int keyBits, int kpTypeCode, int keyIndex) throws CryptoException {
        logger.info("-> HSMCmd.generateKeyPair()...");
        logger.fine("=> keyBits=" + keyBits);
        logger.fine("=> kpTypeCode=" + kpTypeCode);
        logger.fine("=> keyIndex=" + keyIndex);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(BytesUtil.int2bytes(kpTypeCode));
            out.write(BytesUtil.int2bytes(keyBits));
            out.write(BytesUtil.int2bytes(keyIndex));
        }
        catch (Exception e) {
            throw new CryptoException("Transform(int2bytes) parameter error.", e);
        }
        byte[] param = out.toByteArray();
        Request request = new Request(262158, param);
        logger.fine("=> Request:" + request.toString());
        Response response = HSMCmd.communicate(request);
        logger.fine("=> Response:" + response.toString());
        if (response.getErrorCode() != 0) {
            throw new CryptoException("generateKeyPair error," + response.getErrorInfo() + "[0x" + Integer.toHexString(response.getErrorCode()) + "].");
        }
        logger.info("-> HSMCmd.generateKeyPair() end");
    }

    public static void generateKey(int keyBits, int keyIndex) throws CryptoException {
        logger.info("-> HSMCmd.generateKey()...");
        logger.fine("=> keyBits=" + keyBits);
        logger.fine("=> keyIndex=" + keyIndex);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(BytesUtil.int2bytes(keyIndex));
            out.write(BytesUtil.int2bytes((keyBits + 7) / 8));
        }
        catch (Exception e) {
            throw new CryptoException("Transform(int2bytes) parameter error.", e);
        }
        byte[] param = out.toByteArray();
        Request request = new Request(262161, param);
        logger.fine("=> Request:" + request.toString());
        Response response = HSMCmd.communicate(request);
        logger.fine("=> Response:" + response.toString());
        if (response.getErrorCode() != 0) {
            throw new CryptoException("generateKey error," + response.getErrorInfo() + "[0x" + Integer.toHexString(response.getErrorCode()) + "].");
        }
        logger.info("-> HSMCmd.generateKey() end");
    }

    public static byte[] rsaPublicKeyOperation(int keyIndex, int keyUsage, IRSArefPublicKey publicKey, byte[] dataInput) throws CryptoException {
        logger.info("-> HSMCmd.rsaPublicKeyOperation()...");
        logger.fine("=> keyIndex=" + keyIndex);
        logger.fine("=> keyUsage=" + keyUsage);
        logger.fine("=> publicKey=" + (publicKey == null ? "null" : BytesUtil.bytes2hex(publicKey.encode())));
        logger.fine("=> dataInput=" + BytesUtil.bytes2hex(dataInput));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(BytesUtil.int2bytes(keyIndex));
            out.write(BytesUtil.int2bytes(keyUsage));
            out.write(BytesUtil.int2bytes(0));
            if (publicKey == null) {
                out.write(BytesUtil.int2bytes(0));
            } else {
                out.write(BytesUtil.int2bytes(publicKey.size()));
                out.write(publicKey.encode());
            }
            out.write(BytesUtil.int2bytes(dataInput.length));
            out.write(dataInput);
        }
        catch (Exception e) {
            throw new CryptoException("Transform(int2bytes) parameter error.", e);
        }
        byte[] param = out.toByteArray();
        Request request = new Request(524289, param);
        logger.fine("=> Request:" + request.toString());
        Response response = HSMCmd.communicate(request);
        logger.fine("=> Response:" + response.toString());
        if (response.getErrorCode() != 0) {
            throw new CryptoException("rsaPublicKeyOperation error," + response.getErrorInfo() + "[0x" + Integer.toHexString(response.getErrorCode()) + "].");
        }
        int dataLen = BytesUtil.bytes2int(response.getData());
        byte[] dataOutput = HSMCmd.getBytes(response.getData(), 4, dataLen);
        logger.info("-> HSMCmd.rsaPublicKeyOperation() end");
        return dataOutput;
    }

    public static byte[] rsaPrivateKeyOperation(int keyIndex, int keyUsage, IRSArefPrivateKey privateKey, byte[] input) throws CryptoException {
        logger.info("-> HSMCmd.rsaPrivateKeyOperation()...");
        logger.fine("=> keyIndex=" + keyIndex);
        logger.fine("=> keyUsage=" + keyUsage);
        logger.fine("=> privateKey=" + (privateKey == null ? "null" : BytesUtil.bytes2hex(privateKey.encode())));
        logger.fine("=> input=" + BytesUtil.bytes2hex(input));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(BytesUtil.int2bytes(keyIndex));
            out.write(BytesUtil.int2bytes(keyUsage));
            out.write(BytesUtil.int2bytes(0));
            if (privateKey == null) {
                out.write(BytesUtil.int2bytes(0));
            } else {
                out.write(BytesUtil.int2bytes(privateKey.size()));
                out.write(privateKey.encode());
            }
            out.write(BytesUtil.int2bytes(input.length));
            out.write(input);
        }
        catch (Exception e) {
            throw new CryptoException("Transform(int2bytes) parameter error.", e);
        }
        byte[] param = out.toByteArray();
        Request request = new Request(524290, param);
        logger.fine("=> Request:" + request.toString());
        Response response = HSMCmd.communicate(request);
        logger.fine("=> Response:" + response.toString());
        if (response.getErrorCode() != 0) {
            throw new CryptoException("rsaPrivateKeyOperation error," + response.getErrorInfo() + "[0x" + Integer.toHexString(response.getErrorCode()) + "].");
        }
        int dataLen = BytesUtil.bytes2int(response.getData());
        byte[] dataOutput = HSMCmd.getBytes(response.getData(), 4, dataLen);
        logger.info("-> HSMCmd.rsaPrivateKeyOperation() end");
        return dataOutput;
    }

    public static SM2refCipher sm2Encrypt(int keyUsage, int keyIndex, SM2refPublicKey publicKey, byte[] dataInput) throws CryptoException {
        logger.info("-> HSMCmd.sm2Encrypt()...");
        logger.fine("=> keyIndex=" + keyIndex);
        logger.fine("=> keyUsage=" + keyUsage);
        logger.fine("=> publicKey=" + (publicKey == null ? "null" : BytesUtil.bytes2hex(publicKey.encode())));
        logger.fine("=> dataInput=" + BytesUtil.bytes2hex(dataInput));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(BytesUtil.int2bytes(keyIndex));
            out.write(BytesUtil.int2bytes(keyUsage));
            out.write(BytesUtil.int2bytes(0));
            if (publicKey == null) {
                out.write(BytesUtil.int2bytes(0));
            } else {
                out.write(BytesUtil.int2bytes(publicKey.size()));
                out.write(publicKey.encode());
            }
            out.write(BytesUtil.int2bytes(dataInput.length));
            out.write(dataInput);
        }
        catch (Exception e) {
            throw new CryptoException("Transform(int2bytes) parameter error.", e);
        }
        byte[] param = out.toByteArray();
        Request request = new Request(524293, param);
        logger.fine("=> Request:" + request.toString());
        Response response = HSMCmd.communicate(request);
        logger.fine("=> Response:" + response.toString());
        if (response.getErrorCode() != 0) {
            throw new CryptoException("sm2Encrypt error," + response.getErrorInfo() + "[0x" + Integer.toHexString(response.getErrorCode()) + "].");
        }
        int dataLen = BytesUtil.bytes2int(response.getData());
        SM2refCipher refCipher = new SM2refCipher();
        byte[] bytes = HSMCmd.getBytes(response.getData(), 4, dataLen);
        refCipher.decode(bytes);
        if (refCipher.getCLength() != dataInput.length) {
            throw new RuntimeException();
        }
        logger.info("-> HSMCmd.sm2Encrypt() end");
        return refCipher;
    }

    public static byte[] sm2Decrypt(int keyUsage, int keyIndex, SM2refPrivateKey privateKey, SM2refCipher cipher) throws CryptoException {
        logger.info("-> HSMCmd.sm2Decrypt()...");
        logger.fine("=> keyIndex=" + keyIndex);
        logger.fine("=> keyUsage=" + keyUsage);
        logger.fine("=> privateKey=" + (privateKey == null ? "null" : BytesUtil.bytes2hex(privateKey.encode())));
        logger.fine("=> cipher=" + BytesUtil.bytes2hex(cipher.encode()));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(BytesUtil.int2bytes(keyIndex));
            out.write(BytesUtil.int2bytes(keyUsage));
            out.write(BytesUtil.int2bytes(0));
            if (privateKey == null) {
                out.write(BytesUtil.int2bytes(0));
            } else {
                out.write(BytesUtil.int2bytes(privateKey.size()));
                out.write(privateKey.encode());
            }
            out.write(BytesUtil.int2bytes(cipher.size()));
            out.write(cipher.encode());
        }
        catch (Exception e) {
            throw new CryptoException("Transform(int2bytes) parameter error.", e);
        }
        byte[] param = out.toByteArray();
        Request request = new Request(524294, param);
        logger.fine("=> Request:" + request.toString());
        Response response = HSMCmd.communicate(request);
        logger.fine("=> Response:" + response.toString());
        if (response.getErrorCode() != 0) {
            throw new CryptoException("sm2Decrypt error," + response.getErrorInfo() + "[0x" + Integer.toHexString(response.getErrorCode()) + "].");
        }
        int dataLength = BytesUtil.bytes2int(response.getData());
        byte[] dataOutput = HSMCmd.getBytes(response.getData(), 4, dataLength);
        logger.info("-> HSMCmd.sm2Decrypt() end");
        return dataOutput;
    }

    public static SM2refSignature sm2Sign(int keyUsage, int keyIndex, SM2refPrivateKey privateKey, byte[] hash) throws CryptoException {
        logger.info("-> HSMCmd.sm2Sign()...");
        logger.fine("=> keyIndex=" + keyIndex);
        logger.fine("=> keyUsage=" + keyUsage);
        logger.fine("=> privateKey=" + (privateKey == null ? "null" : BytesUtil.bytes2hex(privateKey.encode())));
        logger.fine("=> hash=" + BytesUtil.bytes2hex(hash));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(BytesUtil.int2bytes(keyIndex));
            out.write(BytesUtil.int2bytes(keyUsage));
            out.write(BytesUtil.int2bytes(0));
            if (privateKey == null) {
                out.write(BytesUtil.int2bytes(0));
            } else {
                out.write(BytesUtil.int2bytes(privateKey.size()));
                out.write(privateKey.encode());
            }
            out.write(BytesUtil.int2bytes(hash.length));
            out.write(hash);
        }
        catch (Exception e) {
            throw new CryptoException("Transform(int2bytes) parameter error.", e);
        }
        byte[] param = out.toByteArray();
        Request request = new Request(524291, param);
        logger.fine("=> Request:" + request.toString());
        Response response = HSMCmd.communicate(request);
        logger.fine("=> Response:" + response.toString());
        if (response.getErrorCode() != 0) {
            throw new CryptoException("sm2Sign error," + response.getErrorInfo() + "[0x" + Integer.toHexString(response.getErrorCode()) + "].");
        }
        int dataLen = BytesUtil.bytes2int(response.getData());
        byte[] data = HSMCmd.getBytes(response.getData(), 4, dataLen);
        SM2refSignature sigData = new SM2refSignature();
        sigData.decode(data);
        logger.info("-> HSMCmd.sm2Sign() end");
        return sigData;
    }

    public static boolean sm2Verify(int keyUsage, int keyIndex, SM2refPublicKey publicKey, byte[] hash, SM2refSignature sigData) throws CryptoException {
        logger.info("-> HSMCmd.sm2Verify()...");
        logger.fine("=> keyIndex=" + keyIndex);
        logger.fine("=> keyUsage=" + keyUsage);
        logger.fine("=> publicKey=" + (publicKey == null ? "null" : BytesUtil.bytes2hex(publicKey.encode())));
        logger.fine("=> sigData=" + BytesUtil.bytes2hex(sigData.encode()));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(BytesUtil.int2bytes(keyIndex));
            out.write(BytesUtil.int2bytes(keyUsage));
            out.write(BytesUtil.int2bytes(0));
            if (publicKey == null) {
                out.write(BytesUtil.int2bytes(0));
            } else {
                out.write(BytesUtil.int2bytes(publicKey.size()));
                out.write(publicKey.encode());
            }
            out.write(BytesUtil.int2bytes(hash.length));
            out.write(hash);
            out.write(BytesUtil.int2bytes(sigData.size()));
            out.write(sigData.encode());
        }
        catch (Exception e) {
            throw new CryptoException("Transform(int2bytes) parameter error.", e);
        }
        byte[] param = out.toByteArray();
        Request request = new Request(524292, param);
        logger.fine("=> Request:" + request.toString());
        Response response = HSMCmd.communicate(request);
        logger.fine("=> Response:" + response.toString());
        if (response.getErrorCode() != 0 || response.getErrorCode() == GBErrorCode_SDR.SDR_VERIFYERR) {
            throw new CryptoException("sm2Verify error," + response.getErrorInfo() + "[0x" + Integer.toHexString(response.getErrorCode()) + "].");
        }
        logger.info("-> HSMCmd.sm2Verify() end");
        return true;
    }

    public static ByteKeyPair generateECDSAKeyPair(int keyBits, int kpTypeCode, int curetype) throws CryptoException {
        logger.info("-> generateECDSAKeyPair()...");
        logger.fine("=> keyBits=" + keyBits);
        logger.fine("=> kpTypeCode=" + kpTypeCode);
        logger.fine("=> curetype=" + curetype);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (kpTypeCode != 524288) {
            throw new CryptoException("only support SGD_ECDSA");
        }
        try {
            out.write(BytesUtil.int2bytes(kpTypeCode));
            out.write(BytesUtil.int2bytes(keyBits));
            out.write(BytesUtil.int2bytes(curetype));
        }
        catch (Exception e) {
            throw new CryptoException("Transform(int2bytes) parameter error.", e);
        }
        byte[] param = out.toByteArray();
        Request request = new Request(262146, param);
        NetCommunication net = new NetCommunication();
        Response response = net.socketCommunication(request);
        if (response.getErrorCode() != 0) {
            throw new CryptoException(response.getErrorInfo());
        }
        int pubKeyLen = BytesUtil.bytes2int(response.getData());
        byte[] pubKeyData = HSMCmd.getBytes(response.getData(), 4, pubKeyLen);
        int priKeyLen = BytesUtil.bytes2int(response.getData(), 4 + pubKeyLen);
        byte[] priKeyData = HSMCmd.getBytes(response.getData(), 4 + pubKeyLen + 4, priKeyLen);
        ByteKeyPair byteKeyPair = new ByteKeyPair(pubKeyData, priKeyData);
        logger.fine("=> ECByteKeyPair=" + byteKeyPair);
        logger.info("<- generateECDSAKeyPair() end");
        return byteKeyPair;
    }

    public static ECDSArefSignature ecdsaSign(int keyUsage, int keyIndex, ECDSArefPrivateKey privateKey, byte[] hash) throws CryptoException {
        logger.info("-> ecdsaSign()...");
        logger.fine("=> keyUsage=" + keyUsage);
        logger.fine("=> keyIndex=" + keyIndex);
        logger.fine("=> privateKey=" + (privateKey == null ? "null" : BytesUtil.hexEncode(privateKey.encode())));
        logger.fine("=> hash=" + BytesUtil.hexEncode(hash));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(BytesUtil.int2bytes(keyIndex));
            out.write(BytesUtil.int2bytes(keyUsage));
            out.write(BytesUtil.int2bytes(0));
            if (privateKey == null) {
                out.write(BytesUtil.int2bytes(0));
            } else {
                out.write(BytesUtil.int2bytes(privateKey.size()));
                out.write(privateKey.encode());
            }
            out.write(BytesUtil.int2bytes(hash.length));
            out.write(hash);
        }
        catch (Exception e) {
            // empty catch block
        }
        byte[] param = out.toByteArray();
        Request request = new Request(524295, param);
        NetCommunication net = new NetCommunication();
        Response response = net.socketCommunication(request);
        if (response.getErrorCode() != 0) {
            throw new CryptoException("ECDSA Sign: " + response.getErrorInfo());
        }
        int dataLen = BytesUtil.bytes2int(response.getData());
        byte[] data = HSMCmd.getBytes(response.getData(), 4, dataLen);
        ECDSArefSignature sigData = new ECDSArefSignature();
        sigData.decode(data);
        logger.info("<- ecdsaSign() end");
        return sigData;
    }

    public static boolean ecdsaVerify(int keyUsage, int keyIndex, ECDSArefPublicKey publicKey, byte[] hash, ECDSArefSignature sigData) throws CryptoException {
        logger.info("-> ecdsaVerify()...");
        logger.fine("=> keyUsage=" + keyUsage);
        logger.fine("=> keyIndex=" + keyIndex);
        logger.fine("=> publicKey=" + (publicKey == null ? "null" : BytesUtil.hexEncode(publicKey.encode())));
        logger.fine("=> hash=" + BytesUtil.hexEncode(hash));
        logger.fine("=> sigData=" + BytesUtil.hexEncode(sigData.encode()));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(BytesUtil.int2bytes(keyIndex));
            out.write(BytesUtil.int2bytes(keyUsage));
            out.write(BytesUtil.int2bytes(0));
            if (publicKey == null) {
                out.write(BytesUtil.int2bytes(0));
            } else {
                out.write(BytesUtil.int2bytes(publicKey.size()));
                out.write(publicKey.encode());
            }
            out.write(BytesUtil.int2bytes(hash.length));
            out.write(hash);
            out.write(BytesUtil.int2bytes(sigData.size()));
            out.write(sigData.encode());
        }
        catch (Exception e) {
            // empty catch block
        }
        byte[] param = out.toByteArray();
        Request request = new Request(524296, param);
        NetCommunication net = new NetCommunication();
        Response response = net.socketCommunication(request);
        if (response.getErrorCode() != 0) {
            throw new CryptoException("ECDSA Verify: " + response.getErrorInfo());
        }
        logger.info("<- ecdsaVerify() end");
        return true;
    }

    public static DSArefSignature dsaSign(int keyUsage, int keyIndex, IDSArefPrivateKey privateKey, byte[] hash) throws CryptoException {
        logger.info("-> HSMCmd.dsaSign()...");
        logger.fine("=> keyIndex=" + keyIndex);
        logger.fine("=> keyUsage=" + keyUsage);
        logger.fine("=> privateKey=" + (privateKey == null ? "null" : BytesUtil.bytes2hex(privateKey.encode())));
        logger.fine("=> hash=" + BytesUtil.bytes2hex(hash));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(BytesUtil.int2bytes(keyIndex));
            out.write(BytesUtil.int2bytes(keyUsage));
            out.write(BytesUtil.int2bytes(0));
            if (privateKey == null) {
                out.write(BytesUtil.int2bytes(0));
            } else {
                out.write(BytesUtil.int2bytes(privateKey.size()));
                out.write(privateKey.encode());
            }
            out.write(BytesUtil.int2bytes(hash.length));
            out.write(hash);
        }
        catch (Exception e) {
            throw new CryptoException("Transform(int2bytes) parameter error.", e);
        }
        byte[] param = out.toByteArray();
        Request request = new Request(524298, param);
        logger.fine("=> Request:" + request.toString());
        Response response = HSMCmd.communicate(request);
        logger.fine("=> Response:" + response.toString());
        if (response.getErrorCode() != 0) {
            throw new CryptoException("dsaSign error," + response.getErrorInfo() + "[0x" + Integer.toHexString(response.getErrorCode()) + "].");
        }
        int dataLen = BytesUtil.bytes2int(response.getData());
        byte[] data = HSMCmd.getBytes(response.getData(), 4, dataLen);
        DSArefSignature sigData = new DSArefSignature();
        sigData.decode(data);
        logger.fine("=> sigData=" + sigData);
        logger.info("-> HSMCmd.dsaSign() end");
        return sigData;
    }

    public static boolean dsaVerify(int keyUsage, int keyIndex, IDSArefPublicKey publicKey, byte[] hash, DSArefSignature sigData) throws CryptoException {
        logger.info("-> dsaVerify()...");
        logger.fine("=> keyUsage=" + keyUsage);
        logger.fine("=> keyIndex=" + keyIndex);
        logger.fine("=> publicKey=" + (publicKey == null ? "null" : BytesUtil.hexEncode(publicKey.encode())));
        logger.fine("=> hash=" + BytesUtil.hexEncode(hash));
        logger.fine("=> sigData=" + BytesUtil.hexEncode(sigData.encode()));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(BytesUtil.int2bytes(keyIndex));
            out.write(BytesUtil.int2bytes(keyUsage));
            out.write(BytesUtil.int2bytes(0));
            if (publicKey == null) {
                out.write(BytesUtil.int2bytes(0));
            } else {
                out.write(BytesUtil.int2bytes(publicKey.size()));
                out.write(publicKey.encode());
            }
            out.write(BytesUtil.int2bytes(hash.length));
            out.write(hash);
            out.write(BytesUtil.int2bytes(sigData.size()));
            out.write(sigData.encode());
        }
        catch (Exception e) {
            // empty catch block
        }
        byte[] param = out.toByteArray();
        Request request = new Request(524299, param);
        NetCommunication net = new NetCommunication();
        Response response = net.socketCommunication(request);
        if (response.getErrorCode() != 0) {
            throw new CryptoException("DSA Verify: " + response.getErrorInfo());
        }
        logger.info("<- dsaVerify() end");
        return true;
    }

    public static byte[] encrypt(int algoType, int keyIndex, byte[] key, byte[] iv, byte[] dataInput) throws CryptoException {
        logger.info("-> HSMCmd.encrypt()...");
        logger.fine("=> algoType=" + algoType);
        logger.fine("=> keyIndex=" + keyIndex);
        logger.fine("=> key=" + (key == null ? "null" : BytesUtil.bytes2hex(key)));
        logger.fine("=> iv=" + (iv == null ? "null" : BytesUtil.bytes2hex(iv)));
        logger.fine("=> dataInput=" + BytesUtil.bytes2hex(dataInput));
        int type = 0;
        if (key == null) {
            type = 1;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(BytesUtil.int2bytes(algoType));
            out.write(BytesUtil.int2bytes(type));
            out.write(BytesUtil.int2bytes(keyIndex));
            if (key == null) {
                out.write(BytesUtil.int2bytes(0));
            } else {
                out.write(BytesUtil.int2bytes(key.length));
                out.write(key);
            }
            if (iv == null) {
                out.write(BytesUtil.int2bytes(0));
            } else {
                out.write(BytesUtil.int2bytes(iv.length));
                out.write(iv);
            }
            out.write(BytesUtil.int2bytes(dataInput.length));
            out.write(dataInput);
        }
        catch (Exception e) {
            throw new CryptoException("Transform(int2bytes) parameter error.", e);
        }
        byte[] param = out.toByteArray();
        Request request = new Request(0x100001, param);
        logger.fine("=> Request:" + request.toString());
        Response response = HSMCmd.communicate(request);
        logger.fine("=> Response:" + response.toString());
        if (response.getErrorCode() != 0) {
            throw new CryptoException("encrypt error," + response.getErrorInfo() + "[0x" + Integer.toHexString(response.getErrorCode()) + "].");
        }
        int dataLength = BytesUtil.bytes2int(response.getData());
        byte[] dataOutput = HSMCmd.getBytes(response.getData(), 4, dataLength);
        logger.info("-> HSMCmd.encrypt() end");
        return dataOutput;
    }

    public static byte[] decrypt(int algoType, int keyIndex, byte[] key, byte[] iv, byte[] dataInput) throws CryptoException {
        logger.info("-> HSMCmd.decrypt()...");
        logger.fine("=> algoType=" + algoType);
        logger.fine("=> keyIndex=" + keyIndex);
        logger.fine("=> key=" + (key == null ? "null" : BytesUtil.bytes2hex(key)));
        logger.fine("=> iv=" + (iv == null ? "null" : BytesUtil.bytes2hex(iv)));
        logger.fine("=> dataInput=" + BytesUtil.bytes2hex(dataInput));
        int type = 0;
        if (key == null) {
            type = 1;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(BytesUtil.int2bytes(algoType));
            out.write(BytesUtil.int2bytes(type));
            out.write(BytesUtil.int2bytes(keyIndex));
            if (key == null) {
                out.write(BytesUtil.int2bytes(0));
            } else {
                out.write(BytesUtil.int2bytes(key.length));
                out.write(key);
            }
            if (iv == null) {
                out.write(BytesUtil.int2bytes(0));
            } else {
                out.write(BytesUtil.int2bytes(iv.length));
                out.write(iv);
            }
            out.write(BytesUtil.int2bytes(dataInput.length));
            out.write(dataInput);
        }
        catch (Exception e) {
            throw new CryptoException("Transform(int2bytes) parameter error.", e);
        }
        byte[] param = out.toByteArray();
        Request request = new Request(0x100002, param);
        logger.fine("=> Request:" + request.toString());
        Response response = HSMCmd.communicate(request);
        logger.fine("=> Response:" + response.toString());
        if (response.getErrorCode() != 0) {
            throw new CryptoException("decrypt error," + response.getErrorInfo() + "[0x" + Integer.toHexString(response.getErrorCode()) + "].");
        }
        int dataLength = BytesUtil.bytes2int(response.getData());
        byte[] dataOutput = HSMCmd.getBytes(response.getData(), 4, dataLength);
        logger.info("-> HSMCmd.decrypt() end");
        return dataOutput;
    }

    public static byte[] encrypt_add(int algoType, int keyIndex, byte[] key, byte[] iv, byte[] dataInput, byte[] addInput) throws CryptoException {
        logger.info("-> HSMCmd.encrypt_add() ...");
        int type = 0;
        if (key == null) {
            type = 1;
        }
        if (algoType != 1088) {
            throw new CryptoException("Algorithm identification error");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(BytesUtil.int2bytes(algoType));
            out.write(BytesUtil.int2bytes(type));
            out.write(BytesUtil.int2bytes(keyIndex));
            if (key == null) {
                out.write(BytesUtil.int2bytes(0));
            } else {
                out.write(BytesUtil.int2bytes(key.length));
                out.write(key);
            }
            if (iv == null) {
                out.write(BytesUtil.int2bytes(0));
            } else {
                out.write(BytesUtil.int2bytes(iv.length));
                out.write(iv);
            }
            if (addInput == null || addInput.length == 0) {
                out.write(BytesUtil.int2bytes(0));
            } else {
                out.write(BytesUtil.int2bytes(addInput.length));
                out.write(addInput);
            }
            out.write(BytesUtil.int2bytes(dataInput.length));
            out.write(dataInput);
        }
        catch (Exception e) {
            throw new CryptoException("Transform(int2bytes) length error.", e);
        }
        byte[] param = out.toByteArray();
        Request request = new Request(0x100004, param);
        logger.fine("=> Request:" + request.toString());
        Response response = HSMCmd.communicate(request);
        logger.fine("=> Response:" + response.toString());
        if (response.getErrorCode() != 0) {
            throw new CryptoException("encrypt_add error," + response.getErrorInfo() + "[0x" + Integer.toHexString(response.getErrorCode()) + "].");
        }
        byte[] tempData = response.getData();
        byte[] returnData = new byte[tempData.length - 8];
        byte[] tempData1 = new byte[4];
        int dataLength = BytesUtil.bytes2int(response.getData());
        System.arraycopy(tempData, 4, returnData, 0, dataLength);
        System.arraycopy(tempData, 4 + dataLength, tempData1, 0, 4);
        int macLength = BytesUtil.bytes2int(tempData1);
        System.arraycopy(tempData, 8 + dataLength, returnData, dataLength, macLength);
        logger.info("-> HSMCmd.encrypt_add() end");
        return returnData;
    }

    public static byte[] decrypt_add(int algoType, int keyIndex, byte[] key, byte[] iv, byte[] dataInput, byte[] addInput) throws CryptoException {
        logger.info("-> HSMCmd.decrypt_add() ...");
        int type = 0;
        if (key == null) {
            type = 1;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(BytesUtil.int2bytes(algoType));
            out.write(BytesUtil.int2bytes(type));
            out.write(BytesUtil.int2bytes(keyIndex));
            if (key == null) {
                out.write(BytesUtil.int2bytes(0));
            } else {
                out.write(BytesUtil.int2bytes(key.length));
                out.write(key);
            }
            if (iv == null) {
                out.write(BytesUtil.int2bytes(0));
            } else {
                out.write(BytesUtil.int2bytes(iv.length));
                out.write(iv);
            }
            if (addInput == null || addInput.length == 0) {
                out.write(BytesUtil.int2bytes(0));
            } else {
                out.write(BytesUtil.int2bytes(addInput.length));
                out.write(addInput);
            }
            byte[] macData = new byte[16];
            byte[] encData = new byte[dataInput.length - 16];
            System.arraycopy(dataInput, 0, encData, 0, encData.length);
            System.arraycopy(dataInput, encData.length, macData, 0, macData.length);
            out.write(BytesUtil.int2bytes(macData.length));
            out.write(macData);
            out.write(BytesUtil.int2bytes(encData.length));
            out.write(encData);
        }
        catch (Exception e) {
            throw new CryptoException("Transform(int2bytes) length error.", e);
        }
        byte[] param = out.toByteArray();
        Request request = new Request(0x100005, param);
        logger.fine("=> Request:" + request.toString());
        Response response = HSMCmd.communicate(request);
        logger.fine("=> Response:" + response.toString());
        if (response.getErrorCode() != 0) {
            throw new CryptoException("encrypt_add error," + response.getErrorInfo() + "[0x" + Integer.toHexString(response.getErrorCode()) + "].");
        }
        byte[] tempData = response.getData();
        byte[] macCode = new byte[4];
        byte[] tempLenData = new byte[4];
        System.arraycopy(tempData, 0, macCode, 0, macCode.length);
        System.arraycopy(tempData, 4, tempLenData, 0, tempLenData.length);
        int macCheckCode = BytesUtil.bytes2int(macCode);
        if (macCheckCode != 0) {
            return null;
        }
        int dataLength = BytesUtil.bytes2int(tempLenData);
        byte[] dataOutput = HSMCmd.getBytes(tempData, 8, dataLength);
        logger.info("-> HSMCmd.decrypt_add() end");
        return dataOutput;
    }

    public static void importKeyPair(int algoType, int keyIndex, int keysize, byte[] pubkey, byte[] prikey) throws CryptoException {
        logger.info("-> HSMCmd.importKeyPair()...");
        logger.fine("=> algoType=" + algoType);
        logger.fine("=> keyIndex=" + keyIndex);
        logger.fine("=> keysize=" + keysize);
        logger.fine("=> pubkey=" + BytesUtil.bytes2hex(pubkey));
        logger.fine("=> prikey=" + BytesUtil.bytes2hex(prikey));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(BytesUtil.int2bytes(algoType));
            out.write(BytesUtil.int2bytes(keysize));
            out.write(BytesUtil.int2bytes(keyIndex));
            out.write(BytesUtil.int2bytes(pubkey.length));
            out.write(pubkey);
            out.write(BytesUtil.int2bytes(prikey.length));
            out.write(prikey);
        }
        catch (Exception e) {
            throw new CryptoException("Transform(int2bytes) parameter error.", e);
        }
        byte[] param = out.toByteArray();
        Request request = new Request(262159, param);
        logger.fine("=> Request:" + request.toString());
        Response response = HSMCmd.communicate(request);
        logger.fine("=> Response:" + response.toString());
        if (response.getErrorCode() != 0) {
            throw new CryptoException("importKeyPair error," + response.getErrorInfo() + "[0x" + Integer.toHexString(response.getErrorCode()) + "].");
        }
        logger.info("-> HSMCmd.importKeyPair() end");
    }

    public static int[] getKeyStatus(int keyType) throws CryptoException {
        logger.info("-> HSMCmd.getKeyStatus()...");
        logger.fine("=> keyType=" + keyType);
        byte[] reqParams = BytesUtil.int2bytes(keyType);
        Request request = new Request(131077, reqParams);
        logger.fine("=> Request:" + request.toString());
        Response response = HSMCmd.communicate(request);
        logger.fine("=> Response:" + response.toString());
        if (response.getErrorCode() != 0) {
            throw new CryptoException("getKeyStatus error," + response.getErrorInfo() + "[0x" + Integer.toHexString(response.getErrorCode()) + "].");
        }
        byte[] bstatus = new byte[4];
        int index = 0;
        byte[] buffer = response.getData();
        int len = buffer.length;
        int statusLen = BytesUtil.bytes2int(buffer);
        int[] status = new int[statusLen];
        int i = 4;
        while (i < len) {
            int j = i;
            int n = 0;
            while (j < i + 4) {
                bstatus[n] = buffer[j];
                ++j;
                ++n;
            }
            status[index] = BytesUtil.bytes2int(bstatus);
            i += 4;
            ++index;
        }
        logger.info("-> HSMCmd.getKeyStatus() end");
        return status;
    }

    public static void inputKEK(int keyIndex, byte[] key) throws CryptoException {
        logger.info("-> HSMCmd.inputKEK()...");
        logger.fine("=> keyIndex=" + keyIndex);
        logger.fine("=> key=" + BytesUtil.bytes2hex(key));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(BytesUtil.int2bytes(keyIndex));
            out.write(BytesUtil.int2bytes(key.length));
            out.write(key);
        }
        catch (Exception e) {
            throw new CryptoException("Transform(int2bytes) parameter error.", e);
        }
        byte[] param = out.toByteArray();
        Request request = new Request(262162, param);
        logger.fine("=> Request:" + request.toString());
        Response response = HSMCmd.communicate(request);
        logger.fine("=> Response:" + response.toString());
        if (response.getErrorCode() != 0) {
            throw new CryptoException("inputKEK error," + response.getErrorInfo() + "[0x" + Integer.toHexString(response.getErrorCode()) + "].");
        }
        logger.info("-> HSMCmd.inputKEK() end");
    }

    public static void importEnvelopedKeyPair_ECC(int keyIndex, int keyType, int keyPriKeyIndex, int encAlg, byte[] eccPairEnvelopedKey) throws CryptoException {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("-> importEnvelopedKeyPair_ECC()...");
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("=> keyIndex=" + keyIndex);
            logger.finest("=> keyType=" + keyType);
            logger.finest("=> keyPriKeyIndex=" + keyPriKeyIndex);
            logger.finest("=> encAlg=" + encAlg);
            logger.finest("=> eccPairEnvelopedKey=" + BytesUtil.hexEncode(eccPairEnvelopedKey));
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(BytesUtil.int2bytes(encAlg));
            out.write(BytesUtil.int2bytes(keyPriKeyIndex));
            out.write(BytesUtil.int2bytes(keyType));
            out.write(BytesUtil.int2bytes(keyIndex));
            out.write(BytesUtil.int2bytes(eccPairEnvelopedKey.length));
            out.write(eccPairEnvelopedKey);
        }
        catch (Exception e) {
            // empty catch block
        }
        byte[] param = out.toByteArray();
        Request request = new Request(524300, param);
        NetCommunication net = new NetCommunication();
        Response response = net.socketCommunication(request);
        if (response.getErrorCode() != 0) {
            throw new CryptoException(response.getErrorInfo());
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("<- importKeyPair() end");
        }
    }

    public static byte[] genPBKDF2Key(int hashAlg, int iteraCount, int outLength, byte[] pwd, byte[] salt) throws CryptoException {
        logger.info("-> HSMCmd.genPBKDF2Key()...");
        logger.fine("=> hashAlg=" + hashAlg);
        logger.fine("=> iteraCount=" + iteraCount);
        logger.fine("=> outLength=" + outLength);
        logger.fine("=> pwd=" + BytesUtil.bytes2hex(pwd));
        logger.fine("=> salt=" + BytesUtil.bytes2hex(salt));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(BytesUtil.int2bytes(hashAlg));
            out.write(BytesUtil.int2bytes(iteraCount));
            out.write(BytesUtil.int2bytes(outLength));
            out.write(BytesUtil.int2bytes(pwd.length));
            out.write(pwd);
            out.write(BytesUtil.int2bytes(salt.length));
            out.write(salt);
        }
        catch (Exception e) {
            throw new CryptoException("Transform(int2bytes) parameter error.", e);
        }
        byte[] param = out.toByteArray();
        Request request = new Request(0x200011, param);
        logger.fine("=> Request:" + request.toString());
        Response response = HSMCmd.communicate(request);
        logger.fine("=> Response:" + response.toString());
        if (response.getErrorCode() != 0) {
            throw new CryptoException("inputKEK error," + response.getErrorInfo() + "[0x" + Integer.toHexString(response.getErrorCode()) + "].");
        }
        int dataLength = BytesUtil.bytes2int(response.getData());
        byte[] dataOutput = HSMCmd.getBytes(response.getData(), 4, dataLength);
        logger.info("-> HSMCmd.genPBKDF2Key() end");
        return dataOutput;
    }

    public static byte[] genPBKDF2KeyExt(int hashAlg, int iteraCount, int outLength, byte[] pwd, byte[] salt, int keyIndex) throws CryptoException {
        logger.info("-> HSMCmd.genPBKDF2Key()...");
        logger.fine("=> hashAlg=" + hashAlg);
        logger.fine("=> iteraCount=" + iteraCount);
        logger.fine("=> outLength=" + outLength);
        logger.fine("=> pwd=" + BytesUtil.bytes2hex(pwd));
        logger.fine("=> salt=" + BytesUtil.bytes2hex(salt));
        logger.fine("=> keyIndex=" + keyIndex);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(BytesUtil.int2bytes(hashAlg));
            out.write(BytesUtil.int2bytes(iteraCount));
            out.write(BytesUtil.int2bytes(outLength));
            out.write(BytesUtil.int2bytes(pwd.length));
            out.write(pwd);
            out.write(BytesUtil.int2bytes(salt.length));
            out.write(salt);
            out.write(BytesUtil.int2bytes(keyIndex));
        }
        catch (Exception e) {
            throw new CryptoException("Transform(int2bytes) parameter error.", e);
        }
        byte[] param = out.toByteArray();
        Request request = new Request(0x200012, param);
        logger.fine("=> Request:" + request.toString());
        Response response = HSMCmd.communicate(request);
        logger.fine("=> Response:" + response.toString());
        if (response.getErrorCode() != 0) {
            throw new CryptoException("inputKEK error," + response.getErrorInfo() + "[0x" + Integer.toHexString(response.getErrorCode()) + "].");
        }
        int dataLength = BytesUtil.bytes2int(response.getData());
        byte[] dataOutput = HSMCmd.getBytes(response.getData(), 4, dataLength);
        logger.info("-> HSMCmd.genPBKDF2Key() end");
        return dataOutput;
    }

    public static byte[] ecdhAgreement(int ecdsIndex, int keyType, byte[] pubKey) throws CryptoException {
        logger.info("-> HSMCmd.ecdhAgreement()...");
        logger.fine("=> ecdsIndex=" + ecdsIndex);
        logger.fine("=> keyType=" + keyType);
        logger.fine("=> pubKey=" + BytesUtil.bytes2hex(pubKey));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(BytesUtil.int2bytes(ecdsIndex));
            out.write(BytesUtil.int2bytes(keyType));
            out.write(BytesUtil.int2bytes(0));
            out.write(BytesUtil.int2bytes(pubKey.length));
            out.write(pubKey);
        }
        catch (Exception e) {
            throw new CryptoException("Transform(int2bytes) parameter error.", e);
        }
        byte[] param = out.toByteArray();
        Request request = new Request(524297, param);
        logger.fine("=> Request:" + request.toString());
        Response response = HSMCmd.communicate(request);
        logger.fine("=> Response:" + response.toString());
        if (response.getErrorCode() != 0) {
            throw new CryptoException("inputKEK error," + response.getErrorInfo() + "[0x" + Integer.toHexString(response.getErrorCode()) + "].");
        }
        int dataLength = BytesUtil.bytes2int(response.getData());
        byte[] dataOutput = HSMCmd.getBytes(response.getData(), 4, dataLength);
        logger.info("-> HSMCmd.ecdhAgreement() end");
        return dataOutput;
    }

    public static byte[] ecdhAgreement(byte[] priKey, byte[] pubKey) throws CryptoException {
        logger.info("-> HSMCmd.ecdhAgreement()...");
        logger.fine("=> pwd=" + BytesUtil.bytes2hex(priKey));
        logger.fine("=> salt=" + BytesUtil.bytes2hex(pubKey));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(BytesUtil.int2bytes(0));
            out.write(BytesUtil.int2bytes(524544));
            out.write(BytesUtil.int2bytes(priKey.length));
            out.write(priKey);
            out.write(BytesUtil.int2bytes(pubKey.length));
            out.write(pubKey);
        }
        catch (Exception e) {
            throw new CryptoException("Transform(int2bytes) parameter error.", e);
        }
        byte[] param = out.toByteArray();
        Request request = new Request(524297, param);
        logger.fine("=> Request:" + request.toString());
        Response response = HSMCmd.communicate(request);
        logger.fine("=> Response:" + response.toString());
        if (response.getErrorCode() != 0) {
            throw new CryptoException("inputKEK error," + response.getErrorInfo() + "[0x" + Integer.toHexString(response.getErrorCode()) + "].");
        }
        int dataLength = BytesUtil.bytes2int(response.getData());
        byte[] dataOutput = HSMCmd.getBytes(response.getData(), 4, dataLength);
        logger.info("-> HSMCmd.ecdhAgreement() end");
        return dataOutput;
    }

    public static int hsmCreateFile(String fileName, int maxLength) throws CryptoException {
        logger.info("SDSCmd:hsmCreateFile(String  fileName, int  maxLength)......");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (fileName.length() > 128) {
            throw new CryptoException("hsmCreateFile, Error:fileName too lang, length= " + fileName.length());
        }
        try {
            out.write(BytesUtil.int2bytes(maxLength));
            out.write(BytesUtil.int2bytes(0));
            out.write(BytesUtil.int2bytes(fileName.length() + 1));
            out.write(fileName.getBytes());
            out.write(0);
        }
        catch (Exception e) {
            // empty catch block
        }
        byte[] param = out.toByteArray();
        Request request = new Request(0x400001, param);
        NetCommunication net = new NetCommunication();
        Response response = net.socketCommunication(request);
        if (response.getErrorCode() != 0) {
            throw new CryptoException("hsmCreateFile, ErrorCode:" + response.getErrorInfo());
        }
        return 0;
    }

    public static byte[] hsmReadFile(String fileName, int startPosition, int readLength) throws CryptoException {
        logger.info("SDSCmd:hsmReadFile(String  fileName, int startPosition, int  readLength)......");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (fileName.length() > 128) {
            throw new CryptoException("hsmReadFile, Error:fileName too lang, length= " + fileName.length());
        }
        try {
            out.write(BytesUtil.int2bytes(startPosition));
            out.write(BytesUtil.int2bytes(readLength));
            out.write(BytesUtil.int2bytes(fileName.length() + 1));
            out.write(fileName.getBytes());
            out.write(0);
        }
        catch (Exception e) {
            // empty catch block
        }
        byte[] param = out.toByteArray();
        Request request = new Request(0x400002, param);
        NetCommunication net = new NetCommunication();
        Response response = net.socketCommunication(request);
        if (response.getErrorCode() != 0) {
            throw new CryptoException("hsmReadFile, ErrorCode:" + response.getErrorInfo());
        }
        int dataLen = BytesUtil.bytes2int(response.getData());
        if (dataLen == 0) {
            return null;
        }
        byte[] data = HSMCmd.getBytes(response.getData(), 4, dataLen);
        return data;
    }

    public static int hsmWriteFile(String fileName, int startPosition, byte[] data) throws CryptoException {
        logger.info("SDSCmd:hsmWriteFile(String  fileName, int startPosition, byte[] data)......");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (fileName.length() > 128) {
            throw new CryptoException("hsmWriteFile, Error:fileName too lang, length= " + fileName.length());
        }
        try {
            out.write(BytesUtil.int2bytes(startPosition));
            out.write(BytesUtil.int2bytes(fileName.length() + 1));
            out.write(fileName.getBytes());
            out.write(0);
            out.write(BytesUtil.int2bytes(data.length));
            out.write(data);
        }
        catch (Exception e) {
            // empty catch block
        }
        byte[] param = out.toByteArray();
        Request request = new Request(0x400003, param);
        NetCommunication net = new NetCommunication();
        Response response = net.socketCommunication(request);
        if (response.getErrorCode() != 0) {
            throw new CryptoException("hsmWriteFile, ErrorCode:" + response.getErrorInfo());
        }
        return 0;
    }

    public static int hsmDeleteFile(String fileName) throws CryptoException {
        logger.info("SDSCmd:hsmDeleteFile(String  fileName)......");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (fileName.length() > 128) {
            throw new CryptoException("hsmDeleteFile, Error:fileName too lang, length= " + fileName.length());
        }
        try {
            out.write(BytesUtil.int2bytes(fileName.length() + 1));
            out.write(fileName.getBytes());
            out.write(0);
        }
        catch (Exception e) {
            // empty catch block
        }
        byte[] param = out.toByteArray();
        Request request = new Request(0x400004, param);
        NetCommunication net = new NetCommunication();
        Response response = net.socketCommunication(request);
        if (response.getErrorCode() != 0) {
            throw new CryptoException("hsmDeleteFile, ErrorCode:" + response.getErrorInfo());
        }
        return 0;
    }
}

