/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket;

import com.sansec.devicev4.api.CryptoException;
import com.sansec.devicev4.crypto_hsm.config.ConfigFile;
import com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket.HSMPool;
import com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket.HSMSocket;
import com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket.HSMSocketException;
import com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket.RepairPool;
import com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket.bean.HSMInfo;
import com.sansec.devicev4.log.CryptoLogger;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

public class HSMSession {
    private Logger logger = CryptoLogger.logger;
    private int size = 0;
    private HSMSocket[] sockets = new HSMSocket[10];
    private static AtomicInteger[] custormCount = new AtomicInteger[10];
    private int cnt = 0;

    public HSMSession(ConfigFile profile, String loginPass, String keyStorePass, String trustStorePass) throws CryptoException {
        List<HSMInfo> allHsm = profile.getServer();
        this.size = allHsm.size();
        boolean connect = false;
        for (int i = 0; i < allHsm.size(); ++i) {
            HSMInfo info = allHsm.get(i);
            if (custormCount[i] == null) {
                HSMSession.custormCount[i] = new AtomicInteger();
            }
            try {
                this.sockets[i] = new HSMSocket(profile, info, i, loginPass, keyStorePass, trustStorePass);
                this.sockets[i].login();
                connect = true;
                continue;
            }
            catch (Exception e) {
                this.logger.severe("HSMSession -- IP\uff1a( " + info.getIp() + " ),cant connect.");
                this.sockets[i].setStatus(1);
                try {
                    this.logger.info("info: new Thread.RepairPool(hsmSocket)).start(), ip=" + this.sockets[i].getIp() + " status=" + this.sockets[i].getStatus());
                    RepairPool rt = new RepairPool(this.sockets[i]);
                    Thread t1 = new Thread(rt);
                    t1.setDaemon(true);
                    t1.setName("RepairPool");
                    t1.start();
                    continue;
                }
                catch (Exception e1) {
                    this.logger.severe("error: create RepairPool Thread failed! ip=" + this.sockets[i].getIp() + e1.getMessage());
                    throw new CryptoException(e1.getMessage());
                }
            }
        }
        if (!connect) {
            throw new CryptoException("HSMSession -- all HSM canntconnect");
        }
    }

    public void repair() throws HSMSocketException {
        this.logger.finer("repair");
        for (int i = 0; i < this.getSize(); ++i) {
            this.sockets[i].repair(0L);
        }
        this.logger.finer("repair->return");
    }

    public HSMSocket getHsmSocket() {
        HSMSocket socket = null;
        int minIndex = this.getMinHsmIndex();
        socket = this.sockets[minIndex];
        return socket;
    }

    public HSMSocket getEverySocket() {
        HSMSocket socket = null;
        socket = this.sockets[this.cnt];
        this.cnt = (this.cnt + 1) % this.getSize();
        return socket;
    }

    public void releaseHsmSocket(HSMSocket socket) {
        custormCount[socket.getIndexOfSession()].decrementAndGet();
    }

    private synchronized int getMinHsmIndex() {
        int index = 0;
        if (custormCount[index].get() != 0 || this.sockets[index].getStatus() != 0) {
            for (int i = 1; i < this.getSize(); ++i) {
                if (this.sockets[i].getStatus() != 0 || this.sockets[index].getStatus() != 1 && custormCount[i].get() >= custormCount[index].get()) continue;
                index = i;
            }
        }
        custormCount[index].incrementAndGet();
        return index;
    }

    public int getSize() {
        return this.size;
    }

    public void close() {
        for (int i = 0; i < this.getSize(); ++i) {
            this.sockets[i].close();
        }
    }

    public HSMSocket addHsm(ConfigFile configFile, int index) {
        HSMInfo info = configFile.getServer().get(index);
        if (custormCount[index] == null) {
            HSMSession.custormCount[index] = new AtomicInteger();
        }
        String loginPass = HSMPool.getPool().loginPass;
        String keyStorePass = HSMPool.getPool().keyStorePass;
        String trustStorePass = HSMPool.getPool().trustKeyStorePass;
        HSMSocket socket = new HSMSocket(configFile, info, index, loginPass, keyStorePass, trustStorePass);
        socket.setStatus(1);
        this.sockets[index] = socket;
        this.size = index + 1;
        return socket;
    }
}

