/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket;

import com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket.HSMPool;
import com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket.HSMSession;
import com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket.HSMSocket;
import com.sansec.devicev4.log.CryptoLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class RepairPool
implements Runnable {
    private Logger logger = CryptoLogger.logger;
    private HSMSocket hsmSocket;
    private static List<String> repairHsmIP = new ArrayList<String>();
    static HSMPool pool = HSMPool.getPool();
    static List<HSMSession> allSessions = pool.getAllSessions();

    public RepairPool(HSMSocket hsmSocket) {
        this.hsmSocket = hsmSocket;
    }

    public static synchronized int CheckHsmIP(String IP) {
        int i;
        for (i = 0; i < repairHsmIP.size(); ++i) {
            if (!repairHsmIP.get(i).equalsIgnoreCase(IP)) continue;
            return 1;
        }
        repairHsmIP.add(IP);
        for (i = 0; i < allSessions.size(); ++i) {
            HSMSession session = allSessions.get(i);
            int size = session.getSize();
            for (int j = 0; j < size; ++j) {
                HSMSocket hsmSocket2 = null;
                hsmSocket2 = session.getEverySocket();
                if (!hsmSocket2.getIp().equals(IP)) continue;
                hsmSocket2.setStatus(1);
            }
        }
        return 0;
    }

    @Override
    public void run() {
        Thread curthread = new Thread(this);
        this.logger.info("class RepairPool ->run......first line...... , curthread.getId=" + curthread.getId());
        if (RepairPool.CheckHsmIP(this.hsmSocket.getIp()) == 1) {
            this.logger.finest("class RepairPool -> CheckHsmIP(hsmSocket.getIp())==1......return , curthread.getId=" + curthread.getId());
            return;
        }
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            this.logger.info("class RepairPool -> Thread.sleep InterruptedException ,IP:" + this.hsmSocket.getIp() + " " + e.getMessage());
        }
        for (int i = 0; i < allSessions.size(); ++i) {
            HSMSession session = allSessions.get(i);
            int size = session.getSize();
            for (int j = 0; j < size; ++j) {
                HSMSocket hsmSocket2 = session.getEverySocket();
                if (!hsmSocket2.getIp().equals(this.hsmSocket.getIp())) continue;
                while (hsmSocket2.getStatus() != 0) {
                    try {
                        this.logger.info("class RepairPool -> hsmSocket.repair() run...... , curthread.getId=" + curthread.getId());
                        hsmSocket2.repair(curthread.getId());
                    }
                    catch (Exception e) {
                        this.logger.info("class RepairPool -> hsmSocket.repair() CryptoException ,IP:" + this.hsmSocket.getIp() + " " + e.getMessage());
                    }
                    if (hsmSocket2.getStatus() == 0) continue;
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException e) {
                        this.logger.info("class RepairPool -> Thread.sleep InterruptedException ,IP:" + this.hsmSocket.getIp() + " " + e.getMessage());
                    }
                }
            }
        }
        RepairPool.RemoveHsmIP(this.hsmSocket.getIp());
        this.logger.info("class RepairPool -> hsmSocket.repair()   success......last line..... , curthread.getId=" + curthread.getId());
    }

    public static synchronized int RemoveHsmIP(String IP) {
        for (int i = 0; i < repairHsmIP.size(); ++i) {
            if (!repairHsmIP.get(i).equalsIgnoreCase(IP)) continue;
            repairHsmIP.remove(i);
            return 0;
        }
        return 1;
    }
}

