/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket.bean;

import com.sansec.devicev4.sfot.sm3.SM3Digest;
import com.sansec.devicev4.sfot.sm4.SM4;
import com.sansec.devicev4.sfot.sm4.SM4_Context;
import com.sansec.devicev4.util.BytesUtil;
import java.io.ByteArrayOutputStream;

public class ReqLogin {
    private int nTotalLength;
    private int nProtocalVersion;
    private int nSessionID;
    private byte[] connectPwd = null;
    private byte[] prikeyAutehenCode = new byte[16];
    private byte[] reserved = new byte[16];

    public ReqLogin(int nTotalLength, int nProtocalVersion, int nSessionID) {
        this.nTotalLength = nTotalLength;
        this.nProtocalVersion = nProtocalVersion;
        this.nSessionID = nSessionID;
    }

    public ReqLogin() {
        this(60, 0x1000000, 123);
    }

    public void setConnectPwd(byte[] sConnectPwd) {
        if (8 == sConnectPwd.length) {
            this.nTotalLength = 60;
            this.connectPwd = sConnectPwd;
        } else {
            this.nTotalLength = 108;
            this.connectPwd = this.getPlainPSD(BytesUtil.hex2bytes(new String(sConnectPwd)));
        }
    }

    public byte[] encode() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(BytesUtil.int2bytes(this.nTotalLength));
            out.write(BytesUtil.int2bytes(this.nProtocalVersion));
            out.write(BytesUtil.int2bytes(this.nSessionID));
            out.write(this.connectPwd);
            for (int i = this.connectPwd.length; i < this.nTotalLength - 44; ++i) {
                out.write(0);
            }
            out.write(this.prikeyAutehenCode);
            out.write(this.reserved);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return out.toByteArray();
    }

    private byte[] getPlainPSD(byte[] cipherPWD) {
        SM4_Context hsm4 = new SM4_Context();
        hsm4.isPadding = false;
        hsm4.mode = 0;
        byte[] key = new byte[]{49, 50, 50, 52, 115, 118, 121, 97, 49, 50, 50, 52, 115, 118, 121, 97};
        byte[] pwd = null;
        SM4 sm4 = new SM4();
        try {
            sm4.sm4_setkey_dec(hsm4, key);
            pwd = sm4.sm4_crypt_ecb(hsm4, cipherPWD);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return null;
        }
        byte[] md = new byte[32];
        SM3Digest sm3 = new SM3Digest();
        sm3.update(pwd, 0, 8);
        sm3.doFinal(md, 0);
        return md;
    }

    public static void main(String[] args) {
        ReqLogin reqLogin = new ReqLogin();
        byte[] pwd = reqLogin.getPlainPSD(BytesUtil.hex2bytes("1F60FFFDF9C13EBECCC2800160C04C84"));
    }
}

