/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.devicev4.gb.struct.key.dsa;

import com.sansec.devicev4.api.CryptoException;
import com.sansec.devicev4.gb.struct.key.IDSArefPublicKey;
import com.sansec.devicev4.util.BytesUtil;
import com.sun.jna.Structure;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class DSArefPublicKeyLite
extends Structure
implements IDSArefPublicKey {
    public int bits;
    public byte[] p = new byte[256];
    public byte[] q = new byte[32];
    public byte[] g = new byte[256];
    public byte[] pubkey = new byte[256];

    public DSArefPublicKeyLite() {
    }

    public DSArefPublicKeyLite(int bits, byte[] p, byte[] q, byte[] g, byte[] pubkey) {
        if (p.length > 257) {
            throw new RuntimeException("p length[ " + p.length + " ]");
        }
        this.bits = bits;
        System.arraycopy(p, 0, this.p, 256 - p.length, p.length);
        if (q.length > 33) {
            throw new RuntimeException("q length[ " + q.length + " ]");
        }
        System.arraycopy(q, 0, this.q, 32 - q.length, q.length);
        if (g.length > 257) {
            throw new RuntimeException("g length[ " + g.length + " ]");
        }
        System.arraycopy(g, 0, this.g, 256 - g.length, g.length);
        if (pubkey.length > 257) {
            throw new RuntimeException("q length[ " + q.length + " ]");
        }
        System.arraycopy(pubkey, 0, this.pubkey, 256 - pubkey.length, pubkey.length);
    }

    @Override
    public int getBits() {
        return this.bits;
    }

    @Override
    public byte[] getP() {
        return this.p;
    }

    @Override
    public byte[] getQ() {
        return this.q;
    }

    @Override
    public byte[] getG() {
        return this.g;
    }

    @Override
    public byte[] getPubkey() {
        return this.pubkey;
    }

    public static int sizeof() {
        return 804;
    }

    @Override
    public void decode(byte[] bytes) throws CryptoException {
        this.bits = BytesUtil.bytes2int(bytes);
        int pos = 4;
        System.arraycopy(bytes, pos, this.p, 0, 256);
        System.arraycopy(bytes, pos += this.p.length, this.q, 0, 32);
        System.arraycopy(bytes, pos += this.q.length, this.g, 0, 256);
        System.arraycopy(bytes, pos += this.g.length, this.pubkey, 0, 256);
        if ((pos += this.pubkey.length) != bytes.length) {
            throw new CryptoException("inputData length != DSArefPublicKeyLite length");
        }
    }

    @Override
    public byte[] encode() throws CryptoException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try {
            buf.write(BytesUtil.int2bytes(this.bits));
            buf.write(this.p);
            buf.write(this.q);
            buf.write(this.g);
            buf.write(this.pubkey);
        }
        catch (IOException e) {
            throw new CryptoException("DSArefPublicKeyLite encode error.", e);
        }
        return buf.toByteArray();
    }

    @Override
    public String toString() {
        return "DSArefPublicKeyLite{bits=" + this.bits + ", p=" + BytesUtil.bytes2hex(this.p) + ", q=" + BytesUtil.bytes2hex(this.q) + ", g=" + BytesUtil.bytes2hex(this.g) + ", pubkey=" + BytesUtil.bytes2hex(this.pubkey) + '}';
    }

    @Override
    protected List<String> getFieldOrder() {
        return Arrays.asList("bits", "p", "q", "g", "pubkey");
    }
}

