/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.devicev4.gb.struct.key.ecdsa;

import com.sansec.devicev4.api.CryptoException;
import com.sansec.devicev4.gb.struct.key.IKeyPair;
import com.sansec.devicev4.util.BytesUtil;
import com.sun.jna.Structure;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class ECDSArefPublicKey
extends Structure
implements IKeyPair {
    public int bits;
    public int curvetype;
    public byte[] x = new byte[80];
    public byte[] y = new byte[80];

    public int getBits() {
        return this.bits;
    }

    public int getCurvetype() {
        return this.curvetype;
    }

    public void setCurvetype(int curvetype) {
        this.curvetype = curvetype;
    }

    public byte[] getX() {
        return this.x;
    }

    public byte[] getY() {
        return this.y;
    }

    public ECDSArefPublicKey() {
    }

    public ECDSArefPublicKey(int bits, int curvetype, byte[] x, byte[] y) {
        this.bits = bits;
        this.curvetype = curvetype;
        if (x.length > 80) {
            System.arraycopy(x, x.length - 80, this.x, 0, this.x.length);
        } else {
            System.arraycopy(x, 0, this.x, this.x.length - x.length, x.length);
        }
        if (y.length > 80) {
            System.arraycopy(y, y.length - 80, this.y, 0, this.y.length);
        } else {
            System.arraycopy(y, 0, this.y, this.y.length - y.length, y.length);
        }
    }

    @Override
    public int size() {
        return 168;
    }

    public static int sizeof() {
        return 168;
    }

    @Override
    public void decode(byte[] publicKey) throws CryptoException {
        this.bits = BytesUtil.bytes2int(publicKey);
        int pos = 4;
        byte[] tmpBuffer = new byte[4];
        System.arraycopy(publicKey, pos, tmpBuffer, 0, tmpBuffer.length);
        this.curvetype = BytesUtil.bytes2int(tmpBuffer);
        System.arraycopy(publicKey, pos += tmpBuffer.length, this.x, 0, 80);
        System.arraycopy(publicKey, pos += this.x.length, this.y, 0, 80);
        if ((pos += this.y.length) != publicKey.length) {
            throw new CryptoException("inputData length != ECDSArefPublicKey length");
        }
    }

    @Override
    public byte[] encode() throws CryptoException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try {
            buf.write(BytesUtil.int2bytes(this.bits));
            buf.write(BytesUtil.int2bytes(this.curvetype));
            buf.write(this.x);
            buf.write(this.y);
        }
        catch (IOException e) {
            throw new CryptoException("ECDSArefPublicKey encode error.", e);
        }
        return buf.toByteArray();
    }

    @Override
    public String toString() {
        return "ECDSArefPublicKey{bits=" + this.bits + ", curvetype=" + Integer.toHexString(this.curvetype) + ", X=" + BytesUtil.bytes2hex(this.x) + ", Y=" + BytesUtil.bytes2hex(this.y) + '}';
    }

    protected List getFieldOrder() {
        return Arrays.asList("bits", "curvetype", "x", "y");
    }

    public static class ByValue
    extends ECDSArefPublicKey
    implements Structure.ByValue {
    }

    public static class ByReference
    extends ECDSArefPublicKey
    implements Structure.ByReference {
    }
}

