/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.devicev4.gb.struct.key.rsa;

import com.sansec.devicev4.api.CryptoException;
import com.sansec.devicev4.gb.struct.key.IRSArefPublicKey;
import com.sansec.devicev4.util.BytesUtil;
import com.sun.jna.Structure;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;

public class RSArefPublicKeyLite
extends Structure
implements IRSArefPublicKey {
    public int bits;
    public byte[] m = new byte[256];
    public byte[] e = new byte[256];

    public RSArefPublicKeyLite(int bits, byte[] m, byte[] e) {
        if (m.length > 257) {
            throw new RuntimeException("n length[ " + m.length + " ]");
        }
        this.bits = bits;
        System.arraycopy(m, 0, this.m, 256 - m.length, m.length);
        if (e.length > 257) {
            throw new RuntimeException("e length[ " + e.length + " ]");
        }
        System.arraycopy(e, 0, this.e, 256 - e.length, e.length);
    }

    public RSArefPublicKeyLite() {
    }

    @Override
    public int getBits() {
        return this.bits;
    }

    @Override
    public byte[] getM() {
        return this.m;
    }

    @Override
    public byte[] getE() {
        return this.e;
    }

    @Override
    public void decode(byte[] publicKey) throws CryptoException {
        this.bits = BytesUtil.bytes2int(publicKey);
        int pos = 4;
        System.arraycopy(publicKey, pos, this.m, 0, 256);
        System.arraycopy(publicKey, pos += this.m.length, this.e, 0, 256);
        if ((pos += this.e.length) != publicKey.length) {
            throw new CryptoException("inputData length != RSAPublicKey length");
        }
    }

    @Override
    public byte[] encode() throws CryptoException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(BytesUtil.int2bytes(this.bits));
            out.write(this.m);
            out.write(this.e);
        }
        catch (IOException e) {
            throw new CryptoException("RSArefPublicKeyLite encode error.", e);
        }
        return out.toByteArray();
    }

    @Override
    public int size() {
        return 516;
    }

    public static int sizeof() {
        return 516;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        String nl = System.getProperty("line.separator");
        buf.append(nl);
        buf.append("bits: ").append(this.bits).append(nl);
        buf.append("   m: ").append(new BigInteger(1, this.m).toString(16)).append(nl);
        buf.append("   e: ").append(new BigInteger(1, this.e).toString(16)).append(nl);
        return buf.toString();
    }

    protected List getFieldOrder() {
        return Arrays.asList("bits", "m", "e");
    }

    public static class ByValue
    extends RSArefPublicKeyLite
    implements Structure.ByValue {
    }

    public static class ByReference
    extends RSArefPublicKeyLite
    implements Structure.ByReference {
    }
}

