/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.devicev4.gb.struct.key.sm2;

import com.sansec.devicev4.api.CryptoException;
import com.sansec.devicev4.gb.struct.key.IKeyPair;
import com.sun.jna.Structure;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;

public class SM2refSignature
extends Structure
implements IKeyPair {
    public byte[] r = new byte[32];
    public byte[] s = new byte[32];

    public SM2refSignature() {
    }

    public SM2refSignature(byte[] r, byte[] s) {
        this.r = r;
        this.s = s;
    }

    public byte[] getR() {
        return this.r;
    }

    public byte[] getS() {
        return this.s;
    }

    @Override
    public void decode(byte[] signature) throws CryptoException {
        int pos = 0;
        System.arraycopy(signature, pos, this.r, 0, 32);
        System.arraycopy(signature, pos += 32, this.s, 0, 32);
        if ((pos += 32) != signature.length) {
            throw new CryptoException("inputData length != SM2Signature length");
        }
    }

    @Override
    public byte[] encode() throws CryptoException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try {
            buf.write(this.r);
            buf.write(this.s);
        }
        catch (IOException e) {
            throw new CryptoException("SM2refSignature encode error.", e);
        }
        return buf.toByteArray();
    }

    @Override
    public int size() {
        return 64;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        String nl = System.getProperty("line.separator");
        buf.append(nl);
        buf.append("   R: ").append(new BigInteger(1, this.r).toString(16)).append(nl);
        buf.append("   S: ").append(new BigInteger(1, this.s).toString(16)).append(nl);
        return buf.toString();
    }

    protected List getFieldOrder() {
        return Arrays.asList("r", "s");
    }

    public static class ByValue
    extends SM2refSignature
    implements Structure.ByValue {
    }

    public static class ByReference
    extends SM2refSignature
    implements Structure.ByReference {
    }
}

