/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.devicev4.log;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class LogFormatter
extends Formatter {
    private static String lineSeparator = System.getProperty("line.separator");
    private SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");

    @Override
    public synchronized String format(LogRecord record) {
        StringBuilder sb = new StringBuilder();
        Date date = new Date();
        String time = this.formatter.format(date);
        sb.append(time);
        sb.append(" ");
        sb.append("[Thread-" + record.getThreadID() + "]");
        sb.append(" ");
        sb.append(record.getLevel().getName());
        sb.append(" ");
        sb.append("[");
        String loggerName = record.getSourceClassName();
        sb.append(loggerName);
        if (loggerName != null) {
            sb.append('.');
            sb.append(record.getSourceMethodName());
            sb.append("()");
        }
        sb.append("]");
        sb.append(" - ");
        sb.append(record.getMessage());
        sb.append(lineSeparator);
        if (record.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                sb.append(sw.toString());
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return sb.toString();
    }
}

