/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.SafeKey;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLECUtils;
import java.security.PublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;

public class Sm2PublicKey {
    public byte[] x = new byte[32];
    public byte[] y = new byte[32];

    public Sm2PublicKey() {
    }

    public Sm2PublicKey(byte[] x, byte[] y) {
        this.x = GMSSLByteArrayUtils.filterByteArrayZeroInHead(x, 32);
        this.y = GMSSLByteArrayUtils.filterByteArrayZeroInHead(y, 32);
    }

    public Sm2PublicKey(PublicKey publicKey) {
        BCECPublicKey bcecPublicKey = (BCECPublicKey)publicKey;
        this.x = GMSSLByteArrayUtils.filterByteArrayZeroInHead(bcecPublicKey.getQ().getAffineXCoord().getEncoded(), 32);
        this.y = GMSSLByteArrayUtils.filterByteArrayZeroInHead(bcecPublicKey.getQ().getAffineYCoord().getEncoded(), 32);
    }

    public byte[] getX() {
        return this.x;
    }

    public void setX(byte[] x) {
        this.x = x;
    }

    public byte[] getY() {
        return this.y;
    }

    public void setY(byte[] y) {
        this.y = y;
    }

    public PublicKey getPublicKey(String stdName) throws Exception {
        return GMSSLECUtils.convertECPublicKey(this.x, this.y, stdName);
    }
}

