/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.SafeKey.bean;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import java.math.BigInteger;
import org.bouncycastle.util.BigIntegers;

public enum MiniPcieIndexEnum {
    ONE(1, 40, 41, 42, 43, 44, 45, 46),
    TWO(2, 47, 48, 49, 50, 51, 52, 53);

    public int index;
    public int containerIndex;
    public int encCertIndex;
    public int encPublicKeyIndex;
    public int encPrivateIndex;
    public int signCertIndex;
    public int signPublicKeyIndex;
    public int signPrivateIndex;

    private MiniPcieIndexEnum(int index, int containerIndex, int encCertIndex, int encPublicKeyIndex, int encPrivateIndex, int signCertIndex, int signPublicKeyIndex, int signPrivateIndex) {
        this.index = index;
        this.containerIndex = containerIndex;
        this.encCertIndex = encCertIndex;
        this.encPublicKeyIndex = encPublicKeyIndex;
        this.encPrivateIndex = encPrivateIndex;
        this.signCertIndex = signCertIndex;
        this.signPublicKeyIndex = signPublicKeyIndex;
        this.signPrivateIndex = signPrivateIndex;
    }

    public static MiniPcieIndexEnum getInfoFromIndex(int index) {
        for (MiniPcieIndexEnum t : MiniPcieIndexEnum.values()) {
            if (t.index != index) continue;
            return t;
        }
        throw new IllegalArgumentException(String.format("MiniPcieIndexEnum \u679a\u4e3e\u8f6c\u6362\u5f02\u5e38[id=%d]", index));
    }

    public byte[] getEncCertIndex() {
        return GMSSLByteArrayUtils.fillByteArrayWithZeroInHead(BigIntegers.asUnsignedByteArray(BigInteger.valueOf(this.encCertIndex)), 2);
    }

    public byte[] getEncPublicKeyIndex() {
        return GMSSLByteArrayUtils.fillByteArrayWithZeroInHead(BigIntegers.asUnsignedByteArray(BigInteger.valueOf(this.encPublicKeyIndex)), 2);
    }

    public byte[] getEncPrivateIndex() {
        return GMSSLByteArrayUtils.fillByteArrayWithZeroInHead(BigIntegers.asUnsignedByteArray(BigInteger.valueOf(this.encPrivateIndex)), 2);
    }

    public byte[] getSignCertIndex() {
        return GMSSLByteArrayUtils.fillByteArrayWithZeroInHead(BigIntegers.asUnsignedByteArray(BigInteger.valueOf(this.signCertIndex)), 2);
    }

    public byte[] getSignPublicKeyIndex() {
        return GMSSLByteArrayUtils.fillByteArrayWithZeroInHead(BigIntegers.asUnsignedByteArray(BigInteger.valueOf(this.signPublicKeyIndex)), 2);
    }

    public byte[] getSignPrivateIndex() {
        return GMSSLByteArrayUtils.fillByteArrayWithZeroInHead(BigIntegers.asUnsignedByteArray(BigInteger.valueOf(this.signPrivateIndex)), 2);
    }
}

