/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.asn1.x509;

import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;

public class SubjectInformationAccess
extends ASN1Object {
    public static final ASN1ObjectIdentifier id_ad_caRepository = new ASN1ObjectIdentifier("1.3.6.1.5.5.7.48.5");
    private AccessDescription[] descriptions;

    public static SubjectInformationAccess getInstance(Object obj) {
        if (obj instanceof SubjectInformationAccess) {
            return (SubjectInformationAccess)obj;
        }
        if (obj != null) {
            return new SubjectInformationAccess(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public static SubjectInformationAccess fromExtensions(Extensions extensions) {
        return SubjectInformationAccess.getInstance(extensions.getExtensionParsedValue(Extension.subjectInfoAccess));
    }

    private SubjectInformationAccess(ASN1Sequence seq) {
        if (seq.size() < 1) {
            throw new IllegalArgumentException("sequence may not be empty");
        }
        this.descriptions = new AccessDescription[seq.size()];
        for (int i = 0; i != seq.size(); ++i) {
            this.descriptions[i] = AccessDescription.getInstance(seq.getObjectAt(i));
        }
    }

    public SubjectInformationAccess(AccessDescription description) {
        this(new AccessDescription[]{description});
    }

    public SubjectInformationAccess(AccessDescription[] descriptions) {
        this.descriptions = new AccessDescription[descriptions.length];
        System.arraycopy(descriptions, 0, this.descriptions, 0, descriptions.length);
    }

    public SubjectInformationAccess(ASN1ObjectIdentifier oid, GeneralName location) {
        this(new AccessDescription(oid, location));
    }

    public AccessDescription[] getAccessDescriptions() {
        return this.descriptions;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vec = new ASN1EncodableVector();
        for (int i = 0; i != this.descriptions.length; ++i) {
            vec.add(this.descriptions[i]);
        }
        return new DERSequence(vec);
    }

    public String toString() {
        return "SubjectInformationAccess: Oid(" + this.descriptions[0].getAccessMethod().getId() + ")";
    }
}

