/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.core.utils;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import java.security.Security;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.engines.SM4Engine;
import org.bouncycastle.crypto.modes.CCMBlockCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GMSSLBCAeadUtils {
    private static Logger logger = LoggerFactory.getLogger(GMSSLBCAeadUtils.class);

    public static byte[] encryptAESCCM(byte[] key, int tagLen, byte[] nonce, byte[] aad, byte[] plaintext) throws InvalidCipherTextException {
        return GMSSLBCAeadUtils.encryptCCM(key, tagLen, nonce, aad, plaintext, new AESEngine());
    }

    public static byte[] encryptSM4CCM(byte[] key, int tagLen, byte[] nonce, byte[] aad, byte[] plaintext) throws InvalidCipherTextException {
        return GMSSLBCAeadUtils.encryptCCM(key, tagLen, nonce, aad, plaintext, new SM4Engine());
    }

    public static byte[] encryptCCM(byte[] key, int tagLen, byte[] nonce, byte[] aad, byte[] plaintext, BlockCipher blockCipher) throws InvalidCipherTextException {
        byte[] enc = new byte[plaintext.length + tagLen];
        KeyParameter keyParam = key == null ? null : new KeyParameter(key);
        CCMBlockCipher ccm = new CCMBlockCipher(blockCipher);
        ccm.init(true, new AEADParameters(keyParam, tagLen * 8, nonce, aad));
        int len = ccm.processBytes(plaintext, 0, plaintext.length, enc, 0);
        len += ccm.doFinal(enc, len);
        return enc;
    }

    public static byte[] decryptAESCCM(byte[] key, int tagLen, byte[] nonce, byte[] aad, byte[] enc) throws InvalidCipherTextException {
        return GMSSLBCAeadUtils.decryptCCM(key, tagLen, nonce, aad, enc, new AESEngine());
    }

    public static byte[] decryptSM4CCM(byte[] key, int tagLen, byte[] nonce, byte[] aad, byte[] enc) throws InvalidCipherTextException {
        return GMSSLBCAeadUtils.decryptCCM(key, tagLen, nonce, aad, enc, new SM4Engine());
    }

    public static byte[] decryptCCM(byte[] key, int tagLen, byte[] nonce, byte[] aad, byte[] enc, BlockCipher blockCipher) throws InvalidCipherTextException {
        KeyParameter keyParam = key == null ? null : new KeyParameter(key);
        CCMBlockCipher ccm = new CCMBlockCipher(blockCipher);
        ccm.init(false, new AEADParameters(keyParam, tagLen * 8, nonce, aad));
        byte[] tmp = new byte[enc.length];
        int len = ccm.processBytes(enc, 0, enc.length, tmp, 0);
        len += ccm.doFinal(tmp, len);
        byte[] dec = new byte[len];
        System.arraycopy(tmp, 0, dec, 0, len);
        return dec;
    }

    public static byte[] pieceCipherTag(byte[] cipher, byte[] tag) {
        byte[] enc = new byte[cipher.length + tag.length];
        System.arraycopy(cipher, 0, enc, 0, cipher.length);
        System.arraycopy(tag, 0, enc, cipher.length, tag.length);
        GMSSLByteArrayUtils.printHexBinary(logger, "aead piece cipher ", cipher);
        GMSSLByteArrayUtils.printHexBinary(logger, "aead piece tag ", tag);
        GMSSLByteArrayUtils.printHexBinary(logger, "aead piece enc ", enc);
        return enc;
    }

    public static byte[][] splitCipherTag(byte[] enc, int tagLen) {
        byte[] cipher = new byte[enc.length - tagLen];
        byte[] tag = new byte[tagLen];
        System.arraycopy(enc, 0, cipher, 0, cipher.length);
        System.arraycopy(enc, cipher.length, tag, 0, tag.length);
        GMSSLByteArrayUtils.printHexBinary(logger, "aead split enc ", enc);
        GMSSLByteArrayUtils.printHexBinary(logger, "aead split cipher ", cipher);
        GMSSLByteArrayUtils.printHexBinary(logger, "aead split tag ", tag);
        return new byte[][]{cipher, tag};
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
    }
}

