/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.core.utils;

import java.security.Security;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class GMSSLBCHmacUtils {
    public static final String HMAC_SHA1 = "HMac-SHA1";
    public static final String HMAC_SHA224 = "HMac-SHA224";
    public static final String HMAC_SHA256 = "HMac-SHA256";
    public static final String HMAC_SHA384 = "HMac-SHA384";
    public static final String HMAC_SHA512 = "HMac-SHA512";
    public static final String HMAC_SM3 = "HMac-SM3";

    public static byte[] hmac(byte[] key, byte[] data, String macAlg) throws Exception {
        if (macAlg.equalsIgnoreCase(HMAC_SM3)) {
            return GMSSLBCHmacUtils.hmacWithSm3(key, data);
        }
        SecretKeySpec secretKey = new SecretKeySpec(key, macAlg);
        Mac mac = Mac.getInstance(secretKey.getAlgorithm(), "BC");
        mac.init(secretKey);
        mac.update(data);
        return mac.doFinal();
    }

    private static byte[] hmacWithSm3(byte[] key, byte[] data) {
        KeyParameter keyParameter = new KeyParameter(key);
        SM3Digest digest = new SM3Digest();
        HMac mac = new HMac(digest);
        mac.init(keyParameter);
        mac.update(data, 0, data.length);
        byte[] result = new byte[mac.getMacSize()];
        mac.doFinal(result, 0);
        return result;
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
    }
}

