/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.core.utils;

import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ParametersWithID;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.SM2Signer;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class GMSSLBCSignUtils {
    public static byte[] generateSignature(String algorithm, PrivateKey privateKey, byte[] data) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature instance = Signature.getInstance(algorithm, "BC");
        instance.initSign(privateKey);
        instance.update(data);
        return instance.sign();
    }

    public static boolean verifySignature(String algorithm, PublicKey publicKey, byte[] data, byte[] signature) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature instance = Signature.getInstance(algorithm, "BC");
        instance.initVerify(publicKey);
        instance.update(data);
        return instance.verify(signature);
    }

    public static byte[] sm2SignWithUserId(PrivateKey privateKey, byte[] data, byte[] userId) throws Exception {
        AsymmetricKeyParameter keyParameter = GMSSLX509Utils.convertECPrivateKeyKeyParameters(privateKey);
        SM2Signer signer = new SM2Signer();
        ParametersWithRandom parametersWithRandom = new ParametersWithRandom(keyParameter, new SecureRandom());
        ParametersWithID parametersWithID = new ParametersWithID(parametersWithRandom, userId);
        signer.init(true, parametersWithID);
        signer.update(data, 0, data.length);
        return signer.generateSignature();
    }

    public static boolean sm2VerifyWithUserId(PublicKey publicKey, byte[] userId, byte[] data, byte[] sign) throws Exception {
        AsymmetricKeyParameter keyParameter = GMSSLX509Utils.convertECPublicKeyParameters(publicKey);
        SM2Signer signer = new SM2Signer();
        ParametersWithID parametersWithID = new ParametersWithID(keyParameter, userId);
        signer.init(false, parametersWithID);
        signer.update(data, 0, data.length);
        return signer.verifySignature(sign);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
    }
}

