/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.core.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GMSSLFileUtils {
    private static Logger logger = LoggerFactory.getLogger(GMSSLFileUtils.class);
    public static final String CATALINA_BASE_PROP = "catalina.base";

    public static byte[] readFileToByte(String path) throws IOException {
        return GMSSLFileUtils.readAllBytes(path);
    }

    public static byte[] readAllBytes(String path) throws IOException {
        String resourceAsPath = GMSSLFileUtils.getResourceAsPath(path);
        Path p = Paths.get(resourceAsPath, new String[0]);
        return Files.readAllBytes(p);
    }

    public static void writeFile(String path, String name, byte[] content) throws IOException {
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(path + "/" + name);
        fileOutputStream.write(content);
        fileOutputStream.flush();
        fileOutputStream.close();
    }

    public static void copyDir(String sourcePath, String bakPath) throws IOException {
        File sourceFile;
        String[] list;
        File bakFile = new File(bakPath);
        if (!bakFile.exists()) {
            System.out.println(bakFile.toPath());
            Files.createDirectories(bakFile.toPath(), new FileAttribute[0]);
        }
        if ((list = (sourceFile = new File(sourcePath)).list()) != null) {
            for (String s : list) {
                if (new File(sourcePath + File.separator + s).isDirectory()) {
                    GMSSLFileUtils.copyDir(sourcePath + File.separator + s, bakPath + File.separator + s);
                }
                if (!new File(sourcePath + File.separator + s).isFile()) continue;
                GMSSLFileUtils.copyFile(sourcePath + File.separator + s, bakPath + File.separator + s);
            }
        }
    }

    public static void copyFile(String oldPath, String newPath) throws IOException {
        Path source = Paths.get(oldPath, new String[0]);
        Path target = Paths.get(newPath, new String[0]);
        Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
    }

    public static void copyFile(InputStream inputStream, String newPath) throws IOException {
        Path path = Paths.get(newPath, new String[0]);
        Files.copy(inputStream, path, StandardCopyOption.REPLACE_EXISTING);
    }

    public static boolean deleteDirectory(String sPath) {
        File dirFile;
        if (!sPath.endsWith(File.separator)) {
            sPath = sPath + File.separator;
        }
        if (!(dirFile = new File(sPath)).exists() || !dirFile.isDirectory()) {
            return false;
        }
        boolean flag = true;
        File[] files = dirFile.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length && !(files[i].isFile() ? !(flag = GMSSLFileUtils.deleteFile(files[i].getAbsolutePath())) : !(flag = GMSSLFileUtils.deleteDirectory(files[i].getAbsolutePath()))); ++i) {
            }
        }
        if (!flag) {
            return false;
        }
        return dirFile.delete();
    }

    public static boolean deleteFile(String sPath) {
        Path path = Paths.get(sPath, new String[0]);
        try {
            return Files.deleteIfExists(path);
        }
        catch (IOException e) {
            logger.error("delete dir error", e);
            return false;
        }
    }

    public static String fileToString(File file, String encoding) {
        String absolutePath = file.getAbsolutePath();
        try {
            return GMSSLFileUtils.readAllString(absolutePath, encoding);
        }
        catch (IOException e) {
            logger.error("file {}", (Object)absolutePath, (Object)e);
            return null;
        }
    }

    public static String readAllString(String path, String encoding) throws IOException {
        byte[] bytes = GMSSLFileUtils.readAllBytes(path);
        return new String(bytes, encoding);
    }

    public static InputStream getResourceAsStream(String path) throws FileNotFoundException {
        String resourceAsPath = GMSSLFileUtils.getResourceAsPath(path);
        return new FileInputStream(resourceAsPath);
    }

    public static String getResourceAsPath(String path) {
        File file = new File(path);
        if (file.exists()) {
            if (logger.isDebugEnabled()) {
                logger.debug("get resource as stream absolute path is {}", (Object)file.getAbsolutePath());
            }
            return path;
        }
        URL systemResource = ClassLoader.getSystemResource(path);
        if (systemResource != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("get resource as stream absolute path is {}", (Object)ClassLoader.getSystemResource(path).getPath());
            }
            return systemResource.getPath();
        }
        String p = new File(System.getProperty(CATALINA_BASE_PROP), path).getAbsolutePath();
        if (logger.isDebugEnabled()) {
            logger.debug("file is not in resource of path, now append CATALINA_BASE_PROP {} {}", (Object)CATALINA_BASE_PROP, (Object)p);
        }
        return p;
    }
}

