/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.core.utils;

import com.xdja.pki.gmssl.core.utils.GMSSLECUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLFileUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.IssuingDistributionPoint;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.crypto.util.PublicKeyFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.operator.ContentVerifier;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.Store;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.security.provider.certpath.X509CertificatePair;

public class GMSSLX509Utils {
    private static Logger logger = LoggerFactory.getLogger(GMSSLX509Utils.class.getName());
    public static final int ECC_KEY_BITS = 256;
    public static final String ECC_ALGORITHM_NAME = "EC";
    public static final String ECC_SM2_NAME;
    public static final String X509_TYPE_NAME = "X.509";
    private static int BLOCK_SIZE;

    public static KeyPair generateSM2KeyPair() throws NoSuchProviderException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        return GMSSLECUtils.generateKeyPair(ECC_SM2_NAME);
    }

    public static PublicKey convertSM2PublicKeyBitString(String base64) throws Exception {
        return GMSSLECUtils.convertPublicKeyBitString(base64, ECC_SM2_NAME);
    }

    public static PublicKey convertSM2PublicKeyBitString(byte[] data) throws Exception {
        return GMSSLECUtils.convertPublicKeyBitString(data, ECC_SM2_NAME);
    }

    public static String convertBitStringSM2PublicKey(ECPublicKey publicKey) throws Exception {
        return GMSSLECUtils.convertBitStringPublicKey(publicKey);
    }

    public static String convertBitStringSM2PublicKey(BigInteger x, BigInteger y) throws Exception {
        return GMSSLECUtils.convertBitStringPublicKey(x, y);
    }

    public static String convertBitStringSM2PublicKey(byte[] x, byte[] y) throws Exception {
        return GMSSLECUtils.convertBitStringPublicKey(x, y);
    }

    public static byte[] encodeSM2PublicKey(boolean compressed, PublicKey publicKey) throws Exception {
        return GMSSLECUtils.encodePublicKey(compressed, publicKey);
    }

    public static int checkSM2PublicKeyY0Y1(PublicKey publicKey) {
        return GMSSLECUtils.checkPublicKeyY0Y1(publicKey);
    }

    public static int checkSM2PublicKeyY0Y1(BigInteger bigInteger) {
        return GMSSLECUtils.checkPublicKeyY0Y1(bigInteger);
    }

    public static PublicKey decodeSM2PublicKey(byte[] encode) throws Exception {
        return GMSSLECUtils.convertPublicKey(encode, ECC_SM2_NAME);
    }

    public static PublicKey convertSM2PublicKey(int yTilde, byte[] publicKey) throws Exception {
        return GMSSLECUtils.convertPublicKey(yTilde, publicKey, ECC_SM2_NAME);
    }

    public static PublicKey convertSM2PublicKey(byte[] encoded) throws Exception {
        return GMSSLECUtils.convertPublicKey(encoded, ECC_SM2_NAME);
    }

    public static PublicKey convertSM2PublicKey(byte[] x, byte[] y) throws Exception {
        return GMSSLECUtils.convertPublicKey(x, y, ECC_SM2_NAME);
    }

    public static PublicKey convertSM2PublicKey(BigInteger x, BigInteger y) throws Exception {
        return GMSSLECUtils.convertPublicKey(x, y, ECC_SM2_NAME);
    }

    public static PublicKey convertSM2PublicKey(ECParameterSpec ecParameterSpec, ECPoint ecPoint) throws Exception {
        return GMSSLECUtils.convertPublicKey(ecParameterSpec, ecPoint, ECC_SM2_NAME);
    }

    public static PrivateKey convertSM2PrivateKey(byte[] s) throws Exception {
        return GMSSLECUtils.convertPrivateKey(s, ECC_SM2_NAME);
    }

    public static PrivateKey convertSM2PrivateKey(BigInteger s) throws Exception {
        return GMSSLECUtils.convertPrivateKey(s, ECC_SM2_NAME);
    }

    public static KeyPair convertSM2KeyPair(byte[] s) throws Exception {
        return GMSSLECUtils.convertKeyPair(s, ECC_SM2_NAME);
    }

    public static KeyPair convertSM2KeyPair(BigInteger s) throws Exception {
        return GMSSLECUtils.convertKeyPair(s, ECC_SM2_NAME);
    }

    public static KeyPair convertSM2KeyPair(PrivateKey key) throws Exception {
        return GMSSLECUtils.convertKeyPair(key, ECC_SM2_NAME);
    }

    public static PublicKey convertSM2PublicKey(PrivateKey key) throws Exception {
        return GMSSLECUtils.convertPublicKey(key, ECC_SM2_NAME);
    }

    public static PublicKey convertSM2PublicKey(SubjectPublicKeyInfo info) throws IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        return GMSSLECUtils.convertPublicKey(info);
    }

    public static PrivateKey convertPrivateKeyEncode(byte[] privateKeyInfo) throws Exception {
        return GMSSLECUtils.convertPrivateKeyEncode(privateKeyInfo);
    }

    public static PrivateKey convertPrivateKey(PrivateKeyInfo info) throws Exception {
        return GMSSLECUtils.convertPrivateKey(info);
    }

    public static PublicKey convertPublicKey(SubjectPublicKeyInfo info) throws IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        return GMSSLECUtils.convertPublicKey(info);
    }

    public static PEMParser readPem(String path) throws Exception {
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(path);
        if (inputStream == null) {
            inputStream = new FileInputStream(path);
        }
        InputStreamReader reader = new InputStreamReader(inputStream);
        return new PEMParser(reader);
    }

    public static KeyPair readKeyPairFromPEM(String path) throws Exception {
        PEMParser pemParser = GMSSLX509Utils.readPem(path);
        PEMKeyPair pemPair = (PEMKeyPair)pemParser.readObject();
        KeyPair keyPair = new JcaPEMKeyConverter().setProvider("BC").getKeyPair(pemPair);
        return keyPair;
    }

    public static X509Certificate readCertificateFromPEM(String path) throws Exception {
        PEMParser pemParser = GMSSLX509Utils.readPem(path);
        X509CertificateHolder holder = (X509CertificateHolder)pemParser.readObject();
        CertificateFactory certificateFactory = CertificateFactory.getInstance(X509_TYPE_NAME, "BC");
        ByteArrayInputStream inputStream = new ByteArrayInputStream(holder.getEncoded());
        X509Certificate certificate = (X509Certificate)certificateFactory.generateCertificate(inputStream);
        ((InputStream)inputStream).close();
        return certificate;
    }

    public static X509Certificate readCertificateFromCer(String path) throws Exception {
        InputStream systemResourceAsStream = GMSSLX509Utils.readInputStreamFromPath(path);
        return GMSSLX509Utils.readCertificateFromCerInputStream(systemResourceAsStream);
    }

    public static X509CRL readCRLFromCRL(String path) throws Exception {
        InputStream systemResourceAsStream = GMSSLX509Utils.readInputStreamFromPath(path);
        CertificateFactory factory = CertificateFactory.getInstance(X509_TYPE_NAME, "BC");
        return (X509CRL)factory.generateCRL(systemResourceAsStream);
    }

    public static X509Certificate readCertificateFromCerByte(byte[] encode) throws CertificateException, NoSuchProviderException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(encode);
        return GMSSLX509Utils.readCertificateFromCerInputStream(inputStream);
    }

    public static X509Certificate readCertificateFromCerInputStream(InputStream inputStream) throws CertificateException, NoSuchProviderException {
        CertificateFactory factory = CertificateFactory.getInstance(X509_TYPE_NAME, "BC");
        return (X509Certificate)factory.generateCertificate(inputStream);
    }

    public static X509Certificate readCertificateFromP12(String filename, char[] pw) throws Exception {
        KeyStore kse = GMSSLX509Utils.readKeyStoreFromP12(filename, pw);
        String alias = kse.aliases().nextElement();
        return (X509Certificate)kse.getCertificate(alias);
    }

    public static List<X509Certificate> readCertificatesFromP12(String filename, char[] pw) throws Exception {
        InputStream inputStream = GMSSLX509Utils.readInputStreamFromPath(filename);
        return GMSSLX509Utils.readCertificatesFromP12(inputStream, pw);
    }

    public static List<X509Certificate> readCertificatesFromP12(InputStream inputStream, char[] pw) throws Exception {
        KeyStore kse = GMSSLX509Utils.readKeyStoreFromP12(inputStream, pw);
        ArrayList<X509Certificate> list = new ArrayList<X509Certificate>();
        if (kse.aliases().hasMoreElements()) {
            String alias = kse.aliases().nextElement();
            list.add((X509Certificate)kse.getCertificate(alias));
        }
        return list;
    }

    public static PublicKey readPublicKeyFromCer(String path) throws Exception {
        X509Certificate certificate = GMSSLX509Utils.readCertificateFromCer(path);
        return certificate.getPublicKey();
    }

    public static PublicKey readPublicKeyFromPem(String path) throws Exception {
        PEMParser pemParser = GMSSLX509Utils.readPem(path);
        SubjectPublicKeyInfo info = SubjectPublicKeyInfo.getInstance(pemParser.readObject());
        return GMSSLX509Utils.convertSM2PublicKey(info);
    }

    public static PublicKey readPublicKeyFromP12(String filename, char[] pw) throws Exception {
        KeyStore kse = GMSSLX509Utils.readKeyStoreFromP12(filename, pw);
        String alias = kse.aliases().nextElement();
        return kse.getCertificate(alias).getPublicKey();
    }

    public static PrivateKey readPrivateKeyFromPem(String path) throws Exception {
        PEMParser pemParser = GMSSLX509Utils.readPem(path);
        PEMKeyPair pemPair = (PEMKeyPair)pemParser.readObject();
        return new JcaPEMKeyConverter().setProvider("BC").getPrivateKey(pemPair.getPrivateKeyInfo());
    }

    public static PrivateKey readPrivateKeyFromP12(String filename, char[] pw) throws Exception {
        KeyStore kse = GMSSLX509Utils.readKeyStoreFromP12(filename, pw);
        String alias = kse.aliases().nextElement();
        return (PrivateKey)kse.getKey(alias, pw);
    }

    public static KeyStore readKeyStoreFromP12(String filename, char[] pw) throws Exception {
        InputStream inputStream = GMSSLX509Utils.readInputStreamFromPath(filename);
        return GMSSLX509Utils.readKeyStoreFromP12(inputStream, pw);
    }

    public static InputStream readInputStreamFromPath(String filename) throws FileNotFoundException {
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(filename);
        if (inputStream == null) {
            inputStream = new FileInputStream(filename);
        }
        return inputStream;
    }

    public static KeyStore readKeyStoreFromP12(InputStream inputStream, char[] pw) throws Exception {
        KeyStore kse = KeyStore.getInstance("pkcs12", "BC");
        kse.load(inputStream, pw);
        inputStream.close();
        return kse;
    }

    public static List<X509Certificate> getCertsByCertChain(InputStream inputStream) throws CMSException, CertificateException, IOException {
        ArrayList<X509Certificate> certificateList = new ArrayList<X509Certificate>();
        CMSSignedData cmsSignedData = new CMSSignedData(inputStream);
        Store<X509CertificateHolder> store = cmsSignedData.getCertificates();
        Collection<X509CertificateHolder> collection = store.getMatches(null);
        for (X509CertificateHolder x509CertificateHolder : collection) {
            X509Certificate x509Certificate = new JcaX509CertificateConverter().setProvider("BC").getCertificate(x509CertificateHolder);
            certificateList.add(x509Certificate);
        }
        inputStream.close();
        return certificateList;
    }

    public static String createCertChainByCerts(List<X509Certificate> certificateList) {
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        try {
            CMSProcessableByteArray msg = new CMSProcessableByteArray("".getBytes());
            JcaCertStore jcaCertStore = new JcaCertStore(certificateList);
            gen.addCertificates(jcaCertStore);
            CMSSignedData signedData = gen.generate(msg);
            return new String(Base64.encode(signedData.getEncoded()));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void writeSdfPrivateKey(String path, String name, PrivateKey privateKey) throws IOException {
        path = path + File.separator;
        FileWriter fileWritter = new FileWriter(path + name + ".pem", false);
        fileWritter.write(privateKey.toString());
        fileWritter.close();
    }

    public static void writeCertificateToCer(String path, String name, X509Certificate certificate) throws Exception {
        GMSSLX509Utils.writeObject(path, name, ".cer", certificate.getEncoded());
    }

    public static void writeCRLToCrl(String path, String name, X509CRL crl) throws Exception {
        GMSSLX509Utils.writeObject(path, name, ".crl", crl.getEncoded());
    }

    private static void writeObject(String path, String name, String add, byte[] encoded) throws IOException, CRLException {
        File dir = new File(path);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        String filename = path + name + add;
        FileOutputStream out = new FileOutputStream(filename);
        out.write(encoded);
        out.close();
    }

    public static void writeFile(String path, String name, byte[] content) throws IOException {
        GMSSLFileUtils.writeFile(path, name, content);
    }

    public static void writeCertificateToPem(String path, String name, X509Certificate certificate) throws Exception {
        GMSSLX509Utils.writeObjectToPem(path, name, certificate);
    }

    public static void writePrivateKeyToPem(String path, String name, PrivateKey privateKey) throws Exception {
        GMSSLX509Utils.writeObjectToPem(path, name, privateKey);
    }

    public static void writePrivateKeyToDat(String path, String name, PrivateKey privateKey) throws Exception {
        GMSSLX509Utils.writeObjectToFile(path, name, privateKey);
    }

    public static void writePublicKeyToDat(String path, String name, PublicKey publicKey) throws Exception {
        GMSSLX509Utils.writeObjectToFile(path, name, publicKey);
    }

    public static void writePublicKeyToPem(String path, String name, PublicKey publicKey) throws Exception {
        GMSSLX509Utils.writeObjectToPem(path, name, publicKey);
    }

    public static void writeObjectToPem(String path, String name, Object object) throws Exception {
        GMSSLX509Utils.writeObjectToFile(path, name + ".pem", object);
    }

    public static void writeObjectToFile(String path, String name, Object object) throws Exception {
        File dir = new File(path);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        String filename = path + File.separator + name;
        FileWriter writer = new FileWriter(filename);
        GMSSLX509Utils.writePEM(object, writer);
        writer.close();
    }

    public static void printPEMObject(String message, Object object) throws Exception {
        StringWriter stringWriter = new StringWriter();
        GMSSLX509Utils.writePEM(object, stringWriter);
        logger.info("pem object {} : \n{}", (Object)message, (Object)stringWriter.toString());
    }

    public static void writePEM(Object object, Writer writer) throws Exception {
        JcaPEMWriter pw = new JcaPEMWriter(writer);
        pw.writeObject(object);
        pw.flush();
        pw.close();
    }

    public static List<PrivateKey> readPrivateKeyToP12(String path, char[] password, X509Certificate[] certificates) throws Exception {
        KeyStore read = KeyStore.getInstance("PKCS12", "BC");
        read.load(null, null);
        Enumeration<String> aliases = read.aliases();
        ArrayList<PrivateKey> privateKeys = new ArrayList<PrivateKey>();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            PrivateKey key = (PrivateKey)read.getKey(alias, password);
            privateKeys.add(key);
        }
        return privateKeys;
    }

    public static void writePrivateKeyToP12(String path, String alias, char[] password, PrivateKey privateKey, X509Certificate[] certificates) throws Exception {
        KeyStore write = KeyStore.getInstance("PKCS12", "BC");
        write.load(null, null);
        write.setKeyEntry(alias, privateKey, password, certificates);
        FileOutputStream out = new FileOutputStream(path + alias + ".p12");
        write.store(out, password);
        out.close();
    }

    public static void writeKeyStoreToP12(KeyStore keyStore, char[] password, String path, String alias) throws Exception {
        KeyStore write = KeyStore.getInstance("PKCS12", "BC");
        write.load(null, null);
        write.setCertificateEntry(alias, keyStore.getCertificate(alias));
        if (keyStore.getKey(alias, password) != null) {
            write.setKeyEntry(alias, keyStore.getKey(alias, password), password, keyStore.getCertificateChain(alias));
        }
        FileOutputStream out = new FileOutputStream(path + alias + ".p12");
        write.store(out, password);
        out.close();
    }

    public static void writeKeyStoreToP12(KeyStore keyStore, char[] password, String p12file) throws Exception {
        KeyStore write = KeyStore.getInstance("PKCS12", "BC");
        write.load(null, null);
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (keyStore.getCertificate(alias) != null) {
                write.setCertificateEntry(alias, keyStore.getCertificate(alias));
            }
            if (keyStore.getKey(alias, password) == null) continue;
            write.setKeyEntry(alias, keyStore.getKey(alias, password), password, keyStore.getCertificateChain(alias));
        }
        FileOutputStream out = new FileOutputStream(p12file + ".p12");
        write.store(out, password);
        out.close();
    }

    @Deprecated
    public static byte[] readFileToByte(String path) throws IOException {
        return GMSSLFileUtils.readFileToByte(path);
    }

    @Deprecated
    public static void copyDir(String sourcePath, String bakPath) throws IOException {
        GMSSLFileUtils.copyDir(sourcePath, bakPath);
    }

    @Deprecated
    public static void copyFile(String oldPath, String newPath) throws IOException {
        GMSSLFileUtils.copyFile(oldPath, newPath);
    }

    @Deprecated
    public static void copyFile(InputStream inputStream, String newPath) throws IOException {
        GMSSLFileUtils.copyFile(inputStream, newPath);
    }

    @Deprecated
    public static boolean deleteDirectory(String sPath) {
        return GMSSLFileUtils.deleteDirectory(sPath);
    }

    @Deprecated
    public static boolean deleteFile(String sPath) {
        return GMSSLFileUtils.deleteFile(sPath);
    }

    public static boolean verifyCert(X509Certificate cert, PublicKey publicKey) throws Exception {
        try {
            Certificate certificate = GMSSLX509Utils.convertCertificate(cert);
            return GMSSLX509Utils.verify(certificate.getSignatureAlgorithm(), publicKey, certificate.getTBSCertificate().getEncoded(), certificate.getSignature().getOctets());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("exception processing signature: " + e, e);
        }
    }

    public static boolean verifyCRL(X509CRL crl, PublicKey publicKey) throws Exception {
        try {
            CertificateList certificateList = GMSSLX509Utils.convertCRL(crl);
            return GMSSLX509Utils.verify(certificateList.getSignatureAlgorithm(), publicKey, certificateList.getTBSCertList().getEncoded(), certificateList.getSignature().getOctets());
        }
        catch (Exception e) {
            throw new Exception("exception processing signature: " + e, e);
        }
    }

    public static boolean verifyCert(X509Certificate cert, List<X509Certificate> certificates) throws Exception {
        boolean flag = false;
        for (int i = 0; i < certificates.size(); ++i) {
            flag = GMSSLX509Utils.verifyCert(cert, certificates.get(i).getPublicKey());
            if (!flag) continue;
            return true;
        }
        return false;
    }

    public static boolean verify(AlgorithmIdentifier algorithmIdentifier, PublicKey publicKey, byte[] encoded, byte[] expected) throws Exception {
        ContentVerifierProvider verifierProvider = new JcaContentVerifierProviderBuilder().setProvider("BC").build(publicKey);
        ContentVerifier verifier = verifierProvider.get(algorithmIdentifier);
        OutputStream out = verifier.getOutputStream();
        out.write(encoded);
        out.close();
        return verifier.verify(expected);
    }

    public static AsymmetricKeyParameter convertECPublicKeyParameters(PublicKey publicKey) throws IOException {
        return PublicKeyFactory.createKey(SubjectPublicKeyInfo.getInstance(publicKey.getEncoded()));
    }

    public static AsymmetricKeyParameter convertECPrivateKeyKeyParameters(PrivateKey privateKey) throws IOException {
        return PrivateKeyFactory.createKey(PrivateKeyInfo.getInstance(privateKey.getEncoded()));
    }

    public static SubjectPublicKeyInfo convertSubjectPublicKeyInfo(PublicKey publicKey) {
        return SubjectPublicKeyInfo.getInstance(publicKey.getEncoded());
    }

    public static Certificate convertCertificate(X509Certificate cert) throws CertificateEncodingException, IOException {
        return Certificate.getInstance(ASN1Primitive.fromByteArray(cert.getEncoded()));
    }

    public static X509Certificate convertCertificate(Certificate cert) throws Exception {
        CertificateFactory certificateFactory = CertificateFactory.getInstance(X509_TYPE_NAME, "BC");
        return (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(cert.getEncoded()));
    }

    public static X509CRL convertCRL(CertificateList certificateList) throws Exception {
        CertificateFactory certificateFactory = CertificateFactory.getInstance(X509_TYPE_NAME, "BC");
        return (X509CRL)certificateFactory.generateCRL(new ByteArrayInputStream(certificateList.getEncoded()));
    }

    public static CertificateList convertCRL(X509CRL certificateList) throws Exception {
        return CertificateList.getInstance(ASN1Primitive.fromByteArray(certificateList.getEncoded()));
    }

    public static org.bouncycastle.x509.X509CertificatePair convertCertificatePair(X509CertificatePair pair) throws Exception {
        return new org.bouncycastle.x509.X509CertificatePair(pair.getForward(), pair.getReverse());
    }

    public static X509CertificatePair convertCertificatePair(org.bouncycastle.x509.X509CertificatePair pair) throws Exception {
        return new X509CertificatePair(pair.getForward(), pair.getReverse());
    }

    public static byte[] derSignatureEncode(byte[] r, byte[] s) throws IOException {
        return GMSSLX509Utils.derSignatureEncode(BigIntegers.fromUnsignedByteArray(r), BigIntegers.fromUnsignedByteArray(s));
    }

    public static byte[] derSignatureEncode(BigInteger r, BigInteger s) throws IOException {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new ASN1Integer(r));
        v.add(new ASN1Integer(s));
        return new DERSequence(v).getEncoded("DER");
    }

    public static BigInteger[] derSignatureDecode(byte[] encoding) throws IOException {
        BigInteger s;
        ASN1Sequence seq = ASN1Sequence.getInstance(ASN1Primitive.fromByteArray(encoding));
        if (seq.size() != 2) {
            return null;
        }
        BigInteger r = ASN1Integer.getInstance(seq.getObjectAt(0)).getValue();
        byte[] expectedEncoding = GMSSLX509Utils.derSignatureEncode(r, s = ASN1Integer.getInstance(seq.getObjectAt(1)).getValue());
        if (!Arrays.constantTimeAreEqual(expectedEncoding, encoding)) {
            return null;
        }
        return new BigInteger[]{r, s};
    }

    public static byte[] paddingData(byte[] data, boolean isPkcs) {
        int paddingLength = BLOCK_SIZE - data.length % BLOCK_SIZE;
        byte[] plainText = new byte[data.length + paddingLength];
        System.arraycopy(data, 0, plainText, 0, data.length);
        byte padding = !isPkcs ? (byte)(paddingLength - 1) : (byte)paddingLength;
        int off = data.length;
        for (int i = 0; i < paddingLength; ++i) {
            plainText[off++] = padding;
        }
        return plainText;
    }

    public static byte[] removePadding(byte[] cipher, byte[] plain, boolean isPkcs) {
        byte lastByte = plain[plain.length - 1];
        byte[] plainText = isPkcs ? new byte[cipher.length - (lastByte & 0xFF)] : new byte[cipher.length - ((lastByte & 0xFF) + 1)];
        System.arraycopy(plain, 0, plainText, 0, plainText.length);
        return plainText;
    }

    public static boolean isCACertificate(X509Certificate certificate) {
        int basic = certificate.getBasicConstraints();
        return basic >= 0;
    }

    public static boolean isDRL(X509CRL crl) {
        Set<String> critical = crl.getCriticalExtensionOIDs();
        return critical != null && critical.contains(Extension.deltaCRLIndicator.getId());
    }

    public static boolean isARL(X509CRL crl) throws IOException {
        byte[] ext = crl.getExtensionValue(Extension.issuingDistributionPoint.getId());
        if (ext == null) {
            return false;
        }
        ASN1InputStream aIn = new ASN1InputStream(ext);
        ASN1OctetString octs = (ASN1OctetString)aIn.readObject();
        aIn = new ASN1InputStream(octs.getOctets());
        ASN1Primitive idp = aIn.readObject();
        IssuingDistributionPoint p = IssuingDistributionPoint.getInstance(idp);
        return p.onlyContainsCACerts();
    }

    public static void printEnvProperties() {
        logger.error("ENV============================================");
        Map<String, String> map = System.getenv();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            logger.error(entry.getKey() + "=" + entry.getValue());
        }
        logger.error("Properties============================================");
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            logger.error(entry.getKey() + "=" + entry.getValue());
        }
        logger.info("XDJA GMSSL TOMCAT PLUGIN contextInitialized done!");
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
        ECC_SM2_NAME = GMSSLECUtils.SM2p256;
        BLOCK_SIZE = 16;
    }
}

