/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.sdf;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.sdf.SdfSDK;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdAead;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.params.AEADParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdfAeadCipher {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final int BLOCK_SIZE = 16;
    private SdfSDK sdfSDK;
    private long[] phKeyHandle;
    private byte[] key;
    private boolean forEncryption;
    private AEADParameters aeadParameters;

    public SdfAeadCipher() throws SdfSDKException {
        this(SdfCryptoType.YUNHSM);
    }

    public SdfAeadCipher(SdfCryptoType sdfCryptoType) throws SdfSDKException {
        this(sdfCryptoType.getSdfSDK());
    }

    public SdfAeadCipher(SdfSDK sdfSDK) throws SdfSDKException {
        this.sdfSDK = sdfSDK;
    }

    public byte[] getKey() {
        return this.key;
    }

    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        try {
            this.sdfSDK.init();
        }
        catch (SdfSDKException e) {
            throw new IllegalArgumentException("sdf SDK init error", e);
        }
        if (!(params instanceof AEADParameters)) {
            throw new IllegalArgumentException("invalid parameter passed to SdfAeadCipher init - " + params.getClass().getName());
        }
        this.aeadParameters = (AEADParameters)params;
        this.forEncryption = forEncryption;
        this.key = this.aeadParameters.getKey().getKey();
        try {
            this.phKeyHandle = this.sdfSDK.importKey(this.key);
        }
        catch (SdfSDKException e) {
            this.logger.error("SDF AEAD init import key", e);
            throw new IllegalArgumentException("SDF AEAD init - import key error");
        }
    }

    public String getAlgorithmName() {
        return "AEAD";
    }

    public int getBlockSize() {
        return 16;
    }

    public byte[] doFinal(byte[] data) throws DataLengthException, IllegalStateException {
        int tagLen = this.aeadParameters.getMacSize();
        byte[] nonce = this.aeadParameters.getNonce();
        byte[] aad = this.aeadParameters.getAssociatedText();
        try {
            if (this.forEncryption) {
                return this.sdfSDK.encryptAead(this.phKeyHandle, SdfAlgIdAead.SGD_AES_CCM_128.getId(), tagLen, nonce, aad, data);
            }
            return this.sdfSDK.decryptAead(this.phKeyHandle, SdfAlgIdAead.SGD_AES_CCM_128.getId(), tagLen, nonce, aad, data);
        }
        catch (SdfSDKException e) {
            this.logger.error("doFinal forEncryption={} tagLen={}", (Object)this.forEncryption, (Object)tagLen);
            GMSSLByteArrayUtils.printHexBinary(this.logger, "doFinal key", this.key, true);
            GMSSLByteArrayUtils.printHexBinary(this.logger, "doFinal nonce", nonce, true);
            GMSSLByteArrayUtils.printHexBinary(this.logger, "doFinal aad", aad, true);
            GMSSLByteArrayUtils.printHexBinary(this.logger, "doFinal in", data, true);
            this.logger.error("doFinal error", e);
            throw new IllegalStateException(e.getMessage());
        }
    }

    public void reset() {
    }

    public void release() throws SdfSDKException {
        if (this.sdfSDK != null && this.phKeyHandle != null) {
            this.sdfSDK.destroyKey(this.phKeyHandle);
            this.sdfSDK.release();
        }
    }
}

