/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.sdf;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfRSAKeyParameters;
import com.xdja.pki.gmssl.crypto.sdf.SdfSHADigest;
import com.xdja.pki.gmssl.crypto.sdf.SdfSigner;
import com.xdja.pki.gmssl.sdf.SdfSDK;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdHash;
import com.xdja.pki.gmssl.sdf.bean.SdfRSAPublicKey;
import java.io.IOException;
import java.security.interfaces.RSAPublicKey;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdfRSASigner
extends SdfSigner {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private SdfSHADigest sdfSHADigest;
    private SdfRSAKeyParameters keyParameters;
    private AlgorithmIdentifier algId;

    public SdfRSASigner(SdfCryptoType sdfCryptoType, ASN1ObjectIdentifier aid) throws SdfSDKException {
        this(sdfCryptoType, SdfAlgIdHash.converSdfAlgIdHash(aid));
    }

    public SdfRSASigner(SdfCryptoType sdfCryptoType, AlgorithmIdentifier algorithm) throws SdfSDKException {
        this(sdfCryptoType, algorithm.getAlgorithm());
    }

    public SdfRSASigner(SdfAlgIdHash sdfAlgIdHash) throws SdfSDKException {
        this(SdfCryptoType.YUNHSM, sdfAlgIdHash);
    }

    public SdfRSASigner(SdfCryptoType sdfCryptoType, SdfAlgIdHash sdfAlgIdHash) throws SdfSDKException {
        this(sdfCryptoType.getSdfSDK(), sdfAlgIdHash);
    }

    public SdfRSASigner(SdfSDK sdfSDK, SdfAlgIdHash sdfAlgIdHash) throws SdfSDKException {
        this.sdfSDK = sdfSDK;
        this.algId = SdfAlgIdHash.convertAlgorithmIdentifier(sdfAlgIdHash);
        if (sdfAlgIdHash == SdfAlgIdHash.SGD_SHA1) {
            this.sdfSHADigest = new SdfSHADigest(sdfSDK, SdfAlgIdHash.SGD_SHA1);
        } else if (sdfAlgIdHash == SdfAlgIdHash.SGD_SHA256) {
            this.sdfSHADigest = new SdfSHADigest(sdfSDK, SdfAlgIdHash.SGD_SHA256);
        } else {
            throw new SdfSDKException("unsupported " + sdfAlgIdHash.getName() + " hash type");
        }
        this.sdfSDK.init();
    }

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        this.keyParameters = (SdfRSAKeyParameters)param;
    }

    @Override
    public void update(byte b) {
        byte[] bytes = new byte[]{b};
        this.update(bytes, 0, bytes.length);
    }

    @Override
    public void update(byte[] in, int off, int len) {
        this.sdfSHADigest.update(in, off, len);
    }

    @Override
    public byte[] generateSignature() throws DataLengthException {
        try {
            byte[] out = new byte[this.sdfSHADigest.getDigestSize()];
            this.sdfSHADigest.doFinal(out, 0);
            byte[] data = this.derEncode(out);
            byte[] sign = this.sdfSDK.internalPrivateKeyOperationRsa(this.keyParameters.getPrivateKeyIndex(), this.keyParameters.getPassword(), data);
            return sign;
        }
        catch (Exception e) {
            this.logger.error("generateSignature", e);
            return new byte[0];
        }
    }

    @Override
    public boolean verifySignature(byte[] signature) {
        try {
            byte[] out = new byte[this.sdfSHADigest.getDigestSize()];
            this.sdfSHADigest.doFinal(out, 0);
            byte[] normal = this.derEncode(out);
            RSAPublicKey rsaPublicKey = this.keyParameters.getPublicKey();
            SdfRSAPublicKey sdfRSAPublicKey = SdfRSAPublicKey.getInstance(rsaPublicKey);
            byte[] verify = this.sdfSDK.externalPublicKeyOperationRsa(sdfRSAPublicKey, signature);
            byte[] data = new byte[normal.length];
            System.arraycopy(verify, verify.length - normal.length, data, 0, data.length);
            return GMSSLByteArrayUtils.isEqual(normal, data);
        }
        catch (Exception e) {
            if (signature != null) {
                GMSSLByteArrayUtils.printHexBinary(this.logger, "verifySignature signature", signature);
            }
            this.logger.error("verifySignature", e);
            return false;
        }
    }

    @Override
    public void reset() {
    }

    private byte[] derEncode(byte[] hash) throws IOException {
        DigestInfo dInfo = new DigestInfo(this.algId, hash);
        return dInfo.getEncoded("DER");
    }
}

