/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.sdf;

import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdSymmetric;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import org.bouncycastle.crypto.CipherParameters;

public class SdfSymmetricKeyParameters
implements CipherParameters {
    private byte[] key;
    private KeyCipherType keyCipherType;
    private final PaddingType paddingType;
    private SdfAlgIdSymmetric sdfAlgIdBlockCipher;
    private SdfPrivateKey sdfPrivateKey;
    private PublicKey publicKey;

    public SdfSymmetricKeyParameters(PaddingType paddingType, SdfAlgIdSymmetric sdfAlgIdSymmetric, SdfPrivateKey sdfPrivateKey, byte[] cipherKey) {
        this(KeyCipherType.ECC_CIPHER, paddingType, sdfAlgIdSymmetric, sdfPrivateKey, null, cipherKey, 0, cipherKey.length);
    }

    public SdfSymmetricKeyParameters(PaddingType paddingType, SdfAlgIdSymmetric sdfAlgIdSymmetric, byte[] key) {
        this(KeyCipherType.PLAIN, paddingType, sdfAlgIdSymmetric, null, null, key, 0, key.length);
    }

    public SdfSymmetricKeyParameters(PaddingType paddingType, SdfAlgIdSymmetric sdfAlgIdSymmetric, ECPublicKey publicKey) {
        this(KeyCipherType.NONE, paddingType, sdfAlgIdSymmetric, null, publicKey, null, 0, 0);
    }

    public SdfSymmetricKeyParameters(KeyCipherType keyCipherType, PaddingType paddingType, SdfAlgIdSymmetric sdfAlgIdSymmetric, SdfPrivateKey sdfPrivateKey, PublicKey publicKey, byte[] key, int keyOff, int keyLen) {
        if (keyCipherType == KeyCipherType.ECC_CIPHER && sdfPrivateKey == null) {
            throw new IllegalArgumentException("key cipher type is ecc, private key is not null");
        }
        this.keyCipherType = keyCipherType;
        this.paddingType = paddingType;
        this.sdfAlgIdBlockCipher = sdfAlgIdSymmetric;
        this.sdfPrivateKey = sdfPrivateKey;
        this.publicKey = publicKey;
        if (keyLen > 0) {
            this.key = new byte[keyLen];
            System.arraycopy(key, keyOff, this.key, 0, keyLen);
        }
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public byte[] getKey() {
        return this.key;
    }

    public KeyCipherType getKeyCipherType() {
        return this.keyCipherType;
    }

    public PaddingType getPaddingType() {
        return this.paddingType;
    }

    public SdfAlgIdSymmetric getSdfAlgIdBlockCipher() {
        return this.sdfAlgIdBlockCipher;
    }

    public SdfPrivateKey getSdfPrivateKey() {
        return this.sdfPrivateKey;
    }

    public static enum PaddingType {
        NoPadding,
        PKCS5Padding,
        PKCS7Padding,
        SSL3Padding;

    }

    public static enum KeyCipherType {
        NONE,
        PLAIN,
        ECC_CIPHER;

    }
}

