/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.utils;

import com.xdja.SafeKey.utils.MiniPcieXKFUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.crypto.init.GMSSLPkiCryptoInit;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfRandom;
import com.xdja.pki.gmssl.crypto.utils.sanc.GMSSLSancConnectionUtils;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLCryptoType;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;

public class GMSSLRandomUtils {
    public static byte[] generateRandom(int length) throws Exception {
        switch (GMSSLPkiCryptoInit.getCryptoType()) {
            case PCI_E: {
                SdfRandom pcieRandom = new SdfRandom(SdfCryptoType.PCIE);
                return pcieRandom.generateRandom(length);
            }
            case XDJA_HSM: {
                SdfRandom hsmRandom = new SdfRandom(SdfCryptoType.YUNHSM);
                return hsmRandom.generateRandom(length);
            }
            case MINI_PCI_E: {
                return MiniPcieXKFUtils.generateRandom(length);
            }
            case SANC_HSM: {
                return GMSSLSancConnectionUtils.getCryptConnection().generateRandom(length);
            }
        }
        return com.xdja.pki.gmssl.core.utils.GMSSLRandomUtils.generateRandom(length);
    }

    public static String generateRandomByYunhsm(int len) throws Exception {
        return GMSSLRandomUtils.generateRandomBySdf(SdfCryptoType.YUNHSM, len);
    }

    public static String generateRandomByPcie(int len) throws Exception {
        return GMSSLRandomUtils.generateRandomBySdf(SdfCryptoType.PCIE, len);
    }

    public static String generateRandomBySdf(SdfCryptoType sdfCryptoType, int len) throws Exception {
        if (GMSSLPkiCryptoInit.getCryptoType() == GMSSLCryptoType.SANC_HSM) {
            return Base64.toBase64String(GMSSLRandomUtils.generateRandom(len));
        }
        SdfRandom sdfRandom = new SdfRandom(sdfCryptoType);
        byte[] random = sdfRandom.generateRandom(len);
        return GMSSLByteArrayUtils.base64Encode(random);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
    }
}

