/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.utils;

import com.sansec.devicev4.api.ISDSCrypto;
import com.xdja.SafeKey.utils.MiniPcieSymmetricEncryptUtils;
import com.xdja.SafeKey.utils.MiniPcieXKFUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.pki.gmssl.crypto.init.GMSSLPkiCryptoInit;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfSymmetricKeyParameters;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSymmetricEncryptUtils;
import com.xdja.pki.gmssl.crypto.utils.sanc.GMSSLSancConnectionUtils;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdSymmetric;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLCryptoType;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class GMSSLSM1CBCEncryptUtils {
    public static byte[] encrypt(byte[] key, byte[] data, byte[] iv, SdfSymmetricKeyParameters.PaddingType paddingType) throws Exception {
        switch (GMSSLPkiCryptoInit.getCryptoType()) {
            case PCI_E: {
                return GMSSLSM1CBCEncryptUtils.sm1SymmetricSdfWithPadding(true, SdfCryptoType.PCIE, paddingType, key, iv, data);
            }
            case XDJA_HSM: {
                return GMSSLSM1CBCEncryptUtils.sm1SymmetricSdfWithPadding(true, SdfCryptoType.YUNHSM, paddingType, key, iv, data);
            }
            case MINI_PCI_E: {
                switch (paddingType) {
                    case NoPadding: {
                        return MiniPcieXKFUtils.sm1(key, data, 17, iv);
                    }
                    case PKCS7Padding: 
                    case PKCS5Padding: {
                        return MiniPcieSymmetricEncryptUtils.sm1CbcWithPkcs5Padding(key, data, iv, true);
                    }
                }
                return MiniPcieSymmetricEncryptUtils.sm1CbcWithSslv3Padding(key, data, iv, true);
            }
            case SANC_HSM: {
                ISDSCrypto cryptConnection = GMSSLSancConnectionUtils.getCryptConnection();
                switch (paddingType) {
                    case NoPadding: {
                        return cryptConnection.encrypt(258, key, iv, data);
                    }
                    case PKCS7Padding: 
                    case PKCS5Padding: {
                        data = GMSSLX509Utils.paddingData(data, true);
                        return cryptConnection.encrypt(258, key, iv, data);
                    }
                }
                data = GMSSLX509Utils.paddingData(data, false);
                return cryptConnection.encrypt(258, key, iv, data);
            }
        }
        throw new IllegalArgumentException("un support the sm1 cbc encrypt method with the crypto " + (Object)((Object)GMSSLPkiCryptoInit.getCryptoType()));
    }

    public static byte[] decrypt(byte[] key, byte[] data, byte[] iv, SdfSymmetricKeyParameters.PaddingType paddingType) throws Exception {
        switch (GMSSLPkiCryptoInit.getCryptoType()) {
            case PCI_E: {
                return GMSSLSM1CBCEncryptUtils.sm1SymmetricSdfWithPadding(false, SdfCryptoType.PCIE, paddingType, key, iv, data);
            }
            case XDJA_HSM: {
                return GMSSLSM1CBCEncryptUtils.sm1SymmetricSdfWithPadding(false, SdfCryptoType.YUNHSM, paddingType, key, iv, data);
            }
            case MINI_PCI_E: {
                switch (paddingType) {
                    case NoPadding: {
                        return MiniPcieXKFUtils.sm1(key, data, 16, iv);
                    }
                    case PKCS7Padding: 
                    case PKCS5Padding: {
                        return MiniPcieSymmetricEncryptUtils.sm1CbcWithPkcs5Padding(key, data, iv, false);
                    }
                }
                return MiniPcieSymmetricEncryptUtils.sm1CbcWithSslv3Padding(key, data, iv, false);
            }
            case SANC_HSM: {
                ISDSCrypto cryptConnection = GMSSLSancConnectionUtils.getCryptConnection();
                switch (paddingType) {
                    case NoPadding: {
                        return cryptConnection.decrypt(258, key, iv, data);
                    }
                    case PKCS7Padding: 
                    case PKCS5Padding: {
                        byte[] decrypt = cryptConnection.decrypt(258, key, iv, data);
                        return GMSSLX509Utils.removePadding(data, decrypt, true);
                    }
                }
                byte[] decryptSsl3 = cryptConnection.decrypt(258, key, iv, data);
                return GMSSLX509Utils.removePadding(data, decryptSsl3, false);
            }
        }
        throw new IllegalArgumentException("un support the sm1 cbc decrypt method with the crypto " + (Object)((Object)GMSSLPkiCryptoInit.getCryptoType()));
    }

    public static String encryptByYumhsmWithNoPadding(String base64Key, String base64Data, String base64InitIv) throws Exception {
        return GMSSLByteArrayUtils.base64Encode(GMSSLSM1CBCEncryptUtils.sm1SymmetricSdfWithPadding(true, SdfCryptoType.YUNHSM, SdfSymmetricKeyParameters.PaddingType.NoPadding, GMSSLByteArrayUtils.base64Decode(base64Key), GMSSLByteArrayUtils.base64Decode(base64InitIv), GMSSLByteArrayUtils.base64Decode(base64Data)));
    }

    public static String encryptByYumhsmWithPKCS5Padding(String base64Key, String base64Data, String base64InitIv) throws Exception {
        return GMSSLByteArrayUtils.base64Encode(GMSSLSM1CBCEncryptUtils.sm1SymmetricSdfWithPadding(true, SdfCryptoType.YUNHSM, SdfSymmetricKeyParameters.PaddingType.PKCS5Padding, GMSSLByteArrayUtils.base64Decode(base64Key), GMSSLByteArrayUtils.base64Decode(base64InitIv), GMSSLByteArrayUtils.base64Decode(base64Data)));
    }

    public static String encryptByYumhsmWithPKCS7Padding(String base64Key, String base64Data, String base64InitIv) throws Exception {
        return GMSSLByteArrayUtils.base64Encode(GMSSLSM1CBCEncryptUtils.sm1SymmetricSdfWithPadding(true, SdfCryptoType.YUNHSM, SdfSymmetricKeyParameters.PaddingType.PKCS7Padding, GMSSLByteArrayUtils.base64Decode(base64Key), GMSSLByteArrayUtils.base64Decode(base64InitIv), GMSSLByteArrayUtils.base64Decode(base64Data)));
    }

    public static String encryptByYumhsmWithSSL3Padding(String base64Key, String base64Data, String base64InitIv) throws Exception {
        return GMSSLByteArrayUtils.base64Encode(GMSSLSM1CBCEncryptUtils.sm1SymmetricSdfWithPadding(true, SdfCryptoType.YUNHSM, SdfSymmetricKeyParameters.PaddingType.SSL3Padding, GMSSLByteArrayUtils.base64Decode(base64Key), GMSSLByteArrayUtils.base64Decode(base64InitIv), GMSSLByteArrayUtils.base64Decode(base64Data)));
    }

    public static String decryptByYumhsmWithNoPadding(String base64Key, String base64Cipher, String base64InitIv) throws Exception {
        return GMSSLByteArrayUtils.base64Encode(GMSSLSM1CBCEncryptUtils.sm1SymmetricSdfWithPadding(false, SdfCryptoType.YUNHSM, SdfSymmetricKeyParameters.PaddingType.NoPadding, GMSSLByteArrayUtils.base64Decode(base64Key), GMSSLByteArrayUtils.base64Decode(base64InitIv), GMSSLByteArrayUtils.base64Decode(base64Cipher)));
    }

    public static String decryptByYumhsmWithPKCS5Padding(String base64Key, String base64Cipher, String base64InitIv) throws Exception {
        return GMSSLByteArrayUtils.base64Encode(GMSSLSM1CBCEncryptUtils.sm1SymmetricSdfWithPadding(false, SdfCryptoType.YUNHSM, SdfSymmetricKeyParameters.PaddingType.PKCS5Padding, GMSSLByteArrayUtils.base64Decode(base64Key), GMSSLByteArrayUtils.base64Decode(base64InitIv), GMSSLByteArrayUtils.base64Decode(base64Cipher)));
    }

    public static String decryptByYumhsmWithPKCS7Padding(String base64Key, String base64Cipher, String base64InitIv) throws Exception {
        return GMSSLByteArrayUtils.base64Encode(GMSSLSM1CBCEncryptUtils.sm1SymmetricSdfWithPadding(false, SdfCryptoType.YUNHSM, SdfSymmetricKeyParameters.PaddingType.PKCS7Padding, GMSSLByteArrayUtils.base64Decode(base64Key), GMSSLByteArrayUtils.base64Decode(base64InitIv), GMSSLByteArrayUtils.base64Decode(base64Cipher)));
    }

    public static String decryptByYumhsmWithSSL3Padding(String base64Key, String base64Cipher, String base64InitIv) throws Exception {
        return GMSSLByteArrayUtils.base64Encode(GMSSLSM1CBCEncryptUtils.sm1SymmetricSdfWithPadding(false, SdfCryptoType.YUNHSM, SdfSymmetricKeyParameters.PaddingType.SSL3Padding, GMSSLByteArrayUtils.base64Decode(base64Key), GMSSLByteArrayUtils.base64Decode(base64InitIv), GMSSLByteArrayUtils.base64Decode(base64Cipher)));
    }

    public static String encryptByPcieWithNoPadding(String base64Key, String base64Data, String base64InitIv) throws Exception {
        return GMSSLByteArrayUtils.base64Encode(GMSSLSM1CBCEncryptUtils.sm1SymmetricSdfWithPadding(true, SdfCryptoType.PCIE, SdfSymmetricKeyParameters.PaddingType.NoPadding, GMSSLByteArrayUtils.base64Decode(base64Key), GMSSLByteArrayUtils.base64Decode(base64InitIv), GMSSLByteArrayUtils.base64Decode(base64Data)));
    }

    public static String encryptByPcieWithPKCS5Padding(String base64Key, String base64Data, String base64InitIv) throws Exception {
        return GMSSLByteArrayUtils.base64Encode(GMSSLSM1CBCEncryptUtils.sm1SymmetricSdfWithPadding(true, SdfCryptoType.PCIE, SdfSymmetricKeyParameters.PaddingType.PKCS5Padding, GMSSLByteArrayUtils.base64Decode(base64Key), GMSSLByteArrayUtils.base64Decode(base64InitIv), GMSSLByteArrayUtils.base64Decode(base64Data)));
    }

    public static String encryptByPcieWithPKCS7Padding(String base64Key, String base64Data, String base64InitIv) throws Exception {
        return GMSSLByteArrayUtils.base64Encode(GMSSLSM1CBCEncryptUtils.sm1SymmetricSdfWithPadding(true, SdfCryptoType.PCIE, SdfSymmetricKeyParameters.PaddingType.PKCS7Padding, GMSSLByteArrayUtils.base64Decode(base64Key), GMSSLByteArrayUtils.base64Decode(base64InitIv), GMSSLByteArrayUtils.base64Decode(base64Data)));
    }

    public static String encryptByPcieWithSSL3Padding(String base64Key, String base64Data, String base64InitIv) throws Exception {
        return GMSSLByteArrayUtils.base64Encode(GMSSLSM1CBCEncryptUtils.sm1SymmetricSdfWithPadding(true, SdfCryptoType.PCIE, SdfSymmetricKeyParameters.PaddingType.SSL3Padding, GMSSLByteArrayUtils.base64Decode(base64Key), GMSSLByteArrayUtils.base64Decode(base64InitIv), GMSSLByteArrayUtils.base64Decode(base64Data)));
    }

    public static String decryptByPcieWithNoPadding(String base64Key, String base64Cipher, String base64InitIv) throws Exception {
        return GMSSLByteArrayUtils.base64Encode(GMSSLSM1CBCEncryptUtils.sm1SymmetricSdfWithPadding(false, SdfCryptoType.PCIE, SdfSymmetricKeyParameters.PaddingType.NoPadding, GMSSLByteArrayUtils.base64Decode(base64Key), GMSSLByteArrayUtils.base64Decode(base64InitIv), GMSSLByteArrayUtils.base64Decode(base64Cipher)));
    }

    public static String decryptByPcieWithPKCS5Padding(String base64Key, String base64Cipher, String base64InitIv) throws Exception {
        return GMSSLByteArrayUtils.base64Encode(GMSSLSM1CBCEncryptUtils.sm1SymmetricSdfWithPadding(false, SdfCryptoType.PCIE, SdfSymmetricKeyParameters.PaddingType.PKCS5Padding, GMSSLByteArrayUtils.base64Decode(base64Key), GMSSLByteArrayUtils.base64Decode(base64InitIv), GMSSLByteArrayUtils.base64Decode(base64Cipher)));
    }

    public static String decryptByPcieWithPKCS7Padding(String base64Key, String base64Cipher, String base64InitIv) throws Exception {
        return GMSSLByteArrayUtils.base64Encode(GMSSLSM1CBCEncryptUtils.sm1SymmetricSdfWithPadding(false, SdfCryptoType.PCIE, SdfSymmetricKeyParameters.PaddingType.PKCS7Padding, GMSSLByteArrayUtils.base64Decode(base64Key), GMSSLByteArrayUtils.base64Decode(base64InitIv), GMSSLByteArrayUtils.base64Decode(base64Cipher)));
    }

    public static String decryptByPcieWithSSL3Padding(String base64Key, String base64Cipher, String base64InitIv) throws Exception {
        return GMSSLByteArrayUtils.base64Encode(GMSSLSM1CBCEncryptUtils.sm1SymmetricSdfWithPadding(false, SdfCryptoType.PCIE, SdfSymmetricKeyParameters.PaddingType.SSL3Padding, GMSSLByteArrayUtils.base64Decode(base64Key), GMSSLByteArrayUtils.base64Decode(base64InitIv), GMSSLByteArrayUtils.base64Decode(base64Cipher)));
    }

    public static byte[] sm1SymmetricWithPaddingByYunHsm(boolean forEncryption, SdfSymmetricKeyParameters.PaddingType paddingType, byte[] key, byte[] iv, byte[] data) throws Exception {
        return GMSSLSymmetricEncryptUtils.symmetricCBCEncryptBySdf(forEncryption, SdfCryptoType.YUNHSM, paddingType, key, SdfAlgIdSymmetric.SGD_SM1_CBC, iv, data);
    }

    public static byte[] sm1SymmetricWithPaddingByPCIE(boolean forEncryption, SdfSymmetricKeyParameters.PaddingType paddingType, byte[] key, byte[] iv, byte[] data) throws Exception {
        return GMSSLSymmetricEncryptUtils.symmetricCBCEncryptBySdf(forEncryption, SdfCryptoType.PCIE, paddingType, key, SdfAlgIdSymmetric.SGD_SM1_CBC, iv, data);
    }

    public static byte[] sm1SymmetricSdfWithPadding(boolean forEncryption, SdfCryptoType sdfCryptoType, SdfSymmetricKeyParameters.PaddingType paddingType, byte[] key, byte[] iv, byte[] data) throws Exception {
        if (GMSSLPkiCryptoInit.getCryptoType() == GMSSLCryptoType.SANC_HSM) {
            if (forEncryption) {
                return GMSSLSM1CBCEncryptUtils.encrypt(key, data, iv, paddingType);
            }
            return GMSSLSM1CBCEncryptUtils.decrypt(key, data, iv, paddingType);
        }
        return GMSSLSymmetricEncryptUtils.symmetricCBCEncryptBySdf(forEncryption, sdfCryptoType, paddingType, key, SdfAlgIdSymmetric.SGD_SM1_CBC, iv, data);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
    }
}

