/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.utils;

import com.xdja.pki.gmssl.crypto.init.GMSSLPkiCryptoInit;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfSymmetricCipher;
import com.xdja.pki.gmssl.crypto.sdf.SdfSymmetricKeyParameters;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM1CBCEncryptUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM1ECBEncryptUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM4CBCEncryptUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM4ECBEncryptUtils;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdSymmetric;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLCryptoType;
import java.security.Key;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class GMSSLSymmetricEncryptUtils {
    private static final String SM4_ALGORITHM = "SM4";

    public static byte[] symmetricCBCEncryptByBC(boolean forEncryption, EncryptTypeByBC encryptType, byte[] key, byte[] data, byte[] initIV) throws Exception {
        Cipher cipher = Cipher.getInstance(encryptType.getName(), "BC");
        SecretKeySpec keySpec = new SecretKeySpec(key, SM4_ALGORITHM);
        if (forEncryption) {
            cipher.init(1, (Key)keySpec, new IvParameterSpec(initIV));
        } else {
            cipher.init(2, (Key)keySpec, new IvParameterSpec(initIV));
        }
        return cipher.doFinal(data);
    }

    public static byte[] symmetricECBEncryptByBC(boolean forEncryption, EncryptTypeByBC encryptType, byte[] key, byte[] data) throws Exception {
        Cipher cipher = Cipher.getInstance(encryptType.getName(), "BC");
        SecretKeySpec keySpec = new SecretKeySpec(key, SM4_ALGORITHM);
        if (forEncryption) {
            cipher.init(1, keySpec);
        } else {
            cipher.init(2, keySpec);
        }
        return cipher.doFinal(data);
    }

    public static byte[] symmetricECBEncryptBySdf(boolean forEncryption, SdfCryptoType sdfCryptoType, SdfSymmetricKeyParameters.PaddingType paddingType, byte[] key, SdfAlgIdSymmetric symmetric, byte[] data) throws Exception {
        if (GMSSLPkiCryptoInit.getCryptoType() == GMSSLCryptoType.SANC_HSM) {
            if (symmetric == SdfAlgIdSymmetric.SGD_SM4_ECB) {
                if (forEncryption) {
                    return GMSSLSM4ECBEncryptUtils.encrypt(key, data, paddingType);
                }
                return GMSSLSM4ECBEncryptUtils.decrypt(key, data, paddingType);
            }
            if (forEncryption) {
                return GMSSLSM1ECBEncryptUtils.encrypt(key, data, paddingType);
            }
            return GMSSLSM1ECBEncryptUtils.decrypt(key, data, paddingType);
        }
        SdfSymmetricKeyParameters param = new SdfSymmetricKeyParameters(paddingType, symmetric, key);
        SdfSymmetricCipher sdfSymmetric = new SdfSymmetricCipher(sdfCryptoType);
        sdfSymmetric.init(forEncryption, param);
        byte[] output = sdfSymmetric.doFinal(data);
        sdfSymmetric.release();
        return output;
    }

    public static byte[] symmetricCBCEncryptBySdf(boolean forEncryption, SdfCryptoType sdfCryptoType, SdfSymmetricKeyParameters.PaddingType paddingType, byte[] key, SdfAlgIdSymmetric symmetric, byte[] iv, byte[] data) throws Exception {
        if (GMSSLPkiCryptoInit.getCryptoType() == GMSSLCryptoType.SANC_HSM) {
            if (symmetric == SdfAlgIdSymmetric.SGD_SM4_CBC) {
                if (forEncryption) {
                    return GMSSLSM4CBCEncryptUtils.encrypt(key, data, iv, paddingType);
                }
                return GMSSLSM4CBCEncryptUtils.decrypt(key, data, iv, paddingType);
            }
            if (forEncryption) {
                return GMSSLSM1CBCEncryptUtils.encrypt(key, data, iv, paddingType);
            }
            return GMSSLSM1CBCEncryptUtils.decrypt(key, data, iv, paddingType);
        }
        SdfSymmetricKeyParameters param = new SdfSymmetricKeyParameters(paddingType, symmetric, key);
        ParametersWithIV ivParam = new ParametersWithIV(param, iv);
        SdfSymmetricCipher sdfSymmetric = new SdfSymmetricCipher(sdfCryptoType);
        sdfSymmetric.init(forEncryption, ivParam);
        byte[] output = sdfSymmetric.doFinal(data);
        sdfSymmetric.release();
        return output;
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
    }

    public static enum EncryptTypeByBC {
        SM4_ECB_NoPadding("SM4/ECB/NoPadding"),
        SM4_ECB_PKCS5Padding("SM4/ECB/PKCS5Padding"),
        SM4_ECB_PKCS7Padding("SM4/ECB/PKCS7Padding"),
        SM4_CBC_NoPadding("SM4/CBC/NoPadding"),
        SM4_CBC_PKCS5Padding("SM4/CBC/PKCS5Padding"),
        SM4_CBC_PKCS7Padding("SM4/CBC/PKCS7Padding"),
        AES_CCM_NoPadding("AES/CCM/NoPadding");

        private String name;

        private EncryptTypeByBC(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

