/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.utils.sanc;

import com.sansec.devicev4.gb.struct.key.IRSArefPrivateKey;
import com.sansec.devicev4.gb.struct.key.IRSArefPublicKey;
import com.sansec.devicev4.gb.struct.key.rsa.RSArefPublicKeyLite;
import com.sansec.devicev4.gb.struct.key.sm2.SM2refPrivateKey;
import com.sansec.devicev4.gb.struct.key.sm2.SM2refPublicKey;
import com.sansec.devicev4.gb.struct.key.sm2.SM2refSignature;
import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLRSAUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPublicKey;
import org.bouncycastle.util.BigIntegers;

public class GMSSLSancConverUtils {
    public static PublicKey converSM2PublicKey(SM2refPublicKey sm2refPublicKey) throws Exception {
        return GMSSLX509Utils.convertSM2PublicKey(sm2refPublicKey.getX(), sm2refPublicKey.getY());
    }

    public static PrivateKey converSM2PrivateKey(SM2refPrivateKey sm2refPrivateKey) throws Exception {
        return GMSSLX509Utils.convertPrivateKeyEncode(sm2refPrivateKey.getD());
    }

    public static SM2refPublicKey converSM2RefPublicKey(PublicKey publicKey) {
        BCECPublicKey bcecPublicKey = (BCECPublicKey)publicKey;
        byte[] x = bcecPublicKey.getW().getAffineX().toByteArray();
        byte[] y = bcecPublicKey.getW().getAffineY().toByteArray();
        return new SM2refPublicKey(GMSSLByteArrayUtils.changeByteArrayLength(x, 32), GMSSLByteArrayUtils.changeByteArrayLength(y, 32));
    }

    public static SM2refPrivateKey converSM2RefPrivateKey(PrivateKey privateKey) throws Exception {
        BCECPrivateKey bcecPrivateKey = (BCECPrivateKey)privateKey;
        byte[] s = bcecPrivateKey.getD().toByteArray();
        return new SM2refPrivateKey(GMSSLByteArrayUtils.changeByteArrayLength(s, 32));
    }

    public static SM2refSignature converSM2RefSignature(byte[] signature) throws Exception {
        BigInteger[] bigIntegers = GMSSLX509Utils.derSignatureDecode(signature);
        assert (bigIntegers != null);
        byte[] r = GMSSLByteArrayUtils.changeByteArrayLength(bigIntegers[0].toByteArray(), 32);
        byte[] s = GMSSLByteArrayUtils.changeByteArrayLength(bigIntegers[1].toByteArray(), 32);
        return new SM2refSignature(r, s);
    }

    public static byte[] converSM2Signature(SM2refSignature refSignature) throws Exception {
        return GMSSLX509Utils.derSignatureEncode(refSignature.getR(), refSignature.getS());
    }

    public static IRSArefPublicKey converRSARefPublicKey(PublicKey publicKey) throws Exception {
        BCRSAPublicKey rsaPublicKey = (BCRSAPublicKey)publicKey;
        RSArefPublicKeyLite rsArefPublicKeyLite = new RSArefPublicKeyLite();
        rsArefPublicKeyLite.bits = rsaPublicKey.getModulus().bitLength();
        rsArefPublicKeyLite.e = GMSSLByteArrayUtils.changeByteArrayLength(rsaPublicKey.getPublicExponent().toByteArray(), 256);
        rsArefPublicKeyLite.m = GMSSLByteArrayUtils.changeByteArrayLength(rsaPublicKey.getModulus().toByteArray(), 256);
        return rsArefPublicKeyLite;
    }

    public static PublicKey converRSAPublicKey(IRSArefPublicKey arefPublicKey) throws Exception {
        return GMSSLRSAUtils.convertRSAPublicKey(arefPublicKey.getM());
    }

    public static PrivateKey converRSAPrivateKey(IRSArefPrivateKey arefPrivateKey) throws Exception {
        return GMSSLRSAUtils.convertRSAPrivateKey(BigIntegers.fromUnsignedByteArray(arefPrivateKey.getM()), BigIntegers.fromUnsignedByteArray(arefPrivateKey.getE()), BigIntegers.fromUnsignedByteArray(arefPrivateKey.getD()), BigIntegers.fromUnsignedByteArray(arefPrivateKey.getPrime1()), BigIntegers.fromUnsignedByteArray(arefPrivateKey.getPrime2()), BigIntegers.fromUnsignedByteArray(arefPrivateKey.getPexp1()), BigIntegers.fromUnsignedByteArray(arefPrivateKey.getPexp2()), BigIntegers.fromUnsignedByteArray(arefPrivateKey.getCoef()));
    }
}

