/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.utils.sanc;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.crypto.utils.GMSSLECSignUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLRSASignUtils;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLSignatureAlgorithm;
import java.io.OutputStream;
import java.security.PublicKey;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class GMSSLSancSignatureOutputStream
extends OutputStream {
    private int index;
    private PublicKey publicKey;
    private byte[] data = new byte[0];
    private AlgorithmIdentifier algorithmIdentifier;
    private String signAlgName;

    GMSSLSancSignatureOutputStream(int index, String signAlgName) {
        this.signAlgName = signAlgName;
        this.index = index;
        this.algorithmIdentifier = GMSSLSignatureAlgorithm.convertAlgorithmIdentifier(signAlgName);
    }

    GMSSLSancSignatureOutputStream(PublicKey publicKey, AlgorithmIdentifier algorithmIdentifier) {
        this.publicKey = publicKey;
        this.algorithmIdentifier = algorithmIdentifier;
        this.signAlgName = GMSSLSignatureAlgorithm.convertContentSignatureAlgorithm(algorithmIdentifier).getSigAlgName();
    }

    @Override
    public void write(byte[] bytes, int off, int len) {
        byte[] tmp = new byte[len];
        System.arraycopy(bytes, off, tmp, 0, len);
        this.data = GMSSLByteArrayUtils.mergeByteArray(this.data, tmp);
    }

    @Override
    public void write(byte[] bytes) {
        this.data = GMSSLByteArrayUtils.mergeByteArray(this.data, bytes);
    }

    @Override
    public void write(int var1) {
        byte[] tmp = new byte[]{(byte)var1};
        this.data = GMSSLByteArrayUtils.mergeByteArray(this.data, tmp);
    }

    byte[] getSignature() throws Exception {
        if (PKCSObjectIdentifiers.sha256WithRSAEncryption.getId().equalsIgnoreCase(this.algorithmIdentifier.getAlgorithm().getId())) {
            return GMSSLRSASignUtils.sign(new SdfPrivateKey(this.index), this.data, this.signAlgName);
        }
        if (PKCSObjectIdentifiers.sha1WithRSAEncryption.getId().equalsIgnoreCase(this.algorithmIdentifier.getAlgorithm().getId())) {
            return GMSSLRSASignUtils.sign(new SdfPrivateKey(this.index), this.data, this.signAlgName);
        }
        if (GMObjectIdentifiers.sm2sign_with_sm3.getId().equalsIgnoreCase(this.algorithmIdentifier.getAlgorithm().getId())) {
            return GMSSLECSignUtils.sign(new SdfPrivateKey(this.index), this.data, null, this.signAlgName);
        }
        throw new SdfSDKException("sanc hsm  un support algorithmIdentifier: " + this.algorithmIdentifier.getAlgorithm().getId());
    }

    boolean verify(byte[] expected) throws Exception {
        if (PKCSObjectIdentifiers.sha256WithRSAEncryption.getId().equalsIgnoreCase(this.algorithmIdentifier.getAlgorithm().getId())) {
            return GMSSLRSASignUtils.verify(this.publicKey, this.data, expected, this.signAlgName);
        }
        if (PKCSObjectIdentifiers.sha1WithRSAEncryption.getId().equalsIgnoreCase(this.algorithmIdentifier.getAlgorithm().getId())) {
            return GMSSLRSASignUtils.verify(this.publicKey, this.data, expected, this.signAlgName);
        }
        if (GMObjectIdentifiers.sm2sign_with_sm3.getId().equalsIgnoreCase(this.algorithmIdentifier.getAlgorithm().getId())) {
            boolean verify = GMSSLECSignUtils.verify(this.publicKey, this.data, expected, null, this.signAlgName);
            System.out.println(verify);
            return verify;
        }
        throw new SdfSDKException("sanc hsm  un support algorithmIdentifier: " + this.algorithmIdentifier.getAlgorithm().getId());
    }
}

