/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.sdf.pcie;

import com.xdja.pcie.SDFAPI;
import com.xdja.pcie.base.DeviceInfo;
import com.xdja.pcie.base.ECCPrivateKey;
import com.xdja.pcie.base.ECCPublicKey;
import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.bean.SdfApiCode;
import com.xdja.pki.gmssl.sdf.bean.SdfECCPublicKey;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcieSdfSDKUtils {
    private static Logger logger = LoggerFactory.getLogger(PcieSdfSDKUtils.class);

    public static ECCPublicKey generateEccPublicKey(Logger logger, PublicKey key) {
        ECPublicKey ecPublicKey = (ECPublicKey)key;
        return PcieSdfSDKUtils.generateEccPublicKey(logger, GMSSLByteArrayUtils.asUnsignedByteArray32(ecPublicKey.getW().getAffineX()), GMSSLByteArrayUtils.asUnsignedByteArray32(ecPublicKey.getW().getAffineY()));
    }

    public static ECCPublicKey generateEccPublicKey(Logger logger, SdfECCPublicKey key) {
        logger.info(key.toString());
        return PcieSdfSDKUtils.generateEccPublicKey(logger, key.getX(), key.getY());
    }

    public static ECCPublicKey generateEccPublicKey(Logger logger, byte[] x, byte[] y) {
        logger.info("generateEccPublicKey");
        ECCPublicKey pucPublicKey = new ECCPublicKey(256, GMSSLByteArrayUtils.fillByteArrayWithZeroInFoot(x), GMSSLByteArrayUtils.fillByteArrayWithZeroInFoot(y));
        return pucPublicKey;
    }

    public static ECCPrivateKey generateEccPrivateKey(Logger logger, PrivateKey key) {
        ECPrivateKey ecPrivateKey = (ECPrivateKey)key;
        return PcieSdfSDKUtils.generateEccPrivateKey(logger, GMSSLByteArrayUtils.asUnsignedByteArray32(ecPrivateKey.getS()));
    }

    public static ECCPrivateKey generateEccPrivateKey(Logger logger, byte[] k) {
        logger.info("generateEccPrivateKey");
        ECCPrivateKey pucPrivateKey = new ECCPrivateKey(256, GMSSLByteArrayUtils.fillByteArrayWithZeroInFoot(k));
        GMSSLByteArrayUtils.printHexBinary(logger, "pucPrivateKey k", pucPrivateKey.getK());
        return pucPrivateKey;
    }

    public static void checkRet(String method, int ret, long dev, long ses) throws SdfSDKException {
        if (ret != 0) {
            logger.error("{} error! dev = {} session = {} ret = {} HEX={}:{}", method, dev, ses, ret, Integer.toHexString(ret), SdfApiCode.apiCodeToString(ret));
            throw new SdfSDKException(method, ret);
        }
        logger.info(method + " success! dev = " + dev + " session = " + ses);
    }

    public static void openDevice(SDFAPI sdfApi, long[] dev) throws SdfSDKException {
        int ret = sdfApi.openDevice(dev);
        PcieSdfSDKUtils.checkRet("openDevice", ret, dev[0], 0L);
    }

    public static void openSession(SDFAPI sdfApi, long[] dev, long[] ses) throws SdfSDKException {
        int ret = sdfApi.openSession(dev[0], ses);
        PcieSdfSDKUtils.checkRet("openSession", ret, dev[0], ses[0]);
    }

    public static void closeSession(SDFAPI sdfApi, long[] dev, long[] ses) throws SdfSDKException {
        int ret = sdfApi.closeSession(ses[0]);
        PcieSdfSDKUtils.checkRet("closeSession", ret, dev[0], ses[0]);
    }

    public static void closeDevice(SDFAPI sdfApi, long[] dev) throws SdfSDKException {
        int ret = sdfApi.closeDevice(dev[0]);
        PcieSdfSDKUtils.checkRet("closeDevice", ret, dev[0], 0L);
    }

    public static String getDeviceInfo(SDFAPI sdfApi, long[] dev, long[] ses) throws SdfSDKException {
        DeviceInfo deviceInfo = new DeviceInfo();
        int ret = sdfApi.getDeviceInfo(ses[0], deviceInfo);
        PcieSdfSDKUtils.checkRet("getDeviceInfo", ret, dev[0], ses[0]);
        return deviceInfo.toString();
    }

    public static PublicKey getPublicKeyFromCer(String path) throws Exception {
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(path);
        if (inputStream == null) {
            inputStream = new FileInputStream(path);
        }
        CertificateFactory factory = CertificateFactory.getInstance("X.509", "BC");
        X509Certificate certificate = (X509Certificate)factory.generateCertificate(inputStream);
        return certificate.getPublicKey();
    }
}

