/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.sdf.pcie.pool;

import com.xdja.pcie.SDFAPI;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.pcie.PcieSdfSDKUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcieConnection {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private SDFAPI sdfApi;
    private long[] dev;
    private volatile long[] ses = new long[]{0L};
    private int id;
    private long startTime;

    public PcieConnection(SDFAPI sdfApi, long[] dev) throws SdfSDKException {
        this.sdfApi = sdfApi;
        this.dev = dev;
        PcieSdfSDKUtils.openSession(sdfApi, dev, this.ses);
    }

    public SDFAPI getSdfApi() {
        return this.sdfApi;
    }

    public long[] getDev() {
        return this.dev;
    }

    public long[] getSes() {
        return this.ses;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public synchronized void reopen() throws SdfSDKException {
        PcieSdfSDKUtils.closeSession(this.sdfApi, this.dev, this.ses);
        this.ses = new long[]{0L};
        PcieSdfSDKUtils.openSession(this.sdfApi, this.dev, this.ses);
    }

    public synchronized void close() throws SdfSDKException {
        PcieSdfSDKUtils.closeSession(this.sdfApi, this.dev, this.ses);
        this.ses = new long[]{0L};
    }

    public String getDeviceInfo() throws SdfSDKException {
        return PcieSdfSDKUtils.getDeviceInfo(this.sdfApi, this.dev, this.ses);
    }

    public boolean isConnection() {
        try {
            PcieSdfSDKUtils.getDeviceInfo(this.sdfApi, this.dev, this.ses);
            return true;
        }
        catch (SdfSDKException e) {
            this.logger.debug("getDeviceInfo dev = {} session = {}, error={}", this.dev[0], this.ses[0], e);
            return false;
        }
    }
}

